/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.soilWater;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessLumpedSoilWater", author="Peter Krause", description="Calculates soil water balance for each HRU without vertical layers")
public class InitJ2KProcessLumpedSoilWaterStates
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="field capacity adaptation factor")
    public JAMSDouble FCAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="air capacity adaptation factor")
    public JAMSDouble ACAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar rooting depth")
    public JAMSDouble rootDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum MPS")
    public JAMSDouble maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum LPS")
    public JAMSDouble maxLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual MPS")
    public JAMSDouble actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual LPS")
    public JAMSDouble actLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of MPS")
    public JAMSDouble satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of LPS")
    public JAMSDouble satLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of whole soil")
    public JAMSDouble satSoil;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="start saturation of LPS")
    public JAMSDouble satStartLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="start saturation of MPS")
    public JAMSDouble satStartMPS;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        double rootDepth = this.rootDepth.getValue();
        double mxMPS = 0.0;
        String aNameFC = "fc_";
        int d = 0;
        while ((double)d < rootDepth) {
            int count = d + 1;
            String mpsDesc = aNameFC + count;
            double mpsVal = entity.getDouble(mpsDesc);
            mxMPS += mpsVal;
            ++d;
        }
        mxMPS *= this.area.getValue();
        mxMPS *= this.FCAdaptation.getValue();
        double mxLPS = entity.getDouble("aircap") * this.area.getValue();
        mxLPS *= this.ACAdaptation.getValue();
        if (this.satStartLPS != null) {
            this.actLPS.setValue(mxLPS * this.satStartLPS.getValue());
        }
        if (this.satStartMPS != null) {
            this.actMPS.setValue(mxMPS * this.satStartMPS.getValue());
        }
        this.maxMPS.setValue(mxMPS);
        this.maxLPS.setValue(mxLPS);
        this.satMPS.setValue(this.actMPS.getValue() / mxMPS);
        this.satLPS.setValue(this.actLPS.getValue() / mxLPS);
        this.satSoil.setValue((this.actMPS.getValue() + this.actLPS.getValue()) / (mxMPS + mxLPS));
    }

    public void cleanup() {
    }
}

