/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="WASIMProcessSnow", author="Joerg Schulla, implementation and minor adaptations Peter Krause", description="Adaptation of the WASIM module for snow calculation")
public class WASIMSnow_M1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Entity area", unit="m\u00b2")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Entity slope aspect correction factor")
    public JAMSDouble sloAspCorrFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Entity latitude")
    public JAMSDouble latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Entity landuse albedo")
    public JAMSDouble landAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Snow water equivalent", unit="mm")
    public JAMSDouble snowWaterEquivalent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="liquid water in snowpack", unit="mm")
    public JAMSDouble freeWater;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="frozen water in snowpack", unit="mm")
    public JAMSDouble iceContent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="the snow melt")
    public JAMSDouble snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the albedo of the entity")
    public JAMSDouble snowAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="melt temperature: temperature atwhich snow melt will start", unit="C")
    public JAMSDouble meltTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="factor c0 for potential melt rate")
    public JAMSDouble c0Factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Free-water holding capacity (decimal percent) of snowpack expressed as decimal fraction of total snowpack water equivalent")
    public JAMSDouble freeWaterCapacity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="constant albedo of snow")
    public JAMSDouble snowConstAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="rain amount")
    public JAMSDouble rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="snow amount")
    public JAMSDouble snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="precip amount")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="minum temperature", unit="C")
    public JAMSDouble tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="mean temperature", unit="C")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="max temperature", unit="C")
    public JAMSDouble tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="module active")
    public JAMSBoolean active;
    double runRain;
    double runSnow;
    double runIceContent;
    double runFreeWater;
    double runSnowWaterEquivalent;
    double runMeltTemperature;
    double runRadiationMeltFactor;
    double runWind;
    double runPrecip;
    double runSnowMelt;
    double runSnowAlbedo;
    double runAET;

    public void init() {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        if (this.active == null || this.active.getValue()) {
            this.runRain = this.rain.getValue();
            this.runSnow = this.snow.getValue();
            this.runPrecip = this.precip.getValue();
            this.runIceContent = this.iceContent.getValue();
            this.runFreeWater = this.freeWater.getValue();
            this.runSnowWaterEquivalent = this.snowWaterEquivalent.getValue();
            this.runSnowMelt = 0.0;
            this.runSnowAlbedo = this.snowAlbedo.getValue();
            this.runMeltTemperature = this.meltTemp.getValue();
            double tempDay = (this.tmax.getValue() + this.tmean.getValue()) / 2.0;
            double tempNight = (this.tmin.getValue() + this.tmean.getValue()) / 2.0;
            if (this.runSnow > 0.0 || this.runSnowWaterEquivalent > 0.0) {
                int julDay = this.time.get(6);
                double dayFrac = DailySolarRadiationCalculationMethods.calcDayFraction(this.latitude.getValue(), julDay);
                double potMeltRate = this.calcAccumulationAndMelt(tempDay, dayFrac);
                potMeltRate += this.calcAccumulationAndMelt(tempNight, 1.0 - dayFrac);
                potMeltRate *= this.area.getValue();
                this.runRain = 0.0;
                this.runSnow = 0.0;
                if (potMeltRate > this.runIceContent) {
                    potMeltRate = this.runIceContent;
                }
                this.runIceContent -= potMeltRate;
                this.runFreeWater += potMeltRate;
                double maxFreeWater = this.runIceContent * this.freeWaterCapacity.getValue();
                if (maxFreeWater < this.runFreeWater) {
                    this.runSnowMelt = this.runFreeWater - maxFreeWater;
                    this.runFreeWater = maxFreeWater;
                }
                this.runSnowAlbedo = this.runIceContent + this.runFreeWater > 5.0 * this.area.getValue() ? this.snowConstAlbedo.getValue() : this.landAlbedo.getValue();
            }
            this.iceContent.setValue(this.runIceContent);
            this.freeWater.setValue(this.runFreeWater);
            this.snowWaterEquivalent.setValue(this.runIceContent + this.runFreeWater);
            this.snowMelt.setValue(this.runSnowMelt);
            this.snowAlbedo.setValue(this.runSnowAlbedo);
            this.rain.setValue(this.runRain);
            this.snow.setValue(this.runSnow);
        }
    }

    public void cleanup() {
    }

    private double calcAccumulationAndMelt(double temperature, double dayFraction) {
        this.runIceContent += this.runSnow * dayFraction;
        this.runFreeWater += this.runRain * dayFraction;
        double potMeltRate = 0.0;
        potMeltRate = this.runIceContent > 0.0 ? this.c0Factor.getValue() * (temperature - this.runMeltTemperature) : 0.0;
        return potMeltRate * dayFraction;
    }
}

