/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessSnow", author="Peter Krause", description="Calculates the snow course")
public class J2KProcessSnow
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state var slope-aspect-correction-factor")
    public JAMSDouble actSlAsCf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="minimum temperature if available, else mean temp")
    public JAMSDouble minTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="mean temperature")
    public JAMSDouble meanTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum temperature if available, else mean temp")
    public JAMSDouble maxTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable net rain")
    public JAMSDouble netRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable net snow")
    public JAMSDouble netSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="total snow water equivalent")
    public JAMSDouble snowTotSWE;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="dry snow water equivalent")
    public JAMSDouble drySWE;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="total snow density")
    public JAMSDouble totDens;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="dry snow density")
    public JAMSDouble dryDens;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="snow depth")
    public JAMSDouble snowDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="snow age")
    public JAMSDouble snowAge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="snow cold content")
    public JAMSDouble snowColdContent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily snow melt")
    public JAMSDouble snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Snow parameter TRS")
    public JAMSDouble snow_trs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Snow parameter TRANS")
    public JAMSDouble snow_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="temperature factor for snowmelt")
    public JAMSDouble t_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="rain factor for snowmelt")
    public JAMSDouble r_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="ground factor for snowmelt")
    public JAMSDouble g_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="critical density")
    public JAMSDouble snowCritDens;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="cold content factor")
    public JAMSDouble ccf_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="0 - ddf, 1 - complex")
    public JAMSInteger snowMeltFormula;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="module active")
    public JAMSBoolean active;
    double run_area;
    double in_snow;
    double in_rain;
    double run_snowDepth;
    double run_totSWE;
    double run_drySWE;
    double run_initDens = 0.0;
    double run_totDens;
    double run_dryDens;
    double run_snowAge;
    double run_coldContent;
    double run_snowMelt = 0.0;

    public void init() {
        if (this.active == null || this.active.getValue()) {
            this.snowDepth.setValue(0.0);
            this.snowTotSWE.setValue(0.0);
            this.drySWE.setValue(0.0);
            this.totDens.setValue(0.0);
            this.dryDens.setValue(0.0);
            this.snowAge.setValue(0.0);
            this.snowColdContent.setValue(0.0);
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        if (this.active == null || this.active.getValue()) {
            this.run_area = this.area.getValue();
            double SAC = this.actSlAsCf.getValue();
            this.in_snow = this.netSnow.getValue();
            this.in_rain = this.netRain.getValue();
            double balIn = this.in_snow + this.in_rain;
            double in_minTemp = this.minTemp.getValue();
            double in_meanTemp = this.meanTemp.getValue();
            double in_maxTemp = this.maxTemp.getValue();
            this.run_snowDepth = this.snowDepth.getValue();
            double balStorStart = this.run_totSWE = this.snowTotSWE.getValue();
            this.run_drySWE = this.drySWE.getValue();
            this.run_totDens = this.totDens.getValue();
            this.run_dryDens = this.dryDens.getValue();
            this.run_snowAge = this.snowAge.getValue();
            this.run_coldContent = this.snowColdContent.getValue();
            double critDens = this.snowCritDens.getValue();
            double coldContentFactor = this.ccf_factor.getValue();
            double TRS = this.snow_trs.getValue();
            double TRANS = this.snow_trans.getValue();
            double temp_fac = this.t_factor.getValue();
            double rain_fac = this.r_factor.getValue();
            double ground_fac = this.g_factor.getValue();
            this.run_snowMelt = 0.0;
            double out_netRain = 0.0;
            double out_netSnow = 0.0;
            double accuTemp = (in_meanTemp + in_minTemp) / 2.0;
            double meltTemp = (in_meanTemp + in_maxTemp) / 2.0;
            this.run_coldContent += this.calcColdContent(in_meanTemp, coldContentFactor);
            if (this.run_coldContent > 0.0) {
                this.run_coldContent = 0.0;
            }
            if (this.run_snowDepth > 0.0) {
                this.run_snowAge += 1.0;
            }
            if (this.in_snow > 0.0) {
                this.calcSnowAccumulation(accuTemp, this.run_area, critDens);
            }
            if (meltTemp >= TRS - TRANS && this.run_snowDepth > 0.0) {
                this.calcMetamorphosis(meltTemp, TRS, TRANS, temp_fac, rain_fac, ground_fac, this.run_area, SAC, critDens);
            }
            this.calcSnowDensities(this.run_area);
            this.netRain.setValue(this.in_rain);
            this.netSnow.setValue(this.in_snow);
            this.snowTotSWE.setValue(this.run_totSWE);
            this.drySWE.setValue(this.run_drySWE);
            this.totDens.setValue(this.run_totDens);
            this.dryDens.setValue(this.run_dryDens);
            this.snowDepth.setValue(this.run_snowDepth);
            this.snowAge.setValue(this.run_snowAge);
            this.snowColdContent.setValue(this.run_coldContent);
            if (this.run_snowMelt > 0.0) {
                boolean i = false;
            }
            this.snowMelt.setValue(this.run_snowMelt);
            double balStorEnd = this.run_totSWE;
            double balOut = this.run_snowMelt + this.in_rain + this.in_snow;
            double balance = balIn + (balStorStart - balStorEnd) - balOut;
            if (Math.abs(balance) > 1.0E-4) {
                this.getModel().getRuntime().println("balance error in snow module: " + balance);
                this.getModel().getRuntime().println("balIn: " + balIn);
                this.getModel().getRuntime().println("balStorStart: " + balStorStart);
                this.getModel().getRuntime().println("balStorEnd: " + balStorEnd);
                this.getModel().getRuntime().println("balOut: " + balOut);
                this.getModel().getRuntime().println("shit!");
            }
            if (this.run_snowMelt < 0.0) {
                this.getModel().getRuntime().println("negative snowmelt!!");
            }
        }
    }

    public void cleanup() {
        if (this.active == null || this.active.getValue()) {
            this.snowDepth.setValue(0.0);
            this.snowTotSWE.setValue(0.0);
            this.drySWE.setValue(0.0);
            this.totDens.setValue(0.0);
            this.dryDens.setValue(0.0);
            this.snowAge.setValue(0.0);
            this.snowColdContent.setValue(0.0);
        }
    }

    private double calcColdContent(double temperature, double coldContentFactor) {
        double cc_factor = coldContentFactor * 24.0;
        return cc_factor * temperature;
    }

    private boolean calcSnowAccumulation(double temp, double area, double critDens) {
        double deltaHeight = 0.0;
        if (this.in_snow > 0.0) {
            double new_snow_density = this.calcNewSnowDensity(temp);
            deltaHeight = this.in_snow / (new_snow_density * area);
            this.run_snowDepth += deltaHeight;
            this.run_drySWE += this.in_snow;
            this.run_totSWE += this.in_snow;
            this.in_snow = 0.0;
            this.calcSnowDensities(area);
            this.run_snowAge = 0.0;
            this.run_initDens = this.run_dryDens;
        }
        if (this.in_rain > 0.0) {
            this.calcRainSnowSettlement(this.in_rain);
            this.in_rain = 0.0;
        }
        if (this.run_snowDepth == 0.0) {
            return true;
        }
        this.calcSnowDensities(area);
        if (this.run_totDens > critDens) {
            this.run_snowMelt += this.calcSnowMeltRunoff(critDens, area);
        } else {
            double pRO = this.calcPotRunoff(critDens, this.run_totDens, this.run_totSWE - this.run_drySWE);
            this.run_snowMelt += pRO;
            this.run_totSWE -= pRO;
        }
        this.calcSnowDensities(area);
        return true;
    }

    private double calcNewSnowDensity(double temp) {
        double new_snow_density = 0.0;
        new_snow_density = temp > -15.0 ? 0.13 + 0.0135 * temp + 4.5E-4 * Math.pow(temp, 2.0) : 0.02875;
        return new_snow_density;
    }

    private void calcSnowDensities(double area) {
        if (this.run_snowDepth > 0.0) {
            this.run_totDens = this.run_totSWE / (area * this.run_snowDepth);
            this.run_dryDens = this.run_drySWE / (area * this.run_snowDepth);
        } else {
            this.run_totDens = 0.0;
            this.run_dryDens = 0.0;
        }
    }

    private void calcRainSnowSettlement(double inputWater) {
        double ph;
        double pw = 100.0;
        if (inputWater > 0.0) {
            this.run_totSWE += inputWater;
            this.in_rain = 0.0;
            pw = this.run_totSWE / this.run_drySWE * 100.0;
        }
        if ((ph = 147.4 - 0.474 * pw) > 0.0) {
            this.run_snowDepth *= ph / 100.0;
            this.calcSnowDensities(this.run_area);
            if (this.run_dryDens > this.snowCritDens.getValue()) {
                double maxSWE;
                this.run_drySWE = maxSWE = this.snowCritDens.getValue() * this.run_area * this.run_snowDepth;
            }
        } else {
            this.run_snowMelt += this.run_totSWE;
            this.run_snowDepth = 0.0;
            this.run_totSWE = 0.0;
            this.run_drySWE = 0.0;
            this.run_totDens = 0.0;
            this.run_dryDens = 0.0;
            this.run_snowAge = 0.0;
        }
    }

    private double calcSnowMeltRunoff(double critDens, double area) {
        double Wsmax = critDens * this.run_snowDepth * area;
        double snowmelt = this.run_totSWE - Wsmax;
        this.run_totSWE = Wsmax;
        this.calcSnowDensities(area);
        return snowmelt;
    }

    private double calcPotRunoff(double crit_dens, double tot_dens, double liq_water) {
        double potRunoff;
        if (Math.abs(liq_water) > 1.0E-5 && liq_water < 0.0) {
            this.getModel().getRuntime().println("liq_water is negative: " + liq_water);
        }
        if ((potRunoff = (1.0 - Math.exp(-1.0 * Math.pow(crit_dens / tot_dens, 4.0))) * liq_water) < 0.0) {
            potRunoff = 0.0;
        }
        return potRunoff;
    }

    private boolean calcMetamorphosis(double temp, double TRS, double TRANS, double temp_fac, double rain_fac, double ground_fac, double area, double SAC, double critDens) {
        double pRO;
        double potMeltrate = 0.0;
        potMeltrate = this.calcPotMR_semiComp(temp, TRS, TRANS, temp_fac, rain_fac, ground_fac, area);
        if (Math.abs(this.run_coldContent) >= potMeltrate) {
            this.run_coldContent += potMeltrate;
            potMeltrate = 0.0;
        } else {
            potMeltrate += this.run_coldContent;
            this.run_coldContent = 0.0;
        }
        potMeltrate *= area;
        double deltaSnowDepth = (potMeltrate *= SAC) / (this.run_dryDens * area);
        if (deltaSnowDepth >= this.run_snowDepth) {
            deltaSnowDepth = this.run_snowDepth;
            this.run_snowDepth = 0.0;
            this.run_totDens = 0.0;
            this.run_dryDens = 0.0;
            this.run_snowMelt += this.run_totSWE;
            this.run_totSWE = 0.0;
            this.run_drySWE = 0.0;
            this.run_snowAge = 0.0;
            return true;
        }
        this.run_snowDepth -= deltaSnowDepth;
        this.run_drySWE -= potMeltrate;
        potMeltrate = 0.0;
        this.calcSnowDensities(area);
        if (this.run_totDens >= critDens) {
            this.run_snowMelt += this.calcSnowMeltRunoff(critDens, area);
        } else {
            pRO = this.calcPotRunoff(critDens, this.run_totDens, this.run_totSWE - this.run_drySWE);
            this.run_snowMelt += pRO;
            this.run_totSWE -= pRO;
        }
        this.calcSnowDensities(area);
        this.calcRainSnowSettlement(this.in_rain + potMeltrate);
        this.in_rain = 0.0;
        if (this.run_snowDepth == 0.0) {
            return true;
        }
        this.calcSnowDensities(area);
        if (this.run_totDens >= critDens) {
            this.run_snowMelt += this.calcSnowMeltRunoff(critDens, area);
        } else {
            pRO = this.calcPotRunoff(critDens, this.run_totDens, this.run_totSWE - this.run_drySWE);
            this.run_snowMelt += pRO;
            this.run_totSWE -= pRO;
        }
        this.calcSnowDensities(area);
        return true;
    }

    private double calcPotMR_semiComp(double temp, double TRS, double TRANS, double temp_fac, double rain_fac, double ground_fac, double area) {
        double meltTemp = temp - (TRS - TRANS);
        double potMR = temp_fac * meltTemp + ground_fac + rain_fac * (this.in_rain / area) * meltTemp;
        if (potMR < 0.0) {
            potMR = 0.0;
        }
        return potMR;
    }
}

