/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class J2KProcessReachRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The reach collection")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute length")
    public JAMSDouble length;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute slope")
    public JAMSDouble slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute width")
    public JAMSDouble width;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute roughness")
    public JAMSDouble roughness;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 inflow")
    public JAMSDouble inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 inflow")
    public JAMSDouble inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 inflow")
    public JAMSDouble inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 inflow")
    public JAMSDouble inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar additional inflow")
    public JAMSDouble inAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 outflow")
    public JAMSDouble outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 outflow")
    public JAMSDouble outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 outflow")
    public JAMSDouble outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 outflow")
    public JAMSDouble outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar additional outflow")
    public JAMSDouble outAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar simulated Runoff")
    public JAMSDouble simRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 storage")
    public JAMSDouble actRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 storage")
    public JAMSDouble actRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 storage")
    public JAMSDouble actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 storage")
    public JAMSDouble actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar additional inflow storage")
    public JAMSDouble actAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Channel storage")
    public JAMSDouble channelStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="flow routing coefficient TA")
    public JAMSDouble flowRouteTA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RD1 storage")
    public JAMSDouble catchmentRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RD2 storage")
    public JAMSDouble catchmentRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RG1 storage")
    public JAMSDouble catchmentRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RG2 storage")
    public JAMSDouble catchmentRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment additional input outlet storage")
    public JAMSDouble catchmentAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RG2 storage")
    public JAMSDouble catchmentSimRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="temporal resolution [d or h]")
    public JAMSString tempRes;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        JAMSEntity DestReach = (JAMSEntity)entity.getObject("to_reach");
        JAMSEntity DestReservoir = null;
        try {
            DestReservoir = (JAMSEntity)entity.getObject("to_reservoir");
        }
        catch (JAMSEntity.NoSuchAttributeException e) {
            DestReservoir = null;
        }
        double width = this.width.getValue();
        double slope = this.slope.getValue();
        double rough = this.roughness.getValue();
        double length = this.length.getValue();
        double RD1act = this.actRD1.getValue() + this.inRD1.getValue();
        double RD2act = this.actRD2.getValue() + this.inRD2.getValue();
        double RG1act = this.actRG1.getValue() + this.inRG1.getValue();
        double RG2act = this.actRG2.getValue() + this.inRG2.getValue();
        double addInAct = this.actAddIn.getValue() + this.inAddIn.getValue();
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.inAddIn.setValue(0.0);
        this.actRD1.setValue(0.0);
        this.actRD2.setValue(0.0);
        this.actRG1.setValue(0.0);
        this.actRG2.setValue(0.0);
        this.actAddIn.setValue(0.0);
        double RD1DestIn = 0.0;
        double RD2DestIn = 0.0;
        double RG1DestIn = 0.0;
        double RG2DestIn = 0.0;
        double addInDestIn = 0.0;
        if (DestReach == null && DestReservoir == null) {
            RD1DestIn = 0.0;
            RD2DestIn = 0.0;
            RG1DestIn = 0.0;
            RG2DestIn = 0.0;
            addInDestIn = 0.0;
        } else if (DestReservoir != null) {
            RD1DestIn = DestReservoir.getDouble("compRD1");
            RD2DestIn = DestReservoir.getDouble("compRD2");
            RG1DestIn = DestReservoir.getDouble("compRG1");
            RG2DestIn = DestReservoir.getDouble("compRG2");
        } else {
            RD1DestIn = DestReach.getDouble("inRD1");
            RD2DestIn = DestReach.getDouble("inRD2");
            RG1DestIn = DestReach.getDouble("inRG1");
            RG2DestIn = DestReach.getDouble("inRG2");
            try {
                addInDestIn = DestReach.getDouble("inAddIn");
            }
            catch (JAMSEntity.NoSuchAttributeException e) {
                addInDestIn = 0.0;
            }
        }
        double q_act_tot = RD1act + RD2act + RG1act + RG2act + addInAct;
        if (q_act_tot == 0.0) {
            this.outRD1.setValue(0.0);
            this.outRD2.setValue(0.0);
            this.outRG1.setValue(0.0);
            this.outRG2.setValue(0.0);
            this.outAddIn.setValue(0.0);
            return;
        }
        double RD1_part = RD1act / q_act_tot;
        double RD2_part = RD2act / q_act_tot;
        double RG1_part = RG1act / q_act_tot;
        double RG2_part = RG2act / q_act_tot;
        double addInPart = addInAct / q_act_tot;
        int sec_inTStep = 0;
        if (this.tempRes.getValue().equals("d")) {
            sec_inTStep = 86400;
        } else if (this.tempRes.getValue().equals("h")) {
            sec_inTStep = 3600;
        }
        double flow_veloc = J2KProcessReachRouting.calcFlowVelocity(q_act_tot, width, slope, rough, sec_inTStep);
        double Rk = flow_veloc / length * this.flowRouteTA.getValue() * 3600.0;
        double q_act_out = Rk > 0.0 ? q_act_tot * Math.exp(-1.0 / Rk) : 0.0;
        double RD1out = q_act_out * RD1_part;
        double RD2out = q_act_out * RD2_part;
        double RG1out = q_act_out * RG1_part;
        double RG2out = q_act_out * RG2_part;
        double addInOut = q_act_out * addInPart;
        RD1DestIn += RD1out;
        RD2DestIn += RD2out;
        RG1DestIn += RG1out;
        RG2DestIn += RG2out;
        addInDestIn += addInOut;
        double channelStorage = (RD1act -= q_act_out * RD1_part) + (RD2act -= q_act_out * RD2_part) + (RG1act -= q_act_out * RG1_part) + (RG2act -= q_act_out * RG2_part) + (addInAct -= q_act_out * addInPart);
        double cumOutflow = RD1out + RD2out + RG1out + RG2out + addInOut;
        this.simRunoff.setValue(cumOutflow);
        this.channelStorage.setValue(channelStorage);
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.inAddIn.setValue(0.0);
        this.actRD1.setValue(RD1act);
        this.actRD2.setValue(RD2act);
        this.actRG1.setValue(RG1act);
        this.actRG2.setValue(RG2act);
        this.actAddIn.setValue(addInAct);
        this.outRD1.setValue(RD1out);
        this.outRD2.setValue(RD2out);
        this.outRG1.setValue(RG1out);
        this.outRG2.setValue(RG2out);
        this.outAddIn.setValue(addInOut);
        if (DestReach != null && DestReservoir == null) {
            DestReach.setDouble("inRD1", RD1DestIn);
            DestReach.setDouble("inRD2", RD2DestIn);
            DestReach.setDouble("inRG1", RG1DestIn);
            DestReach.setDouble("inRG2", RG2DestIn);
            DestReach.setDouble("inAddIn", addInDestIn);
        } else if (DestReservoir != null) {
            DestReservoir.setDouble("compRD1", RD1DestIn);
            DestReservoir.setDouble("compRD2", RD2DestIn);
            DestReservoir.setDouble("compRG1", RG1DestIn);
            DestReservoir.setDouble("compRG2", RG2DestIn);
        } else if (DestReach == null && DestReservoir == null) {
            this.catchmentRD1.setValue(RD1out);
            this.catchmentRD2.setValue(RD2out);
            this.catchmentRG1.setValue(RG1out);
            this.catchmentRG2.setValue(RG2out);
            this.catchmentAddIn.setValue(addInOut);
            this.catchmentSimRunoff.setValue(cumOutflow);
        }
    }

    public void cleanup() {
    }

    public static double calcFlowVelocity(double q, double width, double slope, double rough, int secondsOfTimeStep) {
        double afv = 1.0;
        double veloc = 0.0;
        double q_m = q / (double)(1000 * secondsOfTimeStep);
        double rh = J2KProcessReachRouting.calcHydraulicRadius(afv, q_m, width);
        boolean cont = true;
        while (cont) {
            veloc = rough * Math.pow(rh, 0.6666666666666666) * Math.sqrt(slope);
            if (Math.abs(veloc - afv) > 0.001) {
                afv = veloc;
                rh = J2KProcessReachRouting.calcHydraulicRadius(afv, q_m, width);
                continue;
            }
            cont = false;
            afv = veloc;
        }
        return afv;
    }

    public static double calcHydraulicRadius(double v, double q, double width) {
        double A = q / v;
        double rh = A / (width + 2.0 * (A / width));
        return rh;
    }
}

