/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;
import org.unijena.j2k.physicalCalculations.HourlySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class CalcHourlyNetRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="fraction of sunshine in one hour")
    public JAMSDouble sunFrac;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable temperature")
    public JAMSDouble temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable relative humidity")
    public JAMSDouble rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable solar radiation")
    public JAMSDouble solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable solar radiation")
    public JAMSDouble extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable albedo")
    public JAMSDouble albedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute elevation")
    public JAMSDouble elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute latitude")
    public JAMSDouble latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="calc refET with fixed values")
    public JAMSBoolean refET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily net radiation [MJ/m\u00b2]")
    public JAMSDouble netRad;
    private File cacheFile;
    private boolean useCache = false;
    private ObjectOutputStream writer;
    private ObjectInputStream reader;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
        this.cacheFile = new File(this.dirName.getValue() + "/$" + this.getInstanceName() + ".cache");
        if (this.cacheFile.exists() || this.dataCaching.getValue()) {
            // empty if block
        }
        if (this.dataCaching.getValue()) {
            this.useCache = true;
            this.reader = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
        } else {
            this.useCache = false;
            this.writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException, IOException {
        if (!this.useCache) {
            int julDay = this.time.get(6);
            int idx = (julDay - 1) * 24 + this.time.get(11);
            double extraterrRadiation = this.extRad.getValue();
            double elev = this.elevation.getValue();
            double alb = this.refET.getValue() ? 0.23 : this.albedo.getValue();
            double temperature = this.temp.getValue();
            double rh = this.rhum.getValue();
            double sRad = this.solRad.getValue();
            double sunh = this.sunFrac.getValue();
            double sat_vapour_pressure = ClimatologicalVariables.calc_saturationVapourPressure(temperature);
            double act_vapour_pressure = ClimatologicalVariables.calc_vapourPressure(rh, sat_vapour_pressure);
            double clearSkyRad = SolarRadiationCalculationMethods.calc_ClearSkySolarRadiation(elev, extraterrRadiation);
            double netSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(alb, sRad);
            double netLWRadiation = HourlySolarRadiationCalculationMethods.calc_HourlyNetLongwaveRadiation(temperature, act_vapour_pressure, sRad, clearSkyRad, 0.3, false);
            double nRad = SolarRadiationCalculationMethods.calc_NetRadiation(netSWRadiation, netLWRadiation);
            this.netRad.setValue(nRad);
        } else {
            this.netRad.setValue(this.reader.readDouble());
        }
    }

    public void cleanup() throws IOException {
        if (!this.useCache) {
            this.writer.flush();
            this.writer.close();
        } else {
            this.reader.close();
        }
    }
}

