/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.util.Locale;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

public class StandardEntityWriterN
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="EntitySet")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time interval")
    public JAMSTimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file header descriptions")
    public JAMSString header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file attribute names")
    public JAMSString attributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="entity attribute name for weight [attName | none]")
    public JAMSString weight;
    private GenericDataWriter writer;
    private String[] attrs;
    private boolean headerWritten;
    private double[][] valueMatrix;
    private String[] dateVals;
    private String timeFormat = "%1$td.%1$tm.%1$tY";
    private int tcounter;
    private int nEnts;
    private double[][] aggMatrix;
    private int[] aggCounter;
    private String[] aggFieldNames;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
        int tsteps = (int)this.timeInterval.getNumberOfTimesteps();
        this.nEnts = this.entities.getEntityArray().length;
        this.valueMatrix = new double[tsteps][this.nEnts];
        this.dateVals = new String[tsteps];
        if (this.timeInterval.getTimeUnit() == 2) {
            this.timeFormat = "%1$tb/%1$ty";
            this.aggMatrix = new double[12][this.nEnts];
            this.aggCounter = new int[12];
            this.aggFieldNames = new String[12];
        }
        this.tcounter = 0;
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int i;
        this.dateVals[this.tcounter] = this.time.toString(this.timeFormat);
        if (this.weight.getValue().equals("none")) {
            for (i = 0; i < this.nEnts; ++i) {
                this.valueMatrix[this.tcounter][i] = ((JAMSDouble)this.entities.getEntityArray()[i].getObject(this.attributeName.getValue())).getValue();
            }
        } else {
            for (i = 0; i < this.nEnts; ++i) {
                double weight = ((JAMSDouble)this.entities.getEntityArray()[i].getObject(this.weight.getValue())).getValue();
                this.valueMatrix[this.tcounter][i] = ((JAMSDouble)this.entities.getEntityArray()[i].getObject(this.attributeName.getValue())).getValue() / weight;
            }
        }
        if (this.timeInterval.getTimeUnit() == 2) {
            int month;
            int n = month = this.time.get(2);
            this.aggCounter[n] = this.aggCounter[n] + 1;
            this.aggFieldNames[month] = this.time.toString("%1$tb");
            for (int i2 = 0; i2 < this.nEnts; ++i2) {
                double[] dArray = this.aggMatrix[month];
                int n2 = i2;
                dArray[n2] = dArray[n2] + this.valueMatrix[this.tcounter][i2];
            }
        }
        ++this.tcounter;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
        this.getModel().getRuntime().println("Writing distributed output file ... may take a while ... please wait ...", 1);
        this.getModel().getRuntime().println("Number of entities: " + this.nEnts + ", number of timeSteps: " + this.dateVals.length);
        try {
            int i;
            this.writer.addColumn("ID");
            for (i = 0; i < this.dateVals.length; ++i) {
                this.writer.addColumn(this.dateVals[i]);
            }
            if (this.timeInterval.getTimeUnit() == 2) {
                for (i = 0; i < 12; ++i) {
                    this.writer.addColumn(this.aggFieldNames[i]);
                }
                this.writer.addColumn("Year");
            }
            this.writer.writeHeader();
            for (int e = 0; e < this.nEnts; ++e) {
                int ID = (int)((JAMSDouble)this.entities.getEntityArray()[e].getObject("ID")).getValue();
                this.writer.addData((Object)ID);
                for (int t = 0; t < this.dateVals.length; ++t) {
                    String dStr = String.format(Locale.US, "%.3f", this.valueMatrix[t][e]);
                    this.writer.addData((Object)dStr);
                }
                double aggSum = 0.0;
                if (this.timeInterval.getTimeUnit() == 2) {
                    String dStr;
                    for (int t = 0; t < 12; ++t) {
                        aggSum += this.aggMatrix[t][e] / (double)this.aggCounter[t];
                        String dStr2 = String.format(Locale.US, "%.3f", this.aggMatrix[t][e] / (double)this.aggCounter[t]);
                        this.writer.addData((Object)dStr2);
                    }
                    if (this.weight.getValue().equals("none")) {
                        dStr = String.format(Locale.US, "%.3f", aggSum / 12.0);
                        this.writer.addData((Object)dStr);
                    } else {
                        dStr = String.format(Locale.US, "%.3f", aggSum);
                        this.writer.addData((Object)dStr);
                    }
                }
                this.writer.writeData();
            }
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Exception)((Object)jre));
        }
        this.writer.close();
        this.getModel().getRuntime().println("Finished distributed output file ... you may continue ...", 1);
    }
}

