/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcRelativeHumidity", author="Peter Krause", description="Calculates relative humidity from temperature and absolute humidity")
public class CalcRelativeHumidity
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable mean tempeature")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable absolute humidity")
    public JAMSDouble ahum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable relative humidity")
    public JAMSDouble rhum;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double maxHum = ClimatologicalVariables.calc_maxHum(this.tmean.getValue());
        double rh = this.ahum.getValue() / maxHum * 100.0;
        if (rh > 100.0) {
            rh = 100.0;
        }
        this.rhum.setValue(rh);
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

