/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcLanduseStateVars", author="Peter Krause", description="Calculates landuse state variables for each entity")
public class CalcLanduseStateVars
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar LAI values (366)")
    public JAMSDoubleArray LAIArray = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar eff. Height values (366)")
    public JAMSDoubleArray effHArray = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Monthly stomata resistance values")
    public JAMSDoubleArray rsc0Array = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute name elevation")
    public JAMSDouble elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="temporal resolution [d | h | m]")
    public JAMSString tempRes;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};
    int oldmonth = 0;
    double rsc0 = 0.0;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int julDay;
        int j;
        JAMSEntity entity = this.entities.getCurrent();
        double[] lai_vals = null;
        double[] effH_vals = null;
        if (this.tempRes == null || this.tempRes.getValue().equals("d") || this.tempRes.getValue().equals("h")) {
            lai_vals = new double[366];
            effH_vals = new double[366];
        } else if (this.tempRes.getValue().equals("m")) {
            lai_vals = new double[12];
            effH_vals = new double[12];
        }
        double HRUelevation = this.elevation.getValue();
        double[] lais = new double[4];
        String laiName = "LAI_d";
        for (int i = 0; i < 4; ++i) {
            int count = i + 1;
            String loopName = laiName + count;
            lais[i] = entity.getDouble(loopName);
        }
        double[] effH = new double[4];
        String effName = "effHeight_d";
        for (int i = 0; i < 4; ++i) {
            int count = i + 1;
            String loopName = effName + count;
            effH[i] = entity.getDouble(loopName);
        }
        if (this.tempRes == null || this.tempRes.getValue().equals("d") || this.tempRes.getValue().equals("h")) {
            for (j = 0; j < 366; ++j) {
                julDay = j + 1;
                lai_vals[j] = this.calcLAI(lais, HRUelevation, julDay);
                effH_vals[j] = this.calcEffHeight(effH, HRUelevation, julDay);
            }
        } else if (this.tempRes.getValue().equals("m")) {
            for (j = 0; j < 12; ++j) {
                julDay = this.monthMean[j];
                lai_vals[j] = this.calcLAI(lais, HRUelevation, julDay);
                effH_vals[j] = this.calcEffHeight(effH, HRUelevation, julDay);
            }
        }
        this.LAIArray.setValue(lai_vals);
        this.effHArray.setValue(effH_vals);
        double[] rsc0 = new double[12];
        String rsc0Name = "RSC0_";
        for (int i = 0; i < 12; ++i) {
            int count = i + 1;
            String loopName = rsc0Name + count;
            rsc0[i] = entity.getDouble(loopName);
        }
        this.rsc0Array.setValue(rsc0);
    }

    public void cleanup() {
    }

    private double calcLAI(double[] lais, double targetElevation, int julDay) {
        int dTime = 0;
        double Lait1 = 0.0;
        double dLai = 0.0;
        int d1_400 = 110;
        int d2_400 = 150;
        int d3_400 = 250;
        int d4_400 = 280;
        int d1 = (int)((double)d1_400 + 0.025 * (targetElevation - 400.0));
        int d2 = (int)((double)d2_400 + 0.025 * (targetElevation - 400.0));
        int d3 = (int)((double)d3_400 - 0.025 * (targetElevation - 400.0));
        int d4 = (int)((double)d4_400 - 0.025 * (targetElevation - 400.0));
        double LAI = 0.0;
        if (julDay <= d1) {
            LAI = lais[0];
        } else if (julDay > d1 && julDay <= d2) {
            double LAI_1 = lais[0];
            double LAI_2 = lais[1];
            dTime = d2 - d1;
            dLai = LAI_2 - LAI_1;
            Lait1 = dLai / (double)dTime;
            LAI = Lait1 * (double)(julDay - d1) + LAI_1;
        } else if (julDay > d2 && julDay <= d3) {
            double LAI_2 = lais[1];
            double LAI_3 = lais[2];
            dTime = d3 - d2;
            dLai = LAI_3 - LAI_2;
            Lait1 = dLai / (double)dTime;
            LAI = Lait1 * (double)(julDay - d2) + LAI_2;
        } else if (julDay > d3 && julDay <= d4) {
            double LAI_3 = lais[2];
            double LAI_4 = lais[3];
            dTime = d4 - d3;
            dLai = LAI_4 - LAI_3;
            Lait1 = dLai / (double)dTime;
            LAI = Lait1 * (double)(julDay - d3) + LAI_3;
        } else if (julDay > d4) {
            double LAI_4;
            LAI = LAI_4 = lais[3];
        }
        return LAI;
    }

    private double calcEffHeight(double[] effHeight, double targetElevation, int julDay) {
        int dTime = 0;
        double effH_t1 = 0.0;
        double deffH = 0.0;
        int d1_400 = 110;
        int d2_400 = 150;
        int d3_400 = 250;
        int d4_400 = 280;
        int d1 = (int)((double)d1_400 + 0.025 * (targetElevation - 400.0));
        int d2 = (int)((double)d2_400 + 0.025 * (targetElevation - 400.0));
        int d3 = (int)((double)d3_400 - 0.025 * (targetElevation - 400.0));
        int d4 = (int)((double)d4_400 - 0.025 * (targetElevation - 400.0));
        double effH = 0.0;
        if (julDay <= d1) {
            effH = effHeight[0];
        } else if (julDay > d1 && julDay <= d2) {
            double effH_1 = effHeight[0];
            double effH_2 = effHeight[1];
            dTime = d2 - d1;
            deffH = effH_2 - effH_1;
            effH_t1 = deffH / (double)dTime;
            effH = effH_t1 * (double)(julDay - d1) + effH_1;
        } else if (julDay > d2 && julDay <= d3) {
            double effH_2 = effHeight[1];
            double effH_3 = effHeight[2];
            dTime = d3 - d2;
            deffH = effH_3 - effH_2;
            effH_t1 = deffH / (double)dTime;
            effH = effH_t1 * (double)(julDay - d2) + effH_2;
        } else if (julDay > d3 && julDay <= d4) {
            double effH_3 = effHeight[2];
            double effH_4 = effHeight[3];
            dTime = d4 - d3;
            deffH = effH_4 - effH_3;
            effH_t1 = deffH / (double)dTime;
            effH = effH_t1 * (double)(julDay - d3) + effH_3;
        } else if (julDay > d4) {
            double effH_4;
            effH = effH_4 = effHeight[3];
        }
        return effH;
    }
}

