/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.groundwater;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KGroundwater", author="Peter Krause", description="Description")
public class InitJ2KProcessGroundwater
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG1 storage")
    public JAMSDouble maxRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG2 storage")
    public JAMSDouble maxRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG1 storage")
    public JAMSDouble actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG2 storage")
    public JAMSDouble actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="relative initial RG1 storage")
    public JAMSDouble initRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="relative initial RG2 storage")
    public JAMSDouble initRG2;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        this.maxRG1.setValue(entity.getDouble("RG1_max") * this.area.getValue());
        this.maxRG2.setValue(entity.getDouble("RG2_max") * this.area.getValue());
        this.actRG1.setValue(this.maxRG1.getValue() * this.initRG1.getValue());
        this.actRG2.setValue(this.maxRG2.getValue() * this.initRG2.getValue());
    }

    public void cleanup() {
    }
}

