/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.geographicalCalculations;

import org.unijena.j2k.geographicalCalculations.CalcSlopeAspectCorrectionFactor;
import org.unijena.j2k.geographicalCalculations.GKConversion;
import org.unijena.j2k.geographicalCalculations.UTMConversion;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcAdditionalHRUAttribs", author="Peter Krause", description="Calculates additional attributes from existent ones")
public class CalcLatLong
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity x-coordinate")
    public JAMSDouble x;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity y-coordinate")
    public JAMSDouble y;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity slope")
    public JAMSDouble slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity aspect")
    public JAMSDouble aspect;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="entity latidute")
    public JAMSDouble latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="entity longitude")
    public JAMSDouble longitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="entity slopeAspectCorrectionFactor")
    public JAMSDoubleArray slAsCfArray = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Projection [GK, UTMZZL]")
    public JAMSString projection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="temporal resolution [d | h | m]")
    public JAMSString tempRes;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double[] latLong = new double[2];
        String proj = this.projection.toString() == null ? "GK" : this.projection.toString();
        if (proj.equals("GK")) {
            latLong = GKConversion.GK2LatLon(this.x.getValue(), this.y.getValue());
        } else if (proj.substring(0, 3).equals("UTM")) {
            int len = proj.length();
            String zoneStr = proj.substring(3, len);
            latLong = UTMConversion.utm2LatLong(this.x.getValue(), this.y.getValue(), zoneStr);
        }
        this.latitude.setValue(latLong[0]);
        this.longitude.setValue(latLong[1]);
        double[] sloAspCorr = null;
        if (this.tempRes == null || this.tempRes.getValue().equals("d") || this.tempRes.getValue().equals("h")) {
            sloAspCorr = new double[366];
            for (int i = 0; i < 366; ++i) {
                int julDay = i + 1;
                sloAspCorr[i] = CalcSlopeAspectCorrectionFactor.calc_slopeAspectCorrectionFactor(julDay, this.latitude.getValue(), this.slope.getValue(), this.aspect.getValue());
            }
        } else if (this.tempRes.getValue().equals("m")) {
            sloAspCorr = new double[12];
            for (int i = 0; i < 12; ++i) {
                int julDay = this.monthMean[i];
                sloAspCorr[i] = CalcSlopeAspectCorrectionFactor.calc_slopeAspectCorrectionFactor(julDay, this.latitude.getValue(), this.slope.getValue(), this.aspect.getValue());
            }
        }
        this.slAsCfArray.setValue(sloAspCorr);
    }

    public void cleanup() {
    }
}

