/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.efficiencies;

import org.unijena.j2k.efficiencies.DoubleSumAnalysis;
import org.unijena.j2k.efficiencies.IndexOfAgreement;
import org.unijena.j2k.efficiencies.NashSutcliffe;
import org.unijena.j2k.efficiencies.PredictionErrors;
import org.unijena.j2k.efficiencies.VolumeError;
import org.unijena.j2k.statistics.Regression;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSIntegerArray;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="StaticEfficiencyCalculator", author="Peter Krause", description="Calculates various efficiency measures for validation and prediction arrays")
public class StaticEfficiencyCalculator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Efficiency method used")
    public JAMSIntegerArray effMethod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Prediction value array")
    public JAMSDoubleArray prediction;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Validation value array")
    public JAMSDoubleArray validation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Nash-Sutcliffe-efficiency with power 1.0")
    public JAMSDouble e1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Nash-Sutcliffe-efficiency with power 2.0")
    public JAMSDouble e2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="logarithmic Nash-Sutcliffe-efficiency with power 1.0")
    public JAMSDouble le1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="logarithmic Nash-Sutcliffe-efficiency with power 2.0")
    public JAMSDouble le2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Willmot's index of agreement with power 1.0")
    public JAMSDouble ioa1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Willmot's index of agreement with power 2.0")
    public JAMSDouble ioa2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="coefficient of determination r\u00b2")
    public JAMSDouble rsq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="gradient of linear regression")
    public JAMSDouble grad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="weighted r\u00b2")
    public JAMSDouble wrsq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="gradient of double sum regression")
    public JAMSDouble dsGrad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="absolute volume error")
    public JAMSDouble absVolErr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="root mean square error")
    public JAMSDouble rmse;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="percent bias")
    public JAMSDouble pbias;
    private final int E1 = 1;
    private final int E2 = 2;
    private final int LOG_E1 = 3;
    private final int LOG_E2 = 4;
    private final int IOA_1 = 5;
    private final int IOA_2 = 6;
    private final int R2 = 7;
    private final int WR2 = 8;
    private final int DSGRAD = 9;
    private final int ABSVOLERROR = 10;
    private final int RMSE = 11;
    private final int PBIAS = 12;
    private double[] valData;
    private double[] preData;

    public void init() {
    }

    public void run() {
        this.valData = this.validation.getValue();
        this.preData = this.prediction.getValue();
        this.getModel().getRuntime().println("", 1);
        this.getModel().getRuntime().println("*************************************************************", 1);
        this.getModel().getRuntime().println("Efficiencies ", 1);
        this.getModel().getRuntime().println("Sampler: " + this.getInstanceName(), 1);
        this.getModel().getRuntime().println("*************************************************************", 1);
        for (int i = 0; i < this.effMethod.getValue().length; ++i) {
            if (this.effMethod.getValue()[i] == this.E1) {
                double e1 = NashSutcliffe.efficiency(this.preData, this.valData, 1.0);
                this.e1.setValue(e1);
                this.getModel().getRuntime().println("e1:\t\t" + e1, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.E2) {
                double e2 = NashSutcliffe.efficiency(this.preData, this.valData, 2.0);
                this.e2.setValue(e2);
                this.getModel().getRuntime().println("e2:\t\t" + e2, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.LOG_E1) {
                double le1 = NashSutcliffe.logEfficiency(this.preData, this.valData, 1.0);
                this.le1.setValue(le1);
                this.getModel().getRuntime().println("log_e1:\t\t" + le1, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.LOG_E2) {
                double le2 = NashSutcliffe.logEfficiency(this.preData, this.valData, 2.0);
                this.le2.setValue(le2);
                this.getModel().getRuntime().println("log_e2:\t\t" + le2, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.IOA_1) {
                double ioa1 = IndexOfAgreement.calc_IOA(this.preData, this.valData, 1.0, this.getModel());
                this.ioa1.setValue(ioa1);
                this.getModel().getRuntime().println("ioa1:\t\t" + ioa1, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.IOA_2) {
                double ioa2 = IndexOfAgreement.calc_IOA(this.preData, this.valData, 2.0, this.getModel());
                this.ioa2.setValue(ioa2);
                this.getModel().getRuntime().println("ioa2:\t\t" + ioa2, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.R2) {
                double[] rCoeff = Regression.calcLinReg(this.valData, this.preData);
                this.getModel().getRuntime().println("r\u00b2:\t\t" + rCoeff[2], 1);
                this.getModel().getRuntime().println("grad:\t\t" + rCoeff[1], 1);
                this.rsq.setValue(rCoeff[2]);
                this.grad.setValue(rCoeff[1]);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.WR2) {
                double[] rCoeff = Regression.calcLinReg(this.valData, this.preData);
                double wr = rCoeff[1] <= 1.0 ? Math.abs(rCoeff[1]) * rCoeff[2] : Math.pow(Math.abs(rCoeff[1]), -1.0) * rCoeff[2];
                this.wrsq.setValue(wr);
                this.getModel().getRuntime().println("wr\u00b2:\t\t" + wr, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.DSGRAD) {
                double dsGrad = DoubleSumAnalysis.dsGrad(this.valData, this.preData);
                this.dsGrad.setValue(dsGrad);
                this.getModel().getRuntime().println("dsGrad:\t\t" + dsGrad, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.ABSVOLERROR) {
                double volErr = VolumeError.absVolumeError(this.valData, this.preData);
                this.absVolErr.setValue(volErr);
                this.getModel().getRuntime().println("absVolumeError:\t\t" + volErr, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.RMSE) {
                double rmse = PredictionErrors.rootMeanSquareError(this.valData, this.preData);
                this.rmse.setValue(rmse);
                this.getModel().getRuntime().println("RMSE:\t\t" + rmse, 1);
                continue;
            }
            if (this.effMethod.getValue()[i] != this.PBIAS) continue;
            double pbias = VolumeError.pbias(this.valData, this.preData);
            this.pbias.setValue(pbias);
            this.getModel().getRuntime().println("PBIAS:\t\t" + pbias, 1);
        }
    }

    public void cleanup() {
    }
}

