/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.efficiencies;

import java.util.Locale;
import java.util.Vector;
import org.unijena.j2k.efficiencies.DoubleSumAnalysis;
import org.unijena.j2k.efficiencies.IndexOfAgreement;
import org.unijena.j2k.efficiencies.NashSutcliffe;
import org.unijena.j2k.efficiencies.PredictionErrors;
import org.unijena.j2k.efficiencies.VolumeError;
import org.unijena.j2k.statistics.Regression;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSIntegerArray;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="StandardEfficiencyCalculator", author="Peter Krause", description="Calculates various efficiency measures")
public class StandardEfficiencyCalculator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The model time interval")
    public JAMSTimeInterval modelTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The efficiency time interval")
    public JAMSTimeInterval effTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The months to be evaluated interval")
    public JAMSIntegerArray effMonthList;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Efficiency method used")
    public JAMSIntegerArray effMethod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Prediction value")
    public JAMSDouble prediction;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Validation value")
    public JAMSDouble validation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Nash-Sutcliffe-efficiency with power 1.0")
    public JAMSDouble e1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Nash-Sutcliffe-efficiency with power 2.0")
    public JAMSDouble e2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="logarithmic Nash-Sutcliffe-efficiency with power 1.0")
    public JAMSDouble le1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="logarithmic Nash-Sutcliffe-efficiency with power 2.0")
    public JAMSDouble le2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Willmot's index of agreement with power 1.0")
    public JAMSDouble ioa1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Willmot's index of agreement with power 2.0")
    public JAMSDouble ioa2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="coefficient of determination r\u00b2")
    public JAMSDouble rsq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="gradient of linear regression")
    public JAMSDouble grad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="weighted r\u00b2")
    public JAMSDouble wrsq;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="gradient of double sum regression")
    public JAMSDouble dsGrad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="absolute volume error")
    public JAMSDouble absVolErr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="root mean square error")
    public JAMSDouble rmse;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="percent bias")
    public JAMSDouble pbias;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="full set of predicted values")
    public JAMSDoubleArray predictionValues = new JAMSDoubleArray();
    private final int E1 = 1;
    private final int E2 = 2;
    private final int LOG_E1 = 3;
    private final int LOG_E2 = 4;
    private final int IOA_1 = 5;
    private final int IOA_2 = 6;
    private final int R2 = 7;
    private final int WR2 = 8;
    private final int DSGRAD = 9;
    private final int ABSVOLERROR = 10;
    private final int RMSE = 11;
    private final int PBIAS = 12;
    private final int TOTAL_PERIOD = 0;
    private final int HYDROLOGICAL_YEAR = 1;
    private final int CALENDAR_YEAR = 2;
    private double[] valData;
    private double[] preData;
    private int counter = 0;
    private int interValStart = 0;
    private int interValEnd = 0;
    private int effTsteps = 0;
    private boolean monthly = false;
    private int monthCount = 0;

    public void init() {
        this.counter = 0;
        this.monthCount = 0;
        JAMSCalendar model_sd = this.modelTimeInterval.getStart().clone();
        JAMSCalendar model_ed = this.modelTimeInterval.getEnd().clone();
        int model_tres = this.modelTimeInterval.getTimeUnit();
        long sdMod = model_sd.getTimeInMillis();
        long edMod = model_ed.getTimeInMillis();
        long model_tsteps = 0L;
        model_tsteps = this.modelTimeInterval.getNumberOfTimesteps();
        JAMSCalendar eff_sd = this.effTimeInterval.getStart().clone();
        JAMSCalendar eff_ed = this.effTimeInterval.getEnd().clone();
        int eff_tres = this.effTimeInterval.getTimeUnit();
        long sdEff = eff_sd.getTimeInMillis();
        long edEff = eff_ed.getTimeInMillis();
        if (eff_sd.before((Object)model_sd)) {
            this.effTimeInterval.setStart(model_sd);
            this.getModel().getRuntime().println("effStartdate was set equal to model startdate", 1);
        }
        if (model_ed.before((Object)eff_ed)) {
            this.effTimeInterval.setEnd(model_ed);
            this.getModel().getRuntime().println("effEnddate was set equal to model enddate", 1);
        }
        this.effTsteps = (int)this.effTimeInterval.getNumberOfTimesteps();
        int ts = (int)this.getContext().getNumberOfIterations();
        this.getModel().getRuntime().println("effStartdate:\t" + eff_sd.toString(), 2);
        this.getModel().getRuntime().println("effEnddate:\t" + eff_ed.toString(), 2);
        this.valData = new double[(int)model_tsteps];
        this.preData = new double[(int)model_tsteps];
        this.counter = 0;
        if (eff_tres == 6) {
            this.interValStart = (int)((sdEff - sdMod) / 86400000L);
            this.interValEnd = this.interValStart + this.effTsteps;
        } else if (eff_tres == 11) {
            this.interValStart = (int)((sdEff - sdMod) / 3600000L);
            this.interValEnd = this.interValStart + this.effTsteps;
        } else if (eff_tres == 2) {
            JAMSCalendar modStart = this.modelTimeInterval.getStart().clone();
            JAMSCalendar effStart = this.effTimeInterval.getStart().clone();
            int startStep = 0;
            while (modStart.before((Object)effStart)) {
                ++startStep;
                modStart.add(2, 1);
            }
            this.interValStart = startStep;
            this.interValEnd = this.interValStart + this.effTsteps;
        } else if (eff_tres == 1) {
            JAMSCalendar modStart = this.modelTimeInterval.getStart().clone();
            JAMSCalendar effStart = this.effTimeInterval.getStart().clone();
            int startStep = 0;
            while (modStart.before((Object)effStart)) {
                ++startStep;
                modStart.add(1, 1);
            }
            this.interValStart = startStep;
            this.interValEnd = this.interValStart + this.effTsteps;
        }
        boolean junk = false;
        if (this.effMonthList != null) {
            this.monthly = true;
        }
    }

    public void run() {
        if (this.monthly) {
            int month = this.time.get(2) + 1;
            for (int i = 0; i < this.effMonthList.getValue().length; ++i) {
                if (month != this.effMonthList.getValue()[i]) continue;
                this.valData[this.counter] = this.validation.getValue();
                this.preData[this.counter] = this.prediction.getValue();
                ++this.counter;
                ++this.monthCount;
            }
        } else {
            this.valData[this.counter] = this.validation.getValue();
            this.preData[this.counter] = this.prediction.getValue();
            ++this.counter;
        }
    }

    public void cleanup() {
        int i;
        this.getModel().getRuntime().println("", 1);
        this.getModel().getRuntime().println("*************************************************************", 1);
        this.getModel().getRuntime().println("Efficiencies for period:\t " + this.effTimeInterval.toString(), 1);
        this.getModel().getRuntime().println("Sampler: " + this.getInstanceName(), 1);
        this.getModel().getRuntime().println("*************************************************************", 1);
        Vector<Double> valVector = new Vector<Double>();
        Vector<Double> preVector = new Vector<Double>();
        this.predictionValues.setValue(this.preData);
        for (int i2 = this.interValStart; i2 < this.interValEnd; ++i2) {
            if (!(this.valData[i2] > -9999.0) || !(this.preData[i2] > -9999.0)) continue;
            valVector.add(this.valData[i2]);
            preVector.add(this.preData[i2]);
        }
        int dataCount = valVector.size();
        if (this.monthly) {
            dataCount = this.monthCount;
        }
        double[] valData_1 = new double[dataCount];
        double[] preData_1 = new double[dataCount];
        for (i = 0; i < dataCount; ++i) {
            valData_1[i] = (Double)valVector.get(i);
            preData_1[i] = (Double)preVector.get(i);
        }
        for (i = 0; i < this.effMethod.getValue().length; ++i) {
            int n = this.effMethod.getValue()[i];
            ((Object)((Object)this)).getClass();
            if (n == 1) {
                double e1 = NashSutcliffe.efficiency(preData_1, valData_1, 1.0);
                this.e1.setValue(e1);
                this.getModel().getRuntime().println("e1:\t\t" + String.format(Locale.US, "%.5f", e1), 1);
                continue;
            }
            int n2 = this.effMethod.getValue()[i];
            ((Object)((Object)this)).getClass();
            if (n2 == 2) {
                double e2 = NashSutcliffe.efficiency(preData_1, valData_1, 2.0);
                this.e2.setValue(e2);
                this.getModel().getRuntime().println("e2:\t\t" + String.format(Locale.US, "%.5f", e2), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.LOG_E1) {
                double le1 = NashSutcliffe.logEfficiency(preData_1, valData_1, 1.0);
                this.le1.setValue(le1);
                this.getModel().getRuntime().println("log_e1:\t\t" + String.format(Locale.US, "%.5f", le1), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.LOG_E2) {
                double le2 = NashSutcliffe.logEfficiency(preData_1, valData_1, 2.0);
                this.le2.setValue(le2);
                this.getModel().getRuntime().println("log_e2:\t\t" + String.format(Locale.US, "%.5f", le2), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.IOA_1) {
                double ioa1 = IndexOfAgreement.calc_IOA(preData_1, valData_1, 1.0, this.getModel());
                this.ioa1.setValue(ioa1);
                this.getModel().getRuntime().println("ioa1:\t\t" + String.format(Locale.US, "%.5f", ioa1), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.IOA_2) {
                double ioa2 = IndexOfAgreement.calc_IOA(preData_1, valData_1, 2.0, this.getModel());
                this.ioa2.setValue(ioa2);
                this.getModel().getRuntime().println("ioa2:\t\t" + String.format(Locale.US, "%.5f", ioa2), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.R2) {
                double[] rCoeff = Regression.calcLinReg(valData_1, preData_1);
                this.getModel().getRuntime().println("r\u00b2:\t\t" + String.format(Locale.US, "%.5f", rCoeff[2]), 1);
                this.getModel().getRuntime().println("grad:\t\t" + String.format(Locale.US, "%.5f", rCoeff[1]), 1);
                this.rsq.setValue(rCoeff[2]);
                this.grad.setValue(rCoeff[1]);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.WR2) {
                double[] rCoeff = Regression.calcLinReg(valData_1, preData_1);
                double wr = rCoeff[1] <= 1.0 ? Math.abs(rCoeff[1]) * rCoeff[2] : Math.pow(Math.abs(rCoeff[1]), -1.0) * rCoeff[2];
                this.wrsq.setValue(wr);
                this.getModel().getRuntime().println("wr\u00b2:\t\t" + String.format(Locale.US, "%.5f", wr), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.DSGRAD) {
                double dsGrad = DoubleSumAnalysis.dsGrad(valData_1, preData_1);
                this.dsGrad.setValue(dsGrad);
                this.getModel().getRuntime().println("dsGrad:\t\t" + String.format(Locale.US, "%.5f", dsGrad), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.ABSVOLERROR) {
                double volErr = VolumeError.absVolumeError(valData_1, preData_1);
                this.absVolErr.setValue(volErr);
                this.getModel().getRuntime().println("AVE:\t\t" + String.format(Locale.US, "%.5f", volErr), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] == this.RMSE) {
                double rmse = PredictionErrors.rootMeanSquareError(valData_1, preData_1);
                this.rmse.setValue(rmse);
                this.getModel().getRuntime().println("RMSE:\t\t" + String.format(Locale.US, "%.5f", rmse), 1);
                continue;
            }
            if (this.effMethod.getValue()[i] != this.PBIAS) continue;
            double pbias = VolumeError.pbias(valData_1, preData_1);
            this.pbias.setValue(pbias);
            this.getModel().getRuntime().println("PBIAS:\t\t" + String.format(Locale.US, "%.5f", pbias), 1);
        }
    }
}

