/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.unijena.jams.data.JAMSDataFactory;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSModel;

public class J2KFunctions {
    public static ArrayList<JAMSEntity> readParas(String fileName, JAMSModel model) {
        ArrayList<JAMSEntity> entityList = new ArrayList<JAMSEntity>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            Vector<String> attributeNames = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(s, "\t");
            while (tokenizer.hasMoreTokens()) {
                attributeNames.add(tokenizer.nextToken());
            }
            reader.readLine();
            reader.readLine();
            reader.readLine();
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                JAMSEntity e = JAMSDataFactory.createEntity();
                tokenizer = new StringTokenizer(s, "\t");
                for (int i = 0; i < attributeNames.size(); ++i) {
                    String token = tokenizer.nextToken();
                    try {
                        e.setDouble((String)attributeNames.get(i), Double.parseDouble(token));
                        model.getRuntime().println((String)attributeNames.get(i) + ": " + token, 4);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        e.setObject((String)attributeNames.get(i), (Object)token);
                    }
                }
                entityList.add(e);
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            model.getRuntime().handle((Exception)ioe);
        }
        return entityList;
    }

    public static ArrayList<JAMSEntity> createStationEntities(String fileName, JAMSModel model) {
        ArrayList<JAMSEntity> entityList = new ArrayList<JAMSEntity>();
        int headerLineCount = 0;
        String dataName = null;
        String tres = null;
        String start = null;
        String end = null;
        double[] statx = null;
        double[] staty = null;
        double[] statelev = null;
        String line = "#";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while (line.charAt(0) == '#') {
                line = reader.readLine();
                ++headerLineCount;
            }
            StringTokenizer strTok = new StringTokenizer(line, "\t");
            String token = strTok.nextToken();
            while (token.compareTo("@dataVal") != 0) {
                String desc;
                int i;
                if (token.compareTo("@dataValueAttribs") == 0) {
                    line = reader.readLine();
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, "\t");
                    dataName = strTok.nextToken();
                    double lowBound = Double.parseDouble(strTok.nextToken());
                    double uppBound = Double.parseDouble(strTok.nextToken());
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, "\t");
                    token = strTok.nextToken();
                    ++headerLineCount;
                    continue;
                }
                if (token.compareTo("@dataSetAttribs") == 0) {
                    line = reader.readLine();
                    for (i = 0; i < 4; ++i) {
                        ++headerLineCount;
                        strTok = new StringTokenizer(line, "\t");
                        desc = strTok.nextToken();
                        if (desc.compareTo("missingDataVal") == 0) {
                            double missData = Double.parseDouble(strTok.nextToken());
                        } else if (desc.compareTo("dataStart") == 0) {
                            start = strTok.nextToken();
                        } else if (desc.compareTo("dataEnd") == 0) {
                            end = strTok.nextToken();
                        } else if (desc.compareTo("tres") == 0) {
                            tres = strTok.nextToken();
                        }
                        line = reader.readLine();
                        strTok = new StringTokenizer(line, "\t");
                        token = strTok.nextToken();
                    }
                    continue;
                }
                if (token.compareTo("@statAttribVal") != 0) continue;
                line = reader.readLine();
                for (i = 0; i < 6; ++i) {
                    int j;
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, "\t");
                    desc = strTok.nextToken();
                    int nstat = strTok.countTokens();
                    if (desc.compareTo("name") == 0) {
                        String[] name = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            name[j] = strTok.nextToken();
                        }
                    } else if (desc.compareTo("ID") == 0) {
                        String[] id = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            id[j] = strTok.nextToken();
                        }
                    } else if (desc.compareTo("elevation") == 0) {
                        statelev = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statelev[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("x") == 0) {
                        statx = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statx[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("y") == 0) {
                        staty = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            staty[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("dataColumn") == 0) {
                        ++headerLineCount;
                        ++headerLineCount;
                    }
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, "\t");
                    token = strTok.nextToken();
                }
            }
        }
        catch (IOException ioe) {
            model.getRuntime().handle((Exception)ioe);
        }
        return entityList;
    }
}

