/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import java.util.Locale;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

@JAMSComponentDescription(title="Entity file writer (spatial+monthly)", author="D. Varga", description="Base: StandardEntityWriterN (P.Krause).Use: For calculating monthly averages, the time Interval should be always one day longer.")
public class EntityWriterMonthlyAgg
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="EntitySet")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The model time interval")
    public JAMSTimeInterval modelTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The aggregation time interval")
    public JAMSTimeInterval aggTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file header descriptions")
    public JAMSString header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file attribute names")
    public JAMSString attributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="entity attribute name for weight [attName | none]")
    public JAMSString weight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="true/false enables output of each simulated month")
    public JAMSBoolean monthlyValuesWriting;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="type of calculation - sum, average, stDev")
    public JAMSString type;
    private GenericDataWriter writer;
    private double[][] valueMatrix;
    private double[] valueMatrixAverage;
    private double[][] monthValueMatrix;
    private double[] StDev;
    private double[] dailyValue;
    private double[] weightVal;
    private String[] dateVals;
    private String timeFormat = "%1$td.%1$tm.%1$tY";
    private int tcounter;
    private int daycounter = 0;
    private int oldMonth;
    private int nEnts;
    private double[][] aggMatrix;
    private int[] aggCounter;
    private String[] aggFieldNames;
    private JAMSTimeInterval timeInterval2;
    private int counter = 0;
    private int aggTsteps = 0;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSCalendar model_sd = this.modelTimeInterval.getStart().clone();
        JAMSCalendar model_ed = this.modelTimeInterval.getEnd().clone();
        int model_tres = this.modelTimeInterval.getTimeUnit();
        long sdMod = model_sd.getTimeInMillis();
        long edMod = model_ed.getTimeInMillis();
        long model_tsteps = 0L;
        model_tsteps = this.modelTimeInterval.getNumberOfTimesteps();
        JAMSCalendar agg_sd = this.aggTimeInterval.getStart().clone();
        JAMSCalendar agg_ed = this.aggTimeInterval.getEnd().clone();
        int agg_tres = this.aggTimeInterval.getTimeUnit();
        long sdAgg = agg_sd.getTimeInMillis();
        long edAgg = agg_ed.getTimeInMillis();
        if (agg_sd.before((Object)model_sd)) {
            this.aggTimeInterval.setStart(model_sd);
            this.getModel().getRuntime().println("aggStartdate was set equal to model startdate", 1);
        }
        if (model_ed.before((Object)agg_ed)) {
            this.aggTimeInterval.setEnd(model_ed);
            this.getModel().getRuntime().println("aggEnddate was set equal to model enddate", 1);
        }
        this.aggTsteps = (int)this.aggTimeInterval.getNumberOfTimesteps();
        int ts = (int)this.getContext().getNumberOfIterations();
        this.getModel().getRuntime().println("aggStartdate:\t" + agg_sd.toString(), 2);
        this.getModel().getRuntime().println("aggEnddate:\t" + agg_ed.toString(), 2);
        agg_ed.setTimeInMillis(edAgg += 86400000L);
        this.aggTimeInterval.setEnd(agg_ed);
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
        this.timeInterval2 = new JAMSTimeInterval(this.aggTimeInterval.getStart(), this.aggTimeInterval.getEnd(), 2, 1);
        int tsteps = (int)this.timeInterval2.getNumberOfTimesteps();
        this.nEnts = this.entities.getEntityArray().length;
        this.valueMatrix = new double[tsteps + 1][this.nEnts];
        this.valueMatrixAverage = new double[this.nEnts];
        this.StDev = new double[this.nEnts];
        this.dailyValue = new double[this.nEnts];
        this.dateVals = new String[tsteps];
        this.weightVal = new double[this.nEnts];
        this.timeFormat = "%1$tb/%1$ty";
        this.aggMatrix = new double[12][this.nEnts];
        this.aggCounter = new int[12];
        this.aggFieldNames = new String[12];
        this.tcounter = 0;
        int oldMonth = this.time.get(2);
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        if (!this.time.after((Object)this.aggTimeInterval.getEnd()) && !this.time.before((Object)this.aggTimeInterval.getStart())) {
            int i;
            int newMonth = this.time.get(2);
            if (newMonth != this.oldMonth) {
                this.dateVals[this.tcounter] = this.time.toString(this.timeFormat);
                if (this.tcounter > 0) {
                    int i2;
                    int month = this.oldMonth;
                    this.aggFieldNames[month] = this.time.toString("%1$tb");
                    if (this.type.getValue().equals("average")) {
                        for (i2 = 0; i2 < this.nEnts; ++i2) {
                            this.valueMatrixAverage[i2] = this.valueMatrix[this.tcounter][i2] / (double)this.daycounter;
                            double[] dArray = this.aggMatrix[month];
                            int n = i2;
                            dArray[n] = dArray[n] + this.valueMatrixAverage[i2];
                            this.valueMatrix[this.tcounter][i2] = this.valueMatrixAverage[i2];
                        }
                    } else if (this.type.getValue().equals("stDev")) {
                        for (i2 = 0; i2 < this.nEnts; ++i2) {
                            this.valueMatrixAverage[i2] = this.valueMatrix[this.tcounter][i2] / (double)this.daycounter;
                            double sum = 0.0;
                            for (int d = 0; d < this.daycounter; ++d) {
                                sum += Math.pow(this.monthValueMatrix[d][i2] - this.valueMatrixAverage[i2], 2.0);
                            }
                            this.StDev[i2] = Math.sqrt(sum / (double)(this.daycounter - 1));
                            this.valueMatrix[this.tcounter][i2] = this.StDev[i2];
                            double[] dArray = this.aggMatrix[month];
                            int n = i2;
                            dArray[n] = dArray[n] + this.valueMatrix[this.tcounter][i2];
                        }
                    } else if (this.type.getValue().equals("sum")) {
                        for (i2 = 0; i2 < this.nEnts; ++i2) {
                            double[] dArray = this.aggMatrix[month];
                            int n = i2;
                            dArray[n] = dArray[n] + this.valueMatrix[this.tcounter][i2];
                        }
                    }
                    int n = month;
                    this.aggCounter[n] = this.aggCounter[n] + 1;
                }
                ++this.tcounter;
                this.daycounter = 0;
            }
            if (this.daycounter == 0) {
                int d = this.time.getActualMaximum(5);
                this.monthValueMatrix = new double[d][this.nEnts];
            }
            if (this.weight.getValue().equals("none")) {
                for (i = 0; i < this.nEnts; ++i) {
                    this.dailyValue[i] = ((JAMSDouble)this.entities.getEntityArray()[i].getObject(this.attributeName.getValue())).getValue();
                    if (this.type.getValue().equals("stDev")) {
                        this.monthValueMatrix[this.daycounter][i] = this.dailyValue[i];
                    }
                    this.valueMatrix[this.tcounter][i] = this.valueMatrix[this.tcounter][i] + this.dailyValue[i];
                }
            } else {
                for (i = 0; i < this.nEnts; ++i) {
                    this.weightVal[i] = ((JAMSDouble)this.entities.getEntityArray()[i].getObject(this.weight.getValue())).getValue();
                    this.dailyValue[i] = ((JAMSDouble)this.entities.getEntityArray()[i].getObject(this.attributeName.getValue())).getValue() / this.weightVal[i];
                    if (this.type.getValue().equals("stDev")) {
                        this.monthValueMatrix[this.daycounter][i] = this.dailyValue[i];
                    }
                    this.valueMatrix[this.tcounter][i] = this.valueMatrix[this.tcounter][i] + this.dailyValue[i];
                }
            }
            ++this.daycounter;
            this.oldMonth = this.time.get(2);
        }
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
        this.getModel().getRuntime().println("Writing distributed output file ... may take a while ... please wait ...", 1);
        this.getModel().getRuntime().println("Number of entities: " + this.nEnts + ", number of timeSteps: " + this.dateVals.length);
        try {
            this.writer.addComment("J2K model output: " + this.header.getValue());
            this.writer.addComment("");
            this.writer.addColumn("ID");
            if (this.monthlyValuesWriting.getValue()) {
                for (int i = 0; i < this.tcounter - 1; ++i) {
                    this.writer.addColumn(this.dateVals[i]);
                }
            }
            this.writer.addColumn("Jan");
            this.writer.addColumn("Feb");
            this.writer.addColumn("Mar");
            this.writer.addColumn("Apr");
            this.writer.addColumn("May");
            this.writer.addColumn("Jun");
            this.writer.addColumn("Jul");
            this.writer.addColumn("Aug");
            this.writer.addColumn("Sep");
            this.writer.addColumn("Oct");
            this.writer.addColumn("Nov");
            this.writer.addColumn("Dec");
            this.writer.addColumn("Year");
            this.writer.writeHeader();
            for (int e = 0; e < this.nEnts; ++e) {
                String dStr;
                int ID = (int)((JAMSDouble)this.entities.getEntityArray()[e].getObject("ID")).getValue();
                this.writer.addData((Object)ID);
                if (this.monthlyValuesWriting.getValue()) {
                    for (int t = 1; t < this.tcounter; ++t) {
                        String dStr2 = String.format(Locale.US, "%.6f", this.valueMatrix[t][e]);
                        this.writer.addData((Object)dStr2);
                    }
                }
                double aggSum = 0.0;
                for (int t = 0; t < 12; ++t) {
                    aggSum += this.aggMatrix[t][e] / (double)this.aggCounter[t];
                    String dStr3 = String.format(Locale.US, "%.3f", this.aggMatrix[t][e] / (double)this.aggCounter[t]);
                    this.writer.addData((Object)dStr3);
                }
                if (!this.type.getValue().equals("sum")) {
                    aggSum /= 12.0;
                }
                if (this.weight.getValue().equals("none")) {
                    dStr = String.format(Locale.US, "%.3f", aggSum);
                    this.writer.addData((Object)dStr);
                } else {
                    dStr = String.format(Locale.US, "%.3f", aggSum);
                    this.writer.addData((Object)dStr);
                }
                this.writer.writeData();
            }
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Exception)((Object)jre));
        }
        this.writer.close();
        this.getModel().getRuntime().println("Finished distributed output file ... you may continue ...", 1);
    }
}

