/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.unijena.jams.JAMS;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLIO {
    public static Document getDocument(String fileName) throws FileNotFoundException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
        return document;
    }

    public static Document getDocumentFromString(String docString) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream source = new ByteArrayInputStream(docString.getBytes("ISO-8859-1"));
            document = builder.parse(source);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return document;
    }

    public static String getStringFromDocument(Document doc) {
        return XMLIO.xmlSerializerSun(doc);
    }

    public static String xmlSerializerSun(Document doc) {
        String returnValue = "";
        try {
            Transformer transformer = XMLIO.getTransformer();
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            returnValue = writer.toString();
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
        return returnValue;
    }

    public static boolean writeXmlFile(Document modelDoc, String filename) throws IOException {
        return XMLIO.writeXmlFile(modelDoc, new File(filename));
    }

    public static boolean writeXmlFile(Document doc, File savePath) throws IOException {
        if (!savePath.exists()) {
            savePath.createNewFile();
        }
        if (savePath.canWrite()) {
            try {
                Transformer transformer = XMLIO.getTransformer();
                DOMSource source = new DOMSource(doc);
                FileOutputStream os = new FileOutputStream(savePath);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
                os.close();
            }
            catch (TransformerConfigurationException tce) {
                return false;
            }
            catch (TransformerException te) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("encoding", "ISO-8859-1");
        return transformer;
    }
}

