/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.gml.producer.CoordinateWriter;
import org.geotools.gml.producer.GMLUtils;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GeometryTransformer
extends TransformerBase {
    private boolean useDummyZ = false;
    private int numDecimals = 4;

    public void setUseDummyZ(boolean flag) {
        this.useDummyZ = flag;
    }

    public void setNumDecimals(int num) {
        this.numDecimals = num;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new GeometryTranslator(handler, this.numDecimals, this.useDummyZ);
    }

    public static class GeometryTranslator
    extends TransformerBase.TranslatorSupport {
        CoordinateWriter coordWriter = new CoordinateWriter();

        public GeometryTranslator(ContentHandler handler) {
            super(handler, "gml", "http://www.opengis.net/gml");
        }

        public GeometryTranslator(ContentHandler handler, int numDecimals) {
            this(handler);
            this.coordWriter = new CoordinateWriter(numDecimals, false);
        }

        public GeometryTranslator(ContentHandler handler, int numDecimals, boolean isDummyZEnabled) {
            this(handler);
            this.coordWriter = new CoordinateWriter(numDecimals, isDummyZEnabled);
        }

        public boolean isDummyZEnabled() {
            return this.coordWriter.isDummyZEnabled();
        }

        public int getNumDecimals() {
            return this.coordWriter.getNumDecimals();
        }

        public void encode(Object o, String srsName) throws IllegalArgumentException {
            if (!(o instanceof Geometry)) {
                throw new IllegalArgumentException("Unable to encode " + o);
            }
            this.encode((Geometry)o, srsName);
        }

        public void encode(Object o) throws IllegalArgumentException {
            this.encode(o, null);
        }

        public void encode(Envelope bounds) {
            this.encode(bounds, (String)null);
        }

        public void encode(Envelope bounds, String srsName) {
            if (bounds.isNull()) {
                this.start("null");
                String text = "unknown";
                try {
                    this.contentHandler.characters(text.toCharArray(), 0, text.length());
                }
                catch (Exception e) {
                    System.out.println("got exception while writing null boundedby:" + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                this.end("null");
                return;
            }
            String boxName = "Box";
            if (srsName == null || srsName.equals("")) {
                this.start(boxName);
            } else {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "srsName", "srsName", "", srsName);
                this.start(boxName, atts);
            }
            try {
                Coordinate[] coords = new Coordinate[]{new Coordinate(bounds.getMinX(), bounds.getMinY()), new Coordinate(bounds.getMaxX(), bounds.getMaxY())};
                this.coordWriter.writeCoordinates(coords, this.contentHandler);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
            this.end(boxName);
        }

        public void encode(Geometry geometry) {
            this.encode(geometry, (String)null);
        }

        public void encode(Geometry geometry, String srsName) {
            String geomName = GMLUtils.getGeometryName(geometry);
            if (srsName == null || srsName.equals("")) {
                this.start(geomName);
            } else {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "srsName", "srsName", "", srsName);
                this.start(geomName, atts);
            }
            int geometryType = GMLUtils.getGeometryType(geometry);
            switch (geometryType) {
                case 1: 
                case 2: {
                    try {
                        this.coordWriter.writeCoordinates(geometry.getCoordinates(), this.contentHandler);
                        break;
                    }
                    catch (SAXException s) {
                        throw new RuntimeException(s);
                    }
                }
                case 3: {
                    this.writePolygon((Polygon)geometry);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.writeMulti((GeometryCollection)geometry, GMLUtils.getMemberName(geometryType));
                }
            }
            this.end(geomName);
        }

        private void writePolygon(Polygon geometry) {
            String outBound = "outerBoundaryIs";
            String lineRing = "LinearRing";
            String inBound = "innerBoundaryIs";
            this.start(outBound);
            this.start(lineRing);
            try {
                this.coordWriter.writeCoordinates(geometry.getExteriorRing().getCoordinates(), this.contentHandler);
            }
            catch (SAXException s) {
                throw new RuntimeException(s);
            }
            this.end(lineRing);
            this.end(outBound);
            int ii = geometry.getNumInteriorRing();
            for (int i = 0; i < ii; ++i) {
                this.start(inBound);
                this.start(lineRing);
                try {
                    this.coordWriter.writeCoordinates(geometry.getInteriorRingN(i).getCoordinates(), this.contentHandler);
                }
                catch (SAXException s) {
                    throw new RuntimeException(s);
                }
                this.end(lineRing);
                this.end(inBound);
            }
        }

        private void writeMulti(GeometryCollection geometry, String member) {
            int n = geometry.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.start(member);
                this.encode(geometry.getGeometryN(i));
                this.end(member);
            }
        }
    }
}

