/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Filter;

public class FilteredIterator
implements Iterator {
    private FeatureCollection collection;
    private Iterator delegate;
    private Filter filter;
    private Object next;

    public FilteredIterator(Iterator iterator, Filter filter) {
        this.collection = null;
        this.delegate = iterator;
        this.filter = filter;
    }

    public FilteredIterator(FeatureCollection collection, Filter filter) {
        this.collection = collection;
        this.delegate = collection.iterator();
        this.filter = filter;
        this.next = this.getNext();
    }

    void close() {
        if (this.collection != null) {
            this.collection.close(this.delegate);
        }
        this.collection = null;
        this.delegate = null;
        this.filter = null;
        this.next = null;
    }

    private Object getNext() {
        Feature item = null;
        while (this.delegate.hasNext()) {
            item = (Feature)this.delegate.next();
            if (!this.filter.contains(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Object current = this.next;
        this.next = this.getNext();
        return current;
    }

    public void remove() {
        if (this.delegate == null) {
            throw new IllegalStateException();
        }
        this.delegate.remove();
    }
}

