/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.net.URI;
import java.util.Arrays;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.xml.gml.GMLSchema;

public abstract class FeatureTypeFactory
extends FeatureTypeBuilder {
    private static FactoryRegistry registry;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static FactoryRegistry getServiceRegistry() {
        if (!$assertionsDisabled && !Thread.holdsLock(FeatureTypeFactory.class)) {
            throw new AssertionError();
        }
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(FeatureTypeFactory.class));
        }
        return registry;
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes) throws FactoryRegistryException, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, ns, isAbstract, superTypes, null);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes, AttributeType defaultGeometry) throws FactoryRegistryException, SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance(name);
        factory.addTypes(types);
        factory.setNamespace(ns);
        factory.setAbstract(isAbstract);
        if (defaultGeometry != null) {
            factory.setDefaultGeometry((GeometryAttributeType)defaultGeometry);
        }
        if (superTypes != null) {
            factory.setSuperTypes(Arrays.asList(superTypes));
        }
        return factory.getFeatureType();
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes, GeometryAttributeType defaultGeometry) throws FactoryRegistryException, SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance(name);
        factory.addTypes(types);
        factory.setNamespace(ns);
        factory.setAbstract(isAbstract);
        if (superTypes != null) {
            factory.setSuperTypes(Arrays.asList(superTypes));
        }
        if (defaultGeometry != null) {
            factory.setDefaultGeometry(defaultGeometry);
        }
        return factory.getFeatureType();
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract) throws FactoryRegistryException, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, ns, isAbstract, null);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns) throws FactoryRegistryException, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, ns, false);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name) throws FactoryRegistryException, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, GMLSchema.NAMESPACE, false);
    }

    public static synchronized FeatureTypeFactory newInstance(String name) throws FactoryRegistryException {
        FeatureTypeFactory newFactory;
        FeatureTypeFactory factory = (FeatureTypeFactory)FeatureTypeFactory.getServiceRegistry().getServiceProvider(FeatureTypeFactory.class, null, null, null);
        try {
            newFactory = (FeatureTypeFactory)factory.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new FactoryRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FactoryRegistryException(e.getMessage(), (Throwable)e);
        }
        newFactory.setName(name);
        return newFactory;
    }

    public static FeatureTypeFactory createTemplate(FeatureType original) throws FactoryRegistryException {
        FeatureTypeFactory builder = FeatureTypeFactory.newInstance(original.getTypeName());
        builder.importType(original);
        builder.setNamespace(original.getNamespace());
        builder.setDefaultGeometry(original.getDefaultGeometry());
        FeatureType[] ancestors = original.getAncestors();
        if (ancestors != null) {
            builder.setSuperTypes(Arrays.asList(ancestors));
        }
        return builder;
    }

    public String toString() {
        String types = "";
        int ii = this.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            types = types + this.get(i);
            if (i >= ii) continue;
            types = types + " , ";
        }
        return "FeatureTypeFactory(" + this.getClass().getName() + ") [ " + types + " ]";
    }

    static {
        $assertionsDisabled = !FeatureTypeFactory.class.desiredAssertionStatus();
    }
}

