/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultQuery
implements Query {
    private String[] properties;
    private int maxFeatures = Integer.MAX_VALUE;
    private Filter filter = Filter.NONE;
    private String typeName;
    private URI namespace = Query.NO_NAMESPACE;
    private String handle;
    private CoordinateReferenceSystem coordinateSystem;
    private CoordinateReferenceSystem coordinateSystemReproject;
    private SortBy[] sortBy;

    public DefaultQuery() {
    }

    public DefaultQuery(String typeName) {
        this(typeName, Filter.NONE);
    }

    public DefaultQuery(String typeName, Filter filter) {
        this(typeName, filter, Query.ALL_NAMES);
    }

    public DefaultQuery(String typeName, Filter filter, String[] properties) {
        this(typeName, null, filter, Integer.MAX_VALUE, properties, null);
    }

    public DefaultQuery(String typeName, Filter filter, int maxFeatures, String[] propNames, String handle) {
        this(typeName, null, filter, maxFeatures, propNames, handle);
    }

    public DefaultQuery(String typeName, URI namespace, Filter filter, int maxFeatures, String[] propNames, String handle) {
        this.typeName = typeName;
        this.filter = filter;
        this.namespace = namespace;
        this.properties = propNames;
        this.maxFeatures = maxFeatures;
        this.handle = handle;
    }

    public DefaultQuery(Query query) {
        this(query.getTypeName(), query.getNamespace(), query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
        this.coordinateSystem = query.getCoordinateSystem();
        this.coordinateSystemReproject = query.getCoordinateSystemReproject();
    }

    public String[] getPropertyNames() {
        return this.properties;
    }

    public void setPropertyNames(String[] propNames) {
        this.properties = propNames;
    }

    public void setPropertyNames(List propNames) {
        if (propNames == null) {
            this.properties = null;
            return;
        }
        String[] stringArr = new String[propNames.size()];
        this.properties = propNames.toArray(stringArr);
    }

    public boolean retrieveAllProperties() {
        return this.properties == null;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getVersion() {
        return null;
    }

    public int hashCode() {
        String[] n = this.getPropertyNames();
        return (n == null ? -1 : (n.length == 0 ? 0 : n.length | n[0].hashCode())) | this.getMaxFeatures() | (this.getFilter() == null ? 0 : this.getFilter().hashCode()) | (this.getTypeName() == null ? 0 : this.getTypeName().hashCode()) | (this.getVersion() == null ? 0 : this.getVersion().hashCode()) | (this.getCoordinateSystem() == null ? 0 : this.getCoordinateSystem().hashCode()) | (this.getCoordinateSystemReproject() == null ? 0 : this.getCoordinateSystemReproject().hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Query)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Query other = (Query)obj;
        return Arrays.equals(this.getPropertyNames(), other.getPropertyNames()) && this.retrieveAllProperties() == other.retrieveAllProperties() && this.getMaxFeatures() == other.getMaxFeatures() && (this.getFilter() == null ? other.getFilter() == null : this.getFilter().equals(other.getFilter())) && (this.getTypeName() == null ? other.getTypeName() == null : this.getTypeName().equals(other.getTypeName())) && (this.getVersion() == null ? other.getVersion() == null : this.getVersion().equals(other.getVersion())) && (this.getCoordinateSystem() == null ? other.getCoordinateSystem() == null : this.getCoordinateSystem().equals(other.getCoordinateSystem())) && (this.getCoordinateSystemReproject() == null ? other.getCoordinateSystemReproject() == null : this.getCoordinateSystemReproject().equals(other.getCoordinateSystemReproject()));
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("Query:");
        if (this.handle != null) {
            returnString.append(" [" + this.handle + "]");
        }
        returnString.append("\n   feature type: " + this.typeName);
        if (this.filter != null) {
            returnString.append("\n   filter: " + this.filter.toString());
        }
        returnString.append("\n   [properties: ");
        if (this.properties == null || this.properties.length == 0) {
            return returnString + " ALL ]";
        }
        for (int i = 0; i < this.properties.length; ++i) {
            returnString.append(this.properties[i]);
            if (i >= this.properties.length - 1) continue;
            returnString.append(", ");
        }
        returnString.append("]");
        return returnString.toString();
    }

    public CoordinateReferenceSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public CoordinateReferenceSystem getCoordinateSystemReproject() {
        return this.coordinateSystemReproject;
    }

    public void setCoordinateSystem(CoordinateReferenceSystem system) {
        this.coordinateSystem = system;
    }

    public void setCoordinateSystemReproject(CoordinateReferenceSystem system) {
        this.coordinateSystemReproject = system;
    }

    public SortBy[] getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortBy[] sortBy) {
        this.sortBy = sortBy;
    }
}

