/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.Background;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.Context;
import javax.media.j3d.Drawable;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.Fog;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dNotification;
import javax.media.j3d.J3dThread;
import javax.media.j3d.Light;
import javax.media.j3d.MasterControl;
import javax.media.j3d.ModelClip;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Raster;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RendererStructure;
import javax.media.j3d.RenderingError;
import javax.media.j3d.RenderingErrorListener;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Sound;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class Renderer
extends J3dThread {
    static final int WAIT = 0;
    static final int NOTIFY_AND_WAIT = 1;
    static final int NOTIFY = 2;
    static final int DECAL_NONE = 0;
    static final int DECAL_1ST_CHILD = 1;
    static final int DECAL_NTH_CHILD = 2;
    static final int NUM_ACCUMULATION_SAMPLES = 8;
    static final float[] ACCUM_SAMPLES_X = new float[]{-0.54818f, 0.56438f, 0.39462f, -0.54498f, -0.8379f, -0.39263f, 0.32254f, 0.84216f};
    static final float[] ACCUM_SAMPLES_Y = new float[]{0.55331f, -0.53495f, 0.4154f, -0.52829f, 0.82102f, -0.27383f, 0.09133f, -0.84399f};
    static final float accumValue = 0.125f;
    static final int RENDER = 0;
    static final int SWAP = 1;
    static final int REQUESTRENDER = 2;
    static final int REQUESTCLEANUP = 3;
    RendererStructure rendererStructure = new RendererStructure();
    Transform3D bgVworldToVpc = new Transform3D();
    long lasttime;
    long currtime;
    float numframes = 0.0f;
    static final boolean doTiming = false;
    private static int numInstances = 0;
    private int instanceNum = -1;
    boolean sharedStereoZBuffer;
    Context sharedCtx = null;
    long sharedCtxTimeStamp = 0L;
    private long sharedCtxDisplay = 0L;
    private Drawable sharedCtxDrawable = null;
    Context currentCtx = null;
    Drawable currentDrawable = null;
    int rendererBit = 0;
    int rendererId = 0;
    ArrayList dirtyRenderMoleculeList = new ArrayList();
    ArrayList dirtyRenderAtomList = new ArrayList();
    ArrayList dirtyDlistPerRinfoList = new ArrayList();
    ArrayList textureIdResourceFreeList = new ArrayList();
    ArrayList displayListResourceFreeList = new ArrayList();
    ArrayList textureReloadList = new ArrayList();
    J3dMessage[] renderMessage;
    Screen3D onScreen;
    Screen3D offScreen;
    Transform3D accumLeftProj = new Transform3D();
    Transform3D accumRightProj = new Transform3D();
    Transform3D accumInfLeftProj = new Transform3D();
    Transform3D accumInfRightProj = new Transform3D();
    J3dMessage[] m;
    int nmesg = 0;
    ArrayList<Context> listOfCtxs = new ArrayList();
    ArrayList<Canvas3D> listOfCanvases = new ArrayList();
    boolean needToRebuildDisplayList = false;
    boolean needToResendTextureDown = false;
    boolean dirtyDisplayList = false;
    ArrayList textureIDResourceTable = new ArrayList(5);
    private static RenderingErrorListener defaultErrorListener = null;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    Renderer(ThreadGroup threadGroup) {
        super(threadGroup);
        this.setName("J3D-Renderer-" + this.getInstanceNum());
        this.type = 16;
        this.rendererId = VirtualUniverse.mc.getRendererId();
        this.rendererBit = 1 << this.rendererId;
        this.renderMessage = new J3dMessage[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork(long l) {
        block230: {
            RenderBin renderBin = null;
            Canvas3D canvas3D = null;
            View view = null;
            int n = 1;
            boolean bl = false;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 1.0;
            double d4 = 1.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            boolean bl2 = false;
            Transform3D transform3D = null;
            int n2 = (Integer)this.args[0];
            try {
                if (n2 == 1) {
                    Object[] objectArray = (Object[])this.args[2];
                    view = (View)this.args[3];
                    for (int i = 0; i < objectArray.length; ++i) {
                        Canvas3D canvas3D2;
                        block229: {
                            canvas3D2 = (Canvas3D)objectArray[i];
                            if (!canvas3D2.isRunning) continue;
                            try {
                                if (!canvas3D2.validCanvas) continue;
                                if (!canvas3D2.active || canvas3D2.ctx == null || canvas3D2.view == null || !canvas3D2.imageReady) break block229;
                                if (canvas3D2.useDoubleBuffer) {
                                    DrawingSurfaceObject drawingSurfaceObject = canvas3D2.drawingSurfaceObject;
                                    synchronized (drawingSurfaceObject) {
                                        if (canvas3D2.validCtx) {
                                            int n3;
                                            if (VirtualUniverse.mc.doDsiRenderLock) {
                                                if (!canvas3D2.drawingSurfaceObject.renderLock()) {
                                                    break block229;
                                                }
                                                canvas3D2.makeCtxCurrent();
                                                canvas3D2.syncRender(canvas3D2.ctx, true);
                                                n3 = canvas3D2.swapBuffers(canvas3D2.ctx, canvas3D2.screen.display, canvas3D2.drawable);
                                                if (n3 != 0) {
                                                    canvas3D2.resetRendering(n3);
                                                }
                                                canvas3D2.drawingSurfaceObject.unLock();
                                            } else {
                                                canvas3D2.makeCtxCurrent();
                                                canvas3D2.syncRender(canvas3D2.ctx, true);
                                                n3 = canvas3D2.swapBuffers(canvas3D2.ctx, canvas3D2.screen.display, canvas3D2.drawable);
                                                if (n3 != 0) {
                                                    canvas3D2.resetRendering(n3);
                                                }
                                            }
                                        }
                                    }
                                }
                                canvas3D2.view.inCanvasCallback = true;
                                try {
                                    canvas3D2.postSwap();
                                }
                                catch (RuntimeException runtimeException) {
                                    System.err.println("Exception occurred during Canvas3D callback:");
                                    runtimeException.printStackTrace();
                                }
                                catch (Error error) {
                                    System.err.println("Error occurred during Canvas3D callback:");
                                    error.printStackTrace();
                                }
                                canvas3D2.imageReady = false;
                                canvas3D2.view.inCanvasCallback = false;
                                if (!canvas3D2.ctxChanged) {
                                    canvas3D2.canvasDirty = 7743;
                                    canvas3D2.modelMatrix = null;
                                    canvas3D2.ra = null;
                                } else {
                                    canvas3D2.ctxChanged = false;
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                if (VirtualUniverse.mc.doDsiRenderLock) {
                                    canvas3D2.drawingSurfaceObject.unLock();
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                runtimeException.printStackTrace();
                                if (VirtualUniverse.mc.doDsiRenderLock) {
                                    canvas3D2.drawingSurfaceObject.unLock();
                                }
                                canvas3D2.setFatalError();
                                RenderingError renderingError = new RenderingError(1, J3dI18N.getString("Renderer0"));
                                renderingError.setCanvas3D(canvas3D2);
                                renderingError.setGraphicsDevice(canvas3D2.graphicsConfiguration.getDevice());
                                Renderer.notifyErrorListeners(renderingError);
                            }
                        }
                        canvas3D2.releaseCtx();
                    }
                    if (view != null && view.viewCache.getDoHeadTracking()) {
                        VirtualUniverse.mc.sendRunMessage(view, 16);
                    }
                    break block230;
                }
                if (n2 == 3) {
                    Integer n4 = (Integer)this.args[2];
                    if (n4 == MasterControl.REMOVEALLCTXS_CLEANUP) {
                        this.removeAllCtxs();
                    } else if (n4 == MasterControl.FREECONTEXT_CLEANUP) {
                        Canvas3D canvas3D3 = (Canvas3D)this.args[1];
                        this.removeCtx(canvas3D3, canvas3D3.screen.display, canvas3D3.drawable, canvas3D3.ctx, true, true, false);
                    } else if (n4 == MasterControl.RESETCANVAS_CLEANUP) {
                        Canvas3D canvas3D4 = (Canvas3D)this.args[1];
                        if (canvas3D4.ctx != null) {
                            canvas3D4.makeCtxCurrent();
                        }
                        canvas3D4.freeContextResources(canvas3D4.screen.renderer, true, canvas3D4.ctx);
                    } else if (n4 == MasterControl.REMOVECTX_CLEANUP) {
                        Object[] objectArray = (Object[])this.args[1];
                        Canvas3D canvas3D5 = (Canvas3D)objectArray[0];
                        this.removeCtx(canvas3D5, (Long)objectArray[1], (Drawable)objectArray[2], (Context)objectArray[3], false, !canvas3D5.offScreen, false);
                    }
                    return;
                }
                this.nmesg = 0;
                int n5 = 0;
                if (n2 == 0) {
                    this.m = this.renderMessage;
                    this.m[0] = new J3dMessage();
                    this.m[0].type = ((Canvas3D)this.args[1]).offScreen ? 42 : 43;
                    this.m[0].incRefcount();
                    this.m[0].args[0] = this.args[1];
                    n5 = 1;
                } else {
                    this.m = this.rendererStructure.getMessages();
                    n5 = this.rendererStructure.getNumMessage();
                    if (n5 <= 0) {
                        return;
                    }
                }
                block81: while (this.nmesg < n5) {
                    int n6;
                    Object object;
                    Object object2;
                    Object object3 = this.m[this.nmesg].args[0];
                    if (object3 == null) {
                        GraphicsConfiguration[] graphicsConfigurationArray;
                        Object object4 = this.m[this.nmesg].args[1];
                        if (object4 instanceof Canvas3D) {
                            object2 = (Integer)this.m[this.nmesg].args[2];
                            object = (Canvas3D)object4;
                            if (object2 == MasterControl.SET_GRAPHICSCONFIG_FEATURES) {
                                try {
                                    if (((Canvas3D)object).offScreen) {
                                        ((Canvas3D)object).doubleBufferAvailable = false;
                                        ((Canvas3D)object).stereoAvailable = false;
                                    } else {
                                        ((Canvas3D)object).doubleBufferAvailable = ((Canvas3D)object).hasDoubleBuffer();
                                        ((Canvas3D)object).stereoAvailable = ((Canvas3D)object).hasStereo();
                                    }
                                    ((Canvas3D)object).actualStencilSize = ((Canvas3D)object).getStencilSize();
                                    n6 = ((Canvas3D)object).requestedStencilSize > 0 ? 1 : 0;
                                    ((Canvas3D)object).userStencilAvailable = n6 != 0 && ((Canvas3D)object).actualStencilSize > 0;
                                    ((Canvas3D)object).systemStencilAvailable = n6 == 0 && ((Canvas3D)object).actualStencilSize > 0;
                                    ((Canvas3D)object).sceneAntialiasingMultiSamplesAvailable = ((Canvas3D)object).hasSceneAntialiasingMultisample();
                                    ((Canvas3D)object).sceneAntialiasingAvailable = ((Canvas3D)object).sceneAntialiasingMultiSamplesAvailable ? true : ((Canvas3D)object).hasSceneAntialiasingAccum();
                                }
                                catch (RuntimeException runtimeException) {
                                    runtimeException.printStackTrace();
                                    ((Canvas3D)object).setFatalError();
                                    graphicsConfigurationArray = new RenderingError(2, J3dI18N.getString("Renderer1"));
                                    graphicsConfigurationArray.setCanvas3D((Canvas3D)object);
                                    graphicsConfigurationArray.setGraphicsDevice(((Canvas3D)object).graphicsConfiguration.getDevice());
                                    Renderer.notifyErrorListeners((RenderingError)graphicsConfigurationArray);
                                }
                                GraphicsConfigTemplate3D.runMonitor(2);
                            } else if (object2 == MasterControl.SET_QUERYPROPERTIES) {
                                try {
                                    ((Canvas3D)object).createQueryContext();
                                }
                                catch (RuntimeException runtimeException) {
                                    runtimeException.printStackTrace();
                                    ((Canvas3D)object).setFatalError();
                                    graphicsConfigurationArray = new RenderingError(3, J3dI18N.getString("Renderer2"));
                                    graphicsConfigurationArray.setCanvas3D((Canvas3D)object);
                                    graphicsConfigurationArray.setGraphicsDevice(((Canvas3D)object).graphicsConfiguration.getDevice());
                                    Renderer.notifyErrorListeners((RenderingError)graphicsConfigurationArray);
                                }
                                GraphicsConfigTemplate3D.runMonitor(2);
                                this.currentCtx = null;
                                this.currentDrawable = null;
                            }
                        } else {
                            if (object4 instanceof Integer) {
                                throw new AssertionError();
                            }
                            if (object4 instanceof GeometryArrayRetained) {
                                ((GeometryArrayRetained)object4).freeD3DArray(false);
                            } else if (object4 instanceof GraphicsConfigTemplate3D) {
                                RenderingError renderingError;
                                object2 = (GraphicsConfigTemplate3D)object4;
                                object = (Integer)this.m[this.nmesg].args[2];
                                if (object == MasterControl.GETBESTCONFIG) {
                                    GraphicsConfiguration graphicsConfiguration = null;
                                    graphicsConfigurationArray = (GraphicsConfiguration[])((GraphicsConfigTemplate3D)object2).testCfg;
                                    try {
                                        graphicsConfiguration = Pipeline.getPipeline().getBestConfiguration((GraphicsConfigTemplate3D)object2, graphicsConfigurationArray);
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        nullPointerException.printStackTrace();
                                    }
                                    catch (RuntimeException runtimeException) {
                                        runtimeException.printStackTrace();
                                        renderingError = new RenderingError(2, J3dI18N.getString("Renderer3"));
                                        renderingError.setGraphicsDevice(graphicsConfigurationArray[0].getDevice());
                                        Renderer.notifyErrorListeners(renderingError);
                                    }
                                    ((GraphicsConfigTemplate3D)object2).testCfg = graphicsConfiguration;
                                } else if (object == MasterControl.ISCONFIGSUPPORT) {
                                    n6 = 0;
                                    graphicsConfigurationArray = (GraphicsConfiguration)((GraphicsConfigTemplate3D)object2).testCfg;
                                    try {
                                        if (Pipeline.getPipeline().isGraphicsConfigSupported((GraphicsConfigTemplate3D)object2, (GraphicsConfiguration)graphicsConfigurationArray)) {
                                            n6 = 1;
                                        }
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        nullPointerException.printStackTrace();
                                    }
                                    catch (RuntimeException runtimeException) {
                                        runtimeException.printStackTrace();
                                        renderingError = new RenderingError(2, J3dI18N.getString("Renderer4"));
                                        renderingError.setGraphicsDevice(graphicsConfigurationArray.getDevice());
                                        Renderer.notifyErrorListeners(renderingError);
                                    }
                                    ((GraphicsConfigTemplate3D)object2).testCfg = n6 != 0;
                                }
                                GraphicsConfigTemplate3D.runMonitor(2);
                            }
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    canvas3D = (Canvas3D)object3;
                    int n7 = this.m[this.nmesg].type;
                    if (n7 == 61) {
                        canvas3D.drawable = null;
                        try {
                            canvas3D.drawable = canvas3D.createOffScreenBuffer(canvas3D.ctx, canvas3D.screen.display, canvas3D.fbConfig, canvas3D.offScreenCanvasSize.width, canvas3D.offScreenCanvasSize.height);
                        }
                        catch (RuntimeException runtimeException) {
                            runtimeException.printStackTrace();
                        }
                        if (canvas3D.drawable == null) {
                            canvas3D.setFatalError();
                            RenderingError renderingError = new RenderingError(4, J3dI18N.getString("Renderer5"));
                            renderingError.setCanvas3D(canvas3D);
                            renderingError.setGraphicsDevice(canvas3D.graphicsConfiguration.getDevice());
                            Renderer.notifyErrorListeners(renderingError);
                        }
                        canvas3D.offScreenBufferPending = false;
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (n7 == 62) {
                        Object[] objectArray = this.m[this.nmesg].args;
                        this.removeCtx(canvas3D, (Long)objectArray[1], (Drawable)objectArray[2], (Context)objectArray[3], false, !canvas3D.offScreen, true);
                        canvas3D.offScreenBufferPending = false;
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (canvas3D.view == null || !canvas3D.firstPaintCalled) {
                        if (n7 == 42) {
                            canvas3D.offScreenRendering = false;
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (!canvas3D.validCanvas && n7 != 42) {
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (n7 == 52) {
                        canvas3D.d3dResize();
                        VirtualUniverse.mc.sendRunMessage(canvas3D.view, 16);
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (n7 == 53) {
                        canvas3D.d3dToggle();
                        VirtualUniverse.mc.sendRunMessage(canvas3D.view, 16);
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (n7 == 44) {
                        int n8 = (Integer)this.m[this.nmesg].args[1];
                        if (this.needToResendTextureDown) {
                            ++VirtualUniverse.mc.resendTexTimestamp;
                            this.needToResendTextureDown = false;
                        }
                        if (canvas3D.isFatalError()) continue;
                        try {
                            if (canvas3D.ctx != null) {
                                canvas3D.beginScene();
                            }
                            switch (n8) {
                                case 0: {
                                    canvas3D.graphicsContext3D.doClear();
                                    break;
                                }
                                case 1: {
                                    canvas3D.graphicsContext3D.doDraw((Geometry)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 2: {
                                    canvas3D.doSwap();
                                    break;
                                }
                                case 3: {
                                    canvas3D.graphicsContext3D.doReadRaster((Raster)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 4: {
                                    canvas3D.graphicsContext3D.doSetAppearance((Appearance)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 5: {
                                    canvas3D.graphicsContext3D.doSetBackground((Background)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 6: {
                                    canvas3D.graphicsContext3D.doSetFog((Fog)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 7: {
                                    canvas3D.graphicsContext3D.doSetLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                    break;
                                }
                                case 8: {
                                    canvas3D.graphicsContext3D.doInsertLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                    break;
                                }
                                case 9: {
                                    canvas3D.graphicsContext3D.doRemoveLight((Integer)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 10: {
                                    canvas3D.graphicsContext3D.doAddLight((Light)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 11: {
                                    canvas3D.graphicsContext3D.doSetHiRes((HiResCoord)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 12: {
                                    transform3D = (Transform3D)this.m[this.nmesg].args[2];
                                    canvas3D.graphicsContext3D.doSetModelTransform(transform3D);
                                    break;
                                }
                                case 13: {
                                    transform3D = (Transform3D)this.m[this.nmesg].args[2];
                                    canvas3D.graphicsContext3D.doMultiplyModelTransform(transform3D);
                                    break;
                                }
                                case 14: {
                                    canvas3D.graphicsContext3D.doSetSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                    break;
                                }
                                case 15: {
                                    canvas3D.graphicsContext3D.doInsertSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                    break;
                                }
                                case 16: {
                                    canvas3D.graphicsContext3D.doRemoveSound((Integer)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 17: {
                                    canvas3D.graphicsContext3D.doAddSound((Sound)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 18: {
                                    canvas3D.graphicsContext3D.doSetAuralAttributes((AuralAttributes)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 19: {
                                    canvas3D.graphicsContext3D.doSetBufferOverride((Boolean)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 20: {
                                    canvas3D.graphicsContext3D.doSetFrontBufferRendering((Boolean)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 21: {
                                    canvas3D.graphicsContext3D.doSetStereoMode((Integer)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 22: {
                                    canvas3D.graphicsContext3D.doFlush((Boolean)this.m[this.nmesg].args[2]);
                                    break;
                                }
                                case 23: {
                                    canvas3D.graphics2D.doFlush();
                                    break;
                                }
                                case 24: {
                                    object2 = this.m[this.nmesg].args;
                                    canvas3D.graphics2D.doDrawAndFlushImage((BufferedImage)object2[2], ((Point)object2[3]).x, ((Point)object2[3]).y, (ImageObserver)object2[4]);
                                    break;
                                }
                                case 26: {
                                    canvas3D.graphics2D.doDispose();
                                    break;
                                }
                                case 25: {
                                    canvas3D.graphicsContext3D.doSetModelClip((ModelClip)this.m[this.nmesg].args[2]);
                                    break;
                                }
                            }
                            if (canvas3D.ctx != null) {
                                canvas3D.endScene();
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            runtimeException.printStackTrace();
                            canvas3D.setFatalError();
                            object = new RenderingError(3, J3dI18N.getString("Renderer6"));
                            ((RenderingError)object).setCanvas3D(canvas3D);
                            ((RenderingError)object).setGraphicsDevice(canvas3D.graphicsConfiguration.getDevice());
                            Renderer.notifyErrorListeners((RenderingError)object);
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    this.m[this.nmesg++].decRefcount();
                    if (canvas3D.isFatalError()) continue;
                    ImageComponent2DRetained imageComponent2DRetained = null;
                    if (n7 == 42) {
                        canvas3D.offScreenRendering = true;
                        if (canvas3D.drawable == null || !canvas3D.active) {
                            canvas3D.offScreenRendering = false;
                            continue;
                        }
                        imageComponent2DRetained = (ImageComponent2DRetained)canvas3D.offScreenBuffer.retained;
                        if (imageComponent2DRetained.isByReference()) {
                            imageComponent2DRetained.geomLock.getLock();
                        }
                        imageComponent2DRetained.evaluateExtensions(canvas3D);
                    } else if (!canvas3D.active) continue;
                    if (!canvas3D.offScreen) {
                        canvas3D.drawingSurfaceObject.getDrawingSurfaceObjectInfo();
                    }
                    renderBin = canvas3D.view.renderBin;
                    if (canvas3D.useSharedCtx && this.sharedCtx == null) {
                        this.sharedCtxDisplay = canvas3D.screen.display;
                        this.sharedCtxDrawable = canvas3D.drawable;
                        if (!canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                imageComponent2DRetained.geomLock.unLock();
                            }
                            canvas3D.offScreenRendering = false;
                            break;
                        }
                        object2 = VirtualUniverse.mc.contextCreationLock;
                        synchronized (object2) {
                            this.sharedCtx = null;
                            try {
                                this.sharedCtx = canvas3D.createNewContext(null, true);
                            }
                            catch (RuntimeException runtimeException) {
                                runtimeException.printStackTrace();
                            }
                            if (this.sharedCtx == null) {
                                canvas3D.drawingSurfaceObject.unLock();
                                if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                    imageComponent2DRetained.geomLock.unLock();
                                }
                                canvas3D.offScreenRendering = false;
                                canvas3D.setFatalError();
                                object = new RenderingError(3, J3dI18N.getString("Renderer7"));
                                ((RenderingError)object).setCanvas3D(canvas3D);
                                ((RenderingError)object).setGraphicsDevice(canvas3D.graphicsConfiguration.getDevice());
                                Renderer.notifyErrorListeners((RenderingError)object);
                                break;
                            }
                            this.sharedCtxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.needToRebuildDisplayList = true;
                        }
                        canvas3D.drawingSurfaceObject.unLock();
                    }
                    if (canvas3D.ctx == null) {
                        if (!canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                imageComponent2DRetained.geomLock.unLock();
                            }
                            canvas3D.offScreenRendering = false;
                            break;
                        }
                        object2 = VirtualUniverse.mc.contextCreationLock;
                        synchronized (object2) {
                            canvas3D.ctx = null;
                            try {
                                canvas3D.ctx = canvas3D.createNewContext(this.sharedCtx, false);
                            }
                            catch (RuntimeException runtimeException) {
                                runtimeException.printStackTrace();
                            }
                            if (canvas3D.ctx == null) {
                                canvas3D.drawingSurfaceObject.unLock();
                                if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                    imageComponent2DRetained.geomLock.unLock();
                                }
                                canvas3D.offScreenRendering = false;
                                canvas3D.setFatalError();
                                object = new RenderingError(3, J3dI18N.getString("Renderer7"));
                                ((RenderingError)object).setCanvas3D(canvas3D);
                                ((RenderingError)object).setGraphicsDevice(canvas3D.graphicsConfiguration.getDevice());
                                Renderer.notifyErrorListeners((RenderingError)object);
                                break;
                            }
                            if (canvas3D.graphics2D != null) {
                                canvas3D.graphics2D.init();
                            }
                            canvas3D.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                            this.listOfCtxs.add(canvas3D.ctx);
                            this.listOfCanvases.add(canvas3D);
                            if (renderBin.nodeComponentList.size() > 0) {
                                for (int i = 0; i < renderBin.nodeComponentList.size(); ++i) {
                                    object = (NodeComponentRetained)renderBin.nodeComponentList.get(i);
                                    if (!(object instanceof ImageComponent2DRetained)) continue;
                                    ((ImageComponent2DRetained)object).evaluateExtensions(canvas3D);
                                }
                            }
                            canvas3D.enableSeparateSpecularColor();
                        }
                        if (canvas3D.texUnitState == null) {
                            canvas3D.createTexUnitState();
                        }
                        canvas3D.resetImmediateRendering(0);
                        canvas3D.drawingSurfaceObject.contextValidated();
                        if (!canvas3D.useSharedCtx) {
                            canvas3D.needToRebuildDisplayList = true;
                        }
                        canvas3D.drawingSurfaceObject.unLock();
                    } else if (canvas3D.isRunning) {
                        canvas3D.makeCtxCurrent();
                    }
                    if (renderBin != null) {
                        Object object5;
                        int n9;
                        int n10;
                        boolean bl3;
                        if (VirtualUniverse.mc.doDsiRenderLock && !canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                imageComponent2DRetained.geomLock.unLock();
                            }
                            canvas3D.offScreenRendering = false;
                            break;
                        }
                        if (this.needToResendTextureDown) {
                            ++VirtualUniverse.mc.resendTexTimestamp;
                            this.needToResendTextureDown = false;
                        }
                        if (canvas3D.useSharedCtx) {
                            this.freeResourcesInFreeList(canvas3D);
                        } else {
                            canvas3D.freeResourcesInFreeList(canvas3D.ctx);
                        }
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            canvas3D.drawingSurfaceObject.unLock();
                        }
                        object2 = canvas3D.canvasViewCache;
                        canvas3D.updateViewCache(false, null, null, renderBin.geometryBackground != null);
                        if (VirtualUniverse.mc.doDsiRenderLock && !canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                imageComponent2DRetained.geomLock.unLock();
                            }
                            canvas3D.offScreenRendering = false;
                            break;
                        }
                        canvas3D.setViewport(canvas3D.ctx, 0, 0, ((CanvasViewCache)object2).getCanvasWidth(), ((CanvasViewCache)object2).getCanvasHeight());
                        if (canvas3D.useSharedCtx) {
                            int n11;
                            if (this.needToRebuildDisplayList) {
                                renderBin.updateAllRenderMolecule(this, canvas3D);
                                this.needToRebuildDisplayList = false;
                            }
                            if (this.dirtyDisplayList) {
                                renderBin.updateDirtyDisplayLists(canvas3D, this.dirtyRenderMoleculeList, this.dirtyDlistPerRinfoList, this.dirtyRenderAtomList, true);
                                this.dirtyDisplayList = false;
                            }
                            if ((n11 = this.textureReloadList.size()) > 0) {
                                for (int i = n11 - 1; i >= 0; --i) {
                                    ((TextureRetained)this.textureReloadList.get(i)).reloadTextureSharedContext(canvas3D);
                                }
                                this.textureReloadList.clear();
                            }
                        } else {
                            if (canvas3D.needToRebuildDisplayList) {
                                renderBin.updateAllRenderMolecule(canvas3D);
                                canvas3D.needToRebuildDisplayList = false;
                            }
                            if (canvas3D.dirtyDisplayList) {
                                renderBin.updateDirtyDisplayLists(canvas3D, canvas3D.dirtyRenderMoleculeList, canvas3D.dirtyDlistPerRinfoList, canvas3D.dirtyRenderAtomList, false);
                                canvas3D.dirtyDisplayList = false;
                            }
                        }
                        if (canvas3D.view.localEyeLightingEnable != canvas3D.ctxEyeLightingEnable) {
                            canvas3D.ctxUpdateEyeLightingEnable(canvas3D.ctx, canvas3D.view.localEyeLightingEnable);
                            canvas3D.ctxEyeLightingEnable = canvas3D.view.localEyeLightingEnable;
                        }
                        if (bl3 = ((CanvasViewCache)object2).getUseStereo()) {
                            n10 = 2;
                            n9 = 0;
                            this.sharedStereoZBuffer = VirtualUniverse.mc.sharedStereoZBuffer;
                        } else {
                            n10 = 1;
                            n9 = 2;
                            this.sharedStereoZBuffer = false;
                        }
                        if (canvas3D.view.getSceneAntialiasingEnable() && canvas3D.sceneAntialiasingAvailable) {
                            if (!VirtualUniverse.mc.isD3D() && (canvas3D.extensionsSupported & 8) == 0 || !canvas3D.sceneAntialiasingMultiSamplesAvailable) {
                                bl = true;
                                n = 8;
                                System.arraycopy(((CanvasViewCache)object2).getLeftProjection().mat, 0, this.accumLeftProj.mat, 0, 16);
                                d3 = canvas3D.canvasViewCache.getPhysicalWindowWidth() / (double)canvas3D.canvasViewCache.getCanvasWidth() * canvas3D.view.fieldOfView;
                                d4 = canvas3D.canvasViewCache.getPhysicalWindowHeight() / (double)canvas3D.canvasViewCache.getCanvasHeight() * canvas3D.view.fieldOfView;
                                d5 = this.accumLeftProj.mat[3];
                                d6 = this.accumLeftProj.mat[7];
                                if (bl3) {
                                    System.arraycopy(((CanvasViewCache)object2).getRightProjection().mat, 0, this.accumRightProj.mat, 0, 16);
                                    d7 = this.accumRightProj.mat[3];
                                    d8 = this.accumRightProj.mat[7];
                                }
                                if (renderBin.geometryBackground != null) {
                                    System.arraycopy(((CanvasViewCache)object2).getInfLeftProjection().mat, 0, this.accumInfLeftProj.mat, 0, 16);
                                    d9 = this.accumInfLeftProj.mat[3];
                                    d10 = this.accumInfLeftProj.mat[7];
                                    if (bl3) {
                                        System.arraycopy(((CanvasViewCache)object2).getInfRightProjection().mat, 0, this.accumInfRightProj.mat, 0, 16);
                                        d11 = this.accumInfRightProj.mat[3];
                                        d12 = this.accumInfRightProj.mat[7];
                                    }
                                }
                            } else if (!canvas3D.antialiasingSet) {
                                canvas3D.setFullSceneAntialiasing(canvas3D.ctx, true);
                                canvas3D.antialiasingSet = true;
                            }
                        } else if (canvas3D.antialiasingSet) {
                            canvas3D.setFullSceneAntialiasing(canvas3D.ctx, false);
                            canvas3D.antialiasingSet = false;
                        }
                        if (renderBin.geometryBackground != null) {
                            renderBin.updateInfVworldToVpc();
                        }
                        canvas3D.setRenderMode(canvas3D.ctx, 2, canvas3D.useDoubleBuffer);
                        canvas3D.beginScene();
                        n6 = ((CanvasViewCache)object2).getCanvasWidth();
                        int n12 = ((CanvasViewCache)object2).getCanvasHeight();
                        if (!bl && !this.sharedStereoZBuffer) {
                            object5 = renderBin.background;
                            canvas3D.clear((BackgroundRetained)object5, n6, n12);
                        }
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            canvas3D.drawingSurfaceObject.unLock();
                        }
                        canvas3D.view.inCanvasCallback = true;
                        try {
                            canvas3D.preRender();
                        }
                        catch (RuntimeException runtimeException) {
                            System.err.println("Exception occurred during Canvas3D callback:");
                            runtimeException.printStackTrace();
                        }
                        catch (Error error) {
                            System.err.println("Error occurred during Canvas3D callback:");
                            error.printStackTrace();
                        }
                        canvas3D.view.inCanvasCallback = false;
                        if (VirtualUniverse.mc.doDsiRenderLock && !canvas3D.drawingSurfaceObject.renderLock()) {
                            if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                imageComponent2DRetained.geomLock.unLock();
                            }
                            canvas3D.offScreenRendering = false;
                            break;
                        }
                        for (int i = 0; i < n10; ++i) {
                            if (bl) {
                                canvas3D.clearAccum(canvas3D.ctx);
                            }
                            canvas3D.setRenderMode(canvas3D.ctx, n9, canvas3D.useDoubleBuffer);
                            for (int j = 0; j < n; ++j) {
                                if (bl) {
                                    d = (double)ACCUM_SAMPLES_X[j] * d3;
                                    d2 = (double)ACCUM_SAMPLES_Y[j] * d4;
                                    this.accumLeftProj.mat[3] = d5 + this.accumLeftProj.mat[0] * d + this.accumLeftProj.mat[1] * d2;
                                    this.accumLeftProj.mat[7] = d6 + this.accumLeftProj.mat[4] * d + this.accumLeftProj.mat[5] * d2;
                                    if (bl3) {
                                        this.accumRightProj.mat[3] = d7 + this.accumRightProj.mat[0] * d + this.accumRightProj.mat[1] * d2;
                                        this.accumRightProj.mat[7] = d8 + this.accumRightProj.mat[4] * d + this.accumRightProj.mat[5] * d2;
                                    }
                                    if (renderBin.geometryBackground != null) {
                                        this.accumInfLeftProj.mat[3] = d9 + this.accumInfLeftProj.mat[0] * d + this.accumInfLeftProj.mat[1] * d2;
                                        this.accumInfLeftProj.mat[7] = d10 + this.accumInfLeftProj.mat[4] * d + this.accumInfLeftProj.mat[5] * d2;
                                        if (bl3) {
                                            this.accumInfRightProj.mat[3] = d11 + this.accumInfRightProj.mat[0] * d + this.accumInfRightProj.mat[1] * d2;
                                            this.accumInfRightProj.mat[7] = d12 + this.accumInfRightProj.mat[4] * d + this.accumInfRightProj.mat[5] * d2;
                                        }
                                    }
                                }
                                if (bl || this.sharedStereoZBuffer) {
                                    object5 = renderBin.background;
                                    canvas3D.clear((BackgroundRetained)object5, n6, n12);
                                }
                                if (renderBin.geometryBackground != null) {
                                    if (i == 0) {
                                        canvas3D.vpcToEc = ((CanvasViewCache)object2).getInfLeftVpcToEc();
                                        if (bl) {
                                            canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumInfLeftProj);
                                        } else {
                                            canvas3D.setProjectionMatrix(canvas3D.ctx, ((CanvasViewCache)object2).getInfLeftProjection());
                                        }
                                    } else {
                                        canvas3D.vpcToEc = ((CanvasViewCache)object2).getInfRightVpcToEc();
                                        if (bl) {
                                            canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumInfRightProj);
                                        } else {
                                            canvas3D.setProjectionMatrix(canvas3D.ctx, ((CanvasViewCache)object2).getInfRightProjection());
                                        }
                                    }
                                    canvas3D.vworldToEc.mul(canvas3D.vpcToEc, ((CanvasViewCache)object2).getInfVworldToVpc());
                                    renderBin.renderBackground(canvas3D);
                                }
                                if (i == 0) {
                                    canvas3D.vpcToEc = ((CanvasViewCache)object2).getLeftVpcToEc();
                                    if (bl) {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumLeftProj);
                                    } else {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, ((CanvasViewCache)object2).getLeftProjection());
                                    }
                                } else {
                                    canvas3D.vpcToEc = ((CanvasViewCache)object2).getRightVpcToEc();
                                    if (bl) {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, this.accumRightProj);
                                    } else {
                                        canvas3D.setProjectionMatrix(canvas3D.ctx, ((CanvasViewCache)object2).getRightProjection());
                                    }
                                }
                                canvas3D.vworldToEc.mul(canvas3D.vpcToEc, ((CanvasViewCache)object2).getVworldToVpc());
                                object5 = object2;
                                synchronized (object5) {
                                    if (i == 0) {
                                        canvas3D.setFrustumPlanes(((CanvasViewCache)object2).getLeftFrustumPlanesInVworld());
                                    } else {
                                        canvas3D.setFrustumPlanes(((CanvasViewCache)object2).getRightFrustumPlanesInVworld());
                                    }
                                }
                                if (bl3) {
                                    canvas3D.canvasDirty |= 0x8000;
                                }
                                renderBin.renderOpaque(canvas3D);
                                renderBin.renderOrdered(canvas3D);
                                if (VirtualUniverse.mc.doDsiRenderLock) {
                                    canvas3D.drawingSurfaceObject.unLock();
                                }
                                canvas3D.view.inCanvasCallback = true;
                                try {
                                    canvas3D.renderField(n9);
                                }
                                catch (RuntimeException runtimeException) {
                                    System.err.println("Exception occurred during Canvas3D callback:");
                                    runtimeException.printStackTrace();
                                }
                                catch (Error error) {
                                    System.err.println("Error occurred during Canvas3D callback:");
                                    error.printStackTrace();
                                }
                                canvas3D.view.inCanvasCallback = false;
                                if (VirtualUniverse.mc.doDsiRenderLock && !canvas3D.drawingSurfaceObject.renderLock()) {
                                    if (imageComponent2DRetained != null && imageComponent2DRetained.isByReference()) {
                                        imageComponent2DRetained.geomLock.unLock();
                                    }
                                    canvas3D.offScreenRendering = false;
                                    break block81;
                                }
                                renderBin.renderTransparent(canvas3D);
                                if (!bl) continue;
                                canvas3D.accum(canvas3D.ctx, 0.125f);
                            }
                            if (bl) {
                                canvas3D.accumReturn(canvas3D.ctx);
                            }
                            if (!bl3) continue;
                            n9 = 1;
                            canvas3D.rightStereoPass = true;
                        }
                        canvas3D.imageReady = true;
                        canvas3D.rightStereoPass = false;
                        canvas3D.setRenderMode(canvas3D.ctx, 2, canvas3D.useDoubleBuffer);
                        if (VirtualUniverse.mc.doDsiRenderLock) {
                            canvas3D.drawingSurfaceObject.unLock();
                        }
                        canvas3D.view.inCanvasCallback = true;
                        try {
                            canvas3D.postRender();
                        }
                        catch (RuntimeException runtimeException) {
                            System.err.println("Exception occurred during Canvas3D callback:");
                            runtimeException.printStackTrace();
                        }
                        catch (Error error) {
                            System.err.println("Error occurred during Canvas3D callback:");
                            error.printStackTrace();
                        }
                        canvas3D.view.inCanvasCallback = false;
                        if (canvas3D.offScreenRendering) {
                            canvas3D.syncRender(canvas3D.ctx, true);
                            canvas3D.endOffScreenRendering();
                            canvas3D.offScreenRendering = false;
                            canvas3D.view.inCanvasCallback = true;
                            try {
                                canvas3D.postSwap();
                            }
                            catch (RuntimeException runtimeException) {
                                System.err.println("Exception occurred during Canvas 3D callback:");
                                runtimeException.printStackTrace();
                            }
                            catch (Error error) {
                                System.err.println("Error occurred during Canvas3D callback:");
                                error.printStackTrace();
                            }
                            if (imageComponent2DRetained.isByReference()) {
                                imageComponent2DRetained.geomLock.unLock();
                            }
                            canvas3D.view.inCanvasCallback = false;
                            canvas3D.releaseCtx();
                        }
                        canvas3D.endScene();
                        continue;
                    }
                    if (imageComponent2DRetained == null || !imageComponent2DRetained.isByReference()) continue;
                    imageComponent2DRetained.geomLock.unLock();
                }
                if (n2 == 0) {
                    this.m[0] = null;
                } else {
                    Arrays.fill(this.m, 0, n5, null);
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                if (canvas3D != null) {
                    if (canvas3D.ctx != null) {
                        canvas3D.endScene();
                    }
                    canvas3D.drawingSurfaceObject.unLock();
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                if (canvas3D != null) {
                    if (canvas3D.ctx != null) {
                        canvas3D.endScene();
                    }
                    canvas3D.drawingSurfaceObject.unLock();
                }
                canvas3D.setFatalError();
                RenderingError renderingError = new RenderingError(1, J3dI18N.getString("Renderer8"));
                renderingError.setCanvas3D(canvas3D);
                if (canvas3D != null) {
                    renderingError.setGraphicsDevice(canvas3D.graphicsConfiguration.getDevice());
                }
                Renderer.notifyErrorListeners(renderingError);
            }
        }
    }

    void shutdown() {
        this.removeAllCtxs();
        Pipeline.getPipeline().cleanupRenderer();
    }

    void cleanup() {
        super.cleanup();
        this.renderMessage = new J3dMessage[1];
        this.rendererStructure = new RendererStructure();
        this.bgVworldToVpc = new Transform3D();
        this.numframes = 0.0f;
        this.sharedCtx = null;
        this.sharedCtxTimeStamp = 0L;
        this.sharedCtxDisplay = 0L;
        this.sharedCtxDrawable = null;
        this.dirtyRenderMoleculeList.clear();
        this.dirtyRenderAtomList.clear();
        this.dirtyDlistPerRinfoList.clear();
        this.textureIdResourceFreeList.clear();
        this.displayListResourceFreeList.clear();
        this.onScreen = null;
        this.offScreen = null;
        this.m = null;
        this.nmesg = 0;
        this.lasttime = 0L;
        this.currtime = 0L;
    }

    final void makeCtxCurrent(Context context, long l, Drawable drawable) {
        if (context != this.currentCtx || drawable != this.currentDrawable) {
            Canvas3D.useCtx(context, l, drawable);
            this.currentCtx = context;
            this.currentDrawable = drawable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCtx(Canvas3D canvas3D, long l, Drawable drawable, Context context, boolean bl, boolean bl2, boolean bl3) {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (context != null) {
                int n = this.listOfCtxs.indexOf(context);
                if (n >= 0) {
                    this.listOfCtxs.remove(n);
                    this.listOfCanvases.remove(n);
                    if (drawable != null && canvas3D.added && canvas3D.drawingSurfaceObject.renderLock()) {
                        if (this.sharedCtx != null) {
                            if (this.listOfCtxs.isEmpty()) {
                                this.makeCtxCurrent(this.sharedCtx, this.sharedCtxDisplay, this.sharedCtxDrawable);
                                this.freeResourcesInFreeList(null);
                                this.freeContextResources();
                                Canvas3D.destroyContext(this.sharedCtxDisplay, this.sharedCtxDrawable, this.sharedCtx);
                                this.currentCtx = null;
                                this.currentDrawable = null;
                            } else {
                                this.freeResourcesInFreeList(canvas3D);
                            }
                            canvas3D.makeCtxCurrent(context, l, drawable);
                        } else {
                            canvas3D.makeCtxCurrent(context, l, drawable);
                            canvas3D.freeResourcesInFreeList(context);
                        }
                        canvas3D.freeContextResources(this, bl2, context);
                        Canvas3D.destroyContext(l, drawable, context);
                        this.currentCtx = null;
                        this.currentDrawable = null;
                        canvas3D.drawingSurfaceObject.unLock();
                    }
                }
                if (bl) {
                    canvas3D.ctx = null;
                }
                if (this.sharedCtx != null && this.listOfCtxs.isEmpty()) {
                    this.sharedCtx = null;
                    this.sharedCtxTimeStamp = 0L;
                }
                canvas3D.ctxTimeStamp = 0L;
            }
            if (bl3) {
                canvas3D.destroyOffScreenBuffer(context, l, canvas3D.fbConfig, drawable);
                canvas3D.offScreenBufferPending = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllCtxs() {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            for (int i = this.listOfCanvases.size() - 1; i >= 0; --i) {
                Canvas3D canvas3D = this.listOfCanvases.get(i);
                if (canvas3D.screen != null && canvas3D.ctx != null && canvas3D.drawable != null && canvas3D.added && canvas3D.drawingSurfaceObject.renderLock()) {
                    if (i == 0 && this.sharedCtx != null) {
                        this.makeCtxCurrent(this.sharedCtx, this.sharedCtxDisplay, this.sharedCtxDrawable);
                        this.freeResourcesInFreeList(null);
                        this.freeContextResources();
                        Canvas3D.destroyContext(this.sharedCtxDisplay, this.sharedCtxDrawable, this.sharedCtx);
                        this.currentCtx = null;
                        this.currentDrawable = null;
                    }
                    canvas3D.makeCtxCurrent();
                    canvas3D.freeResourcesInFreeList(canvas3D.ctx);
                    canvas3D.freeContextResources(this, true, canvas3D.ctx);
                    Canvas3D.destroyContext(canvas3D.screen.display, canvas3D.drawable, canvas3D.ctx);
                    this.currentCtx = null;
                    this.currentDrawable = null;
                    canvas3D.drawingSurfaceObject.unLock();
                }
                canvas3D.ctx = null;
                canvas3D.ctxTimeStamp = 0L;
            }
            if (this.sharedCtx != null) {
                this.sharedCtx = null;
                this.sharedCtxTimeStamp = 0L;
            }
            this.listOfCanvases.clear();
            this.listOfCtxs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeResourcesInFreeList(Canvas3D canvas3D) {
        boolean bl;
        boolean bl2 = this.textureIdResourceFreeList.size() > 0;
        boolean bl3 = bl = this.displayListResourceFreeList.size() > 0;
        if (bl2 || bl) {
            int n;
            Iterator iterator;
            if (canvas3D != null) {
                canvas3D.makeCtxCurrent(this.sharedCtx);
            }
            if (bl) {
                iterator = this.displayListResourceFreeList.iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    if (n <= 0) continue;
                    Canvas3D.freeDisplayList(this.sharedCtx, n);
                }
                this.displayListResourceFreeList.clear();
            }
            if (bl2) {
                iterator = this.textureIdResourceFreeList.iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    if (n <= 0) continue;
                    if (n >= this.textureIDResourceTable.size()) {
                        System.out.println("Error in freeResourcesInFreeList : ResourceIDTableSize = " + this.textureIDResourceTable.size() + " val = " + n);
                    } else {
                        Object e = this.textureIDResourceTable.get(n);
                        if (e instanceof TextureRetained) {
                            TextureRetained textureRetained = (TextureRetained)e;
                            Object object = textureRetained.resourceLock;
                            synchronized (object) {
                                textureRetained.resourceCreationMask &= ~this.rendererBit;
                                if (textureRetained.resourceCreationMask == 0) {
                                    textureRetained.freeTextureId(n);
                                }
                            }
                        }
                        this.textureIDResourceTable.set(n, null);
                    }
                    Canvas3D.freeTexture(this.sharedCtx, n);
                }
                this.textureIdResourceFreeList.clear();
            }
            if (canvas3D != null) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
            }
        }
    }

    final void addTextureResource(int n, Object object) {
        if (this.textureIDResourceTable.size() <= n) {
            for (int i = this.textureIDResourceTable.size(); i < n; ++i) {
                this.textureIDResourceTable.add(null);
            }
            this.textureIDResourceTable.add(object);
        } else {
            this.textureIDResourceTable.set(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeContextResources() {
        for (int i = this.textureIDResourceTable.size() - 1; i > 0; --i) {
            Object e = this.textureIDResourceTable.get(i);
            if (e == null) continue;
            Canvas3D.freeTexture(this.sharedCtx, i);
            if (!(e instanceof TextureRetained)) continue;
            TextureRetained textureRetained = (TextureRetained)e;
            Object object = textureRetained.resourceLock;
            synchronized (object) {
                textureRetained.resourceCreationMask &= ~this.rendererBit;
                if (textureRetained.resourceCreationMask == 0) {
                    textureRetained.freeTextureId(i);
                }
                continue;
            }
        }
        this.textureIDResourceTable.clear();
    }

    static void notifyErrorListeners(RenderingError renderingError) {
        J3dNotification j3dNotification = new J3dNotification();
        j3dNotification.type = 1;
        j3dNotification.universe = null;
        j3dNotification.args[0] = renderingError;
        VirtualUniverse.mc.sendNotification(j3dNotification);
    }

    static synchronized RenderingErrorListener getDefaultErrorListener() {
        if (defaultErrorListener == null) {
            defaultErrorListener = new DefaultErrorListener();
        }
        return defaultErrorListener;
    }

    static class DefaultErrorListener
    implements RenderingErrorListener {
        DefaultErrorListener() {
        }

        public void errorOccurred(RenderingError renderingError) {
            System.err.println();
            System.err.println("DefaultRenderingErrorListener.errorOccurred:");
            renderingError.printVerbose();
            System.exit(1);
        }
    }
}

