/*
 * Decompiled with CFR 0.152.
 */
package jams.components.tools;

import org.jscience.physics.units.Converter;
import org.jscience.physics.units.Unit;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="JScience Unit Converter", author="Sven Kralisch", date="1. December 2005", description="This component converts an input value having a certain unit into an output value having another unit. The units are represented by SI compliant unit strings, e.g. <math>\\frac{m^3}{s}</math>.")
public class JAMSUnitConverter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Unit of input value")
    public JAMSString inUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Unit of output value")
    public JAMSString outUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Input value")
    public JAMSDouble inValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Output value")
    public JAMSDouble outValue;
    Unit in;
    Unit out;
    Converter conv;

    public void init() {
        this.in = Unit.valueOf((CharSequence)this.inUnit.getValue());
        this.out = Unit.valueOf((CharSequence)this.outUnit.getValue());
        if (!this.in.isCompatible(this.out)) {
            this.getModel().getRuntime().sendHalt("Incompatible units: " + this.inUnit + " <-> " + this.outUnit);
        }
        this.conv = this.in.getConverterTo(this.out);
    }

    public void run() {
        this.outValue.setValue(this.conv.convert(this.inValue.getValue()));
    }
}

