/*
 * Decompiled with CFR 0.152.
 */
package jams.components.tools;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSComponentEnumerator;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="JAMS simple parameter sampler", author="Sven Kralisch", description="This component creates a context for a repeated component execution, e.g. for model calibration.For this purpose <code>lowerBound</code> and <code>upperBound</code> define borders of an interval where <code>count</code> double samples will be taken from. The samples will be distributed homogeneously over the specified interval without regard of additional information. For each sample taken the init, run and cleanup stages of all child components will be executed. At init stage the child components can access the JAMSSimpleParaSampler's <code>value</code> attribute which provides the current sample value. Multiple JAMSSimpleParaSamplers can be nested in order to sample a multi-dimensional parameter space.</br>An example application of the JAMSSimpleParaSampler could look as follows:</br><code><compoundcomponent class=\"org.unijena.jams.tools.JAMSSimpleParaSampler\" name=\"ParaSampler1\"></br>    <jamsvar name=\"lowerBound\" value=\"3\"/></br>    <jamsvar name=\"upperBound\" value=\"4\"/></br>    <jamsvar name=\"count\" value=\"3\"/></br>    <compoundcomponent class=\"org.unijena.jams.tools.JAMSSimpleParaSampler\" name=\"ParaSampler1\"></br>        <jamsvar name=\"lowerBound\" value=\"3\"/></br>        <jamsvar name=\"upperBound\" value=\"4\"/></br>        <jamsvar name=\"count\" value=\"3\"/></br>        <component class=\"...\" name=\"Process\"></br>           ...</br>           <jamsvar name=\"p1\" provider=\"ParaSampler1\" value=\"value\"/></br>           <jamsvar name=\"p2\" provider=\"ParaSampler2\" value=\"value\"/></br>           ...</br>        </component>    </compoundcomponent></compoundcomponent></code>")
public class JAMSSimpleParaSampler
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Sampling interval lower boundary")
    public JAMSDouble lowerBound;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Sampling interval upper boundary")
    public JAMSDouble upperBound;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of samples")
    public JAMSInteger count;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="current parameter value")
    public JAMSDouble value = new JAMSDouble(0.0);
    double stepSize;

    public void init() {
        if (this.count.getValue() < 2) {
            this.count.setValue(2);
        }
        this.stepSize = (this.upperBound.getValue() - this.lowerBound.getValue()) / (double)(this.count.getValue() - 1);
        this.value.setValue(this.lowerBound.getValue());
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = super.getChildrenEnumerator();
        }
        while (this.value.getValue() <= this.upperBound.getValue()) {
            JAMSComponent comp;
            this.runEnumerator.reset();
            while (this.runEnumerator.hasNext()) {
                comp = this.runEnumerator.next();
                try {
                    comp.init();
                }
                catch (Exception e) {
                    this.getModel().getRuntime().handle(e, comp.getInstanceName());
                }
            }
            this.runEnumerator.reset();
            while (this.runEnumerator.hasNext()) {
                comp = this.runEnumerator.next();
                try {
                    comp.run();
                }
                catch (Exception e) {
                    this.getModel().getRuntime().handle(e, comp.getInstanceName());
                }
            }
            this.runEnumerator.reset();
            while (this.runEnumerator.hasNext()) {
                comp = this.runEnumerator.next();
                try {
                    comp.cleanup();
                }
                catch (Exception e) {
                    this.getModel().getRuntime().handle(e, comp.getInstanceName());
                }
            }
            this.value.setValue(this.value.getValue() + this.stepSize);
        }
    }

    public void cleanup() {
    }

    public JAMSComponentEnumerator getRunEnumerator() {
        return new RunEnumerator();
    }

    public JAMSComponentEnumerator getChildrenEnumerator() {
        return super.getRunEnumerator();
    }

    public long getNumberOfIterations() {
        return this.count.getValue();
    }

    class RunEnumerator
    implements JAMSComponentEnumerator {
        JAMSComponentEnumerator ce;

        RunEnumerator() {
            this.ce = JAMSSimpleParaSampler.this.getChildrenEnumerator();
        }

        public boolean hasNext() {
            boolean nextValue = JAMSSimpleParaSampler.this.value.getValue() <= JAMSSimpleParaSampler.this.upperBound.getValue() - JAMSSimpleParaSampler.this.stepSize;
            boolean nextComp = this.ce.hasNext();
            return nextValue || nextComp;
        }

        public JAMSComponent next() {
            if (!this.ce.hasNext() && JAMSSimpleParaSampler.this.value.getValue() <= JAMSSimpleParaSampler.this.upperBound.getValue() - JAMSSimpleParaSampler.this.stepSize) {
                JAMSSimpleParaSampler.this.value.setValue(JAMSSimpleParaSampler.this.value.getValue() + JAMSSimpleParaSampler.this.stepSize);
                this.ce.reset();
            }
            return this.ce.next();
        }

        public void reset() {
            JAMSSimpleParaSampler.this.value.setValue(JAMSSimpleParaSampler.this.lowerBound.getValue());
            this.ce.reset();
        }
    }
}

