/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Map;
import java.util.Set;
import javax.units.Unit;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.Factory;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class AuthorityFactoryAdapter
extends AbstractAuthorityFactory
implements OptionalFactory {
    protected final DatumAuthorityFactory datumFactory;
    protected final CSAuthorityFactory csFactory;
    protected final CRSAuthorityFactory crsFactory;
    protected final CoordinateOperationAuthorityFactory operationFactory;

    protected AuthorityFactoryAdapter(AuthorityFactory factory) {
        this(factory instanceof CRSAuthorityFactory ? (CRSAuthorityFactory)factory : null, factory instanceof CSAuthorityFactory ? (CSAuthorityFactory)factory : null, factory instanceof DatumAuthorityFactory ? (DatumAuthorityFactory)factory : null, factory instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)factory : null);
    }

    protected AuthorityFactoryAdapter(CRSAuthorityFactory crsFactory, CSAuthorityFactory csFactory, DatumAuthorityFactory datumFactory, CoordinateOperationAuthorityFactory opFactory) {
        super(Math.max(AuthorityFactoryAdapter.getPriority(datumFactory), Math.max(AuthorityFactoryAdapter.getPriority(csFactory), Math.max(AuthorityFactoryAdapter.getPriority(crsFactory), AuthorityFactoryAdapter.getPriority(opFactory)))));
        if (this instanceof CRSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("crsFactory", crsFactory);
        }
        if (this instanceof CSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("csFactory", csFactory);
        }
        if (this instanceof DatumAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("datumFactory", datumFactory);
        }
        if (this instanceof CoordinateOperationAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("opFactory", opFactory);
        }
        this.datumFactory = datumFactory;
        this.store(Hints.DATUM_AUTHORITY_FACTORY, this.datumFactory);
        this.csFactory = csFactory;
        this.store(Hints.CS_AUTHORITY_FACTORY, this.csFactory);
        this.crsFactory = crsFactory;
        this.store(Hints.CRS_AUTHORITY_FACTORY, this.crsFactory);
        this.operationFactory = opFactory;
        this.store(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this.operationFactory);
    }

    private static int getPriority(AuthorityFactory factory) {
        return factory instanceof AbstractFactory ? ((AbstractFactory)((Object)factory)).getPriority() : 50;
    }

    private void store(Hints.Key key, AuthorityFactory factory) {
        if (factory != null && this.hints.put(key, factory) != null) {
            throw new AssertionError(key);
        }
    }

    final Hints hints() {
        Hints extended = new Hints(this.hints);
        AuthorityFactoryAdapter.addAll(this.operationFactory, extended);
        AuthorityFactoryAdapter.addAll(this.datumFactory, extended);
        AuthorityFactoryAdapter.addAll(this.csFactory, extended);
        AuthorityFactoryAdapter.addAll(this.crsFactory, extended);
        extended.putAll((Map<?, ?>)this.hints);
        return extended;
    }

    private static void addAll(AuthorityFactory factory, Hints hints) {
        if (factory instanceof Factory) {
            hints.putAll((Map<?, ?>)((Factory)((Object)factory)).getImplementationHints());
        }
    }

    public boolean isAvailable() {
        return AuthorityFactoryAdapter.isAvailable(this.crsFactory) && AuthorityFactoryAdapter.isAvailable(this.csFactory) && AuthorityFactoryAdapter.isAvailable(this.datumFactory) && AuthorityFactoryAdapter.isAvailable(this.operationFactory);
    }

    private static boolean isAvailable(AuthorityFactory factory) {
        return !(factory instanceof OptionalFactory) || ((OptionalFactory)((Object)factory)).isAvailable();
    }

    Unit replace(Unit units) throws FactoryException {
        return units;
    }

    CoordinateSystemAxis replace(CoordinateSystemAxis axis) throws FactoryException {
        return axis;
    }

    CoordinateSystem replace(CoordinateSystem cs) throws FactoryException {
        return cs;
    }

    Datum replace(Datum datum) throws FactoryException {
        return datum;
    }

    CoordinateReferenceSystem replace(CoordinateReferenceSystem crs) throws FactoryException {
        return crs;
    }

    CoordinateOperation replace(CoordinateOperation operation) throws FactoryException {
        return operation;
    }

    private AuthorityFactory getAuthorityFactory() {
        if (this.crsFactory != null) {
            return this.crsFactory;
        }
        if (this.csFactory != null) {
            return this.csFactory;
        }
        if (this.datumFactory != null) {
            return this.datumFactory;
        }
        if (this.operationFactory != null) {
            return this.operationFactory;
        }
        return null;
    }

    private AbstractAuthorityFactory getFactory(String caller) throws FactoryException {
        if (this.crsFactory instanceof AbstractAuthorityFactory) {
            return (AbstractAuthorityFactory)((Object)this.crsFactory);
        }
        if (this.csFactory instanceof AbstractAuthorityFactory) {
            return (AbstractAuthorityFactory)((Object)this.csFactory);
        }
        if (this.datumFactory instanceof AbstractAuthorityFactory) {
            return (AbstractAuthorityFactory)((Object)this.datumFactory);
        }
        if (this.operationFactory instanceof AbstractAuthorityFactory) {
            return (AbstractAuthorityFactory)((Object)this.operationFactory);
        }
        if (caller == null) {
            return null;
        }
        throw new FactoryException(Errors.format(166, caller));
    }

    public String getBackingStoreDescription() throws FactoryException {
        AbstractAuthorityFactory factory = this.getFactory(null);
        return factory != null ? factory.getBackingStoreDescription() : null;
    }

    public Citation getVendor() {
        return this.getAuthorityFactory().getVendor();
    }

    public Citation getAuthority() {
        return this.getAuthorityFactory().getAuthority();
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        return this.getAuthorityFactory().getAuthorityCodes(type);
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.getAuthorityFactory().getDescriptionText(code);
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        IdentifiedObject object = this.getAuthorityFactory().createObject(code);
        if (object instanceof Datum) {
            object = this.replace((Datum)object);
        } else if (object instanceof CoordinateSystem) {
            object = this.replace((CoordinateSystem)object);
        } else if (object instanceof CoordinateReferenceSystem) {
            object = this.replace((CoordinateReferenceSystem)object);
        }
        return object;
    }

    public Datum createDatum(String code) throws FactoryException {
        return this.replace(this.datumFactory.createDatum(code));
    }

    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        return (EngineeringDatum)this.replace(this.datumFactory.createEngineeringDatum(code));
    }

    public ImageDatum createImageDatum(String code) throws FactoryException {
        return (ImageDatum)this.replace(this.datumFactory.createImageDatum(code));
    }

    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        return (VerticalDatum)this.replace(this.datumFactory.createVerticalDatum(code));
    }

    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        return (TemporalDatum)this.replace(this.datumFactory.createTemporalDatum(code));
    }

    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        return (GeodeticDatum)this.replace(this.datumFactory.createGeodeticDatum(code));
    }

    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        return this.datumFactory.createEllipsoid(code);
    }

    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        return this.datumFactory.createPrimeMeridian(code);
    }

    public Extent createExtent(String code) throws FactoryException {
        return this.getFactory("createExtent").createExtent(code);
    }

    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        return this.replace(this.csFactory.createCoordinateSystem(code));
    }

    public CartesianCS createCartesianCS(String code) throws FactoryException {
        return (CartesianCS)this.replace(this.csFactory.createCartesianCS(code));
    }

    public PolarCS createPolarCS(String code) throws FactoryException {
        return (PolarCS)this.replace(this.csFactory.createPolarCS(code));
    }

    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        return (CylindricalCS)this.replace(this.csFactory.createCylindricalCS(code));
    }

    public SphericalCS createSphericalCS(String code) throws FactoryException {
        return (SphericalCS)this.replace(this.csFactory.createSphericalCS(code));
    }

    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        return (EllipsoidalCS)this.replace(this.csFactory.createEllipsoidalCS(code));
    }

    public VerticalCS createVerticalCS(String code) throws FactoryException {
        return (VerticalCS)this.replace(this.csFactory.createVerticalCS(code));
    }

    public TimeCS createTimeCS(String code) throws FactoryException {
        return (TimeCS)this.replace(this.csFactory.createTimeCS(code));
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        return this.replace(this.csFactory.createCoordinateSystemAxis(code));
    }

    public Unit createUnit(String code) throws FactoryException {
        return this.replace(this.csFactory.createUnit(code));
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.replace(this.crsFactory.createCoordinateReferenceSystem(code));
    }

    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        return (CompoundCRS)this.replace(this.crsFactory.createCompoundCRS(code));
    }

    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        return (DerivedCRS)this.replace(this.crsFactory.createDerivedCRS(code));
    }

    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        return (EngineeringCRS)this.replace(this.crsFactory.createEngineeringCRS(code));
    }

    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        return (GeographicCRS)this.replace(this.crsFactory.createGeographicCRS(code));
    }

    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        return (GeocentricCRS)this.replace(this.crsFactory.createGeocentricCRS(code));
    }

    public ImageCRS createImageCRS(String code) throws FactoryException {
        return (ImageCRS)this.replace(this.crsFactory.createImageCRS(code));
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return (ProjectedCRS)this.replace(this.crsFactory.createProjectedCRS(code));
    }

    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        return (TemporalCRS)this.replace(this.crsFactory.createTemporalCRS(code));
    }

    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        return (VerticalCRS)this.replace(this.crsFactory.createVerticalCRS(code));
    }

    public ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        return this.getFactory("createParameterDescriptor").createParameterDescriptor(code);
    }

    public OperationMethod createOperationMethod(String code) throws FactoryException {
        return this.getFactory("createOperationMethod").createOperationMethod(code);
    }

    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        return this.replace(this.operationFactory.createCoordinateOperation(code));
    }

    public Set createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        return this.operationFactory.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
    }
}

