/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso;

import java.util.Collection;
import java.util.Locale;
import org.geotools.metadata.iso.content.ContentInformationImpl;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.content.FeatureCatalogueDescription;
import org.opengis.util.GenericName;

public class FeatureCatalogueDescriptionImpl
extends ContentInformationImpl
implements FeatureCatalogueDescription {
    private static final long serialVersionUID = -2566307080447896276L;
    private boolean compliant;
    private Collection language;
    private boolean includeWithDataset;
    private Collection featureTypes;
    private Collection featureCatalogueCitations;

    public boolean isCompliant() {
        return this.compliant;
    }

    public synchronized void setCompliant(boolean newValue) {
        this.checkWritePermission();
        this.compliant = newValue;
    }

    public synchronized Collection getLanguages() {
        this.language = this.nonNullCollection(this.language, Locale.class);
        return this.language;
    }

    public synchronized void setLanguages(Collection newValues) {
        this.language = this.copyCollection(newValues, this.language, Locale.class);
    }

    public boolean isIncludedWithDataset() {
        return this.includeWithDataset;
    }

    public synchronized void setIncludedWithDataset(boolean newValue) {
        this.checkWritePermission();
        this.includeWithDataset = newValue;
    }

    public synchronized Collection getFeatureTypes() {
        this.featureTypes = this.nonNullCollection(this.featureTypes, GenericName.class);
        return this.featureTypes;
    }

    public synchronized void setFeatureTypes(Collection newValues) {
        this.featureTypes = this.copyCollection(newValues, this.featureTypes, GenericName.class);
    }

    public synchronized Collection getFeatureCatalogueCitations() {
        this.featureCatalogueCitations = this.nonNullCollection(this.featureCatalogueCitations, Citation.class);
        return this.featureCatalogueCitations;
    }

    public synchronized void setFeatureCatalogueCitations(Collection newValues) {
        this.featureCatalogueCitations = this.copyCollection(newValues, this.featureCatalogueCitations, Citation.class);
    }

    protected void freeze() {
        super.freeze();
        this.language = (Collection)FeatureCatalogueDescriptionImpl.unmodifiable(this.language);
        this.featureTypes = (Collection)FeatureCatalogueDescriptionImpl.unmodifiable(this.featureTypes);
        this.featureCatalogueCitations = (Collection)FeatureCatalogueDescriptionImpl.unmodifiable(this.featureCatalogueCitations);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(this)) {
            FeatureCatalogueDescriptionImpl that = (FeatureCatalogueDescriptionImpl)object;
            return this.compliant == that.compliant && this.includeWithDataset == that.includeWithDataset && Utilities.equals(this.featureTypes, that.featureTypes) && Utilities.equals(this.featureCatalogueCitations, that.featureCatalogueCitations) && Utilities.equals(this.language, that.language);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = -1521134292;
        if (this.featureCatalogueCitations != null) {
            code ^= ((Object)this.featureCatalogueCitations).hashCode();
        }
        if (this.language != null) {
            code ^= ((Object)this.language).hashCode();
        }
        return code;
    }
}

