/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.factory.RecursiveSearchException;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;

public class FactoryRegistry
extends ServiceRegistry {
    static final ServiceRegistry.Filter FILTER = new DefaultFilter();
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.factory");
    private final Set scanningCategories = new HashSet();
    static /* synthetic */ Class class$org$geotools$factory$Factory;

    public FactoryRegistry(Collection categories) {
        super(categories.iterator());
    }

    public Iterator getServiceProviders(Class category) {
        return this.getServiceProviders(category, null, null);
    }

    public Iterator getServiceProviders(final Class category, final ServiceRegistry.Filter filter, final Hints hints) {
        if (!this.scanningCategories.isEmpty() && this.scanningCategories.contains(category)) {
            throw new RecursiveSearchException(category);
        }
        ServiceRegistry.Filter hintsFilter = filter == null && (hints == null || hints.isEmpty()) ? FILTER : new DefaultFilter(){

            public boolean filter(Object provider) {
                return super.filter(provider) && FactoryRegistry.this.isAcceptable(provider, category, hints, filter);
            }
        };
        Iterator iterator = this.getServiceProviders(category, hintsFilter, true);
        if (!iterator.hasNext()) {
            Iterator it = this.getClassLoaders().iterator();
            while (it.hasNext()) {
                this.safeScanForPlugins((ClassLoader)it.next(), category);
            }
            iterator = this.getServiceProviders(category, hintsFilter, true);
        }
        return iterator;
    }

    public Object getServiceProvider(Class category, ServiceRegistry.Filter filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        Object candidate;
        Class implementation = null;
        if (key != null) {
            if (!category.isAssignableFrom(key.getValueClass())) {
                throw new IllegalArgumentException(Errors.format(190, key));
            }
            if (hints != null && !hints.isEmpty()) {
                Object hint = hints.get(key);
                if (category.isInstance(hint)) {
                    return hint;
                }
                if (hint instanceof Class[]) {
                    Class[] types = (Class[])hint;
                    int length = types.length;
                    for (int i = 0; i < length - 1; ++i) {
                        Object candidate2 = this.getServiceProvider(category, types[i], filter, hints);
                        if (candidate2 == null) continue;
                        return candidate2;
                    }
                    if (length != 0) {
                        implementation = types[length - 1];
                    }
                } else {
                    implementation = (Class)hint;
                }
            }
        }
        if ((candidate = this.getServiceProvider(category, implementation, filter, hints)) != null) {
            return candidate;
        }
        throw new FactoryNotFoundException(Errors.format(189, Utilities.getShortName(implementation != null ? implementation : category)));
    }

    private Object getServiceProvider(Class category, Class implementation, ServiceRegistry.Filter filter, Hints hints) {
        Iterator it = this.getServiceProviders(category);
        while (it.hasNext()) {
            Object candidate = it.next();
            if (implementation != null && !implementation.isInstance(candidate) || !this.isAcceptable(candidate, category, hints, filter)) continue;
            return candidate;
        }
        List cached = this.getCachedProviders(category);
        if (cached != null) {
            Iterator it2 = cached.iterator();
            while (it2.hasNext()) {
                Object candidate = ((Reference)it2.next()).get();
                if (candidate == null) {
                    it2.remove();
                    continue;
                }
                if (implementation != null && !implementation.isInstance(candidate) || !this.isAcceptable(candidate, category, hints, filter)) continue;
                return candidate;
            }
        }
        return null;
    }

    List getCachedProviders(Class category) {
        return null;
    }

    final boolean isAcceptable(Object candidate, Class category, Hints hints, ServiceRegistry.Filter filter) {
        if (filter != null && !filter.filter(candidate)) {
            return false;
        }
        if (hints != null && candidate instanceof Factory && !this.isAcceptable((Factory)candidate, category, hints, (Set)null)) {
            return false;
        }
        return this.isAcceptable(candidate, category, hints);
    }

    private boolean isAcceptable(Factory factory, Class category, Hints hints, Set alreadyDone) {
        Hints remaining = null;
        Map implementationHints = factory.getImplementationHints();
        Iterator it = implementationHints.entrySet().iterator();
        while (it.hasNext()) {
            Class type;
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object expected = hints.get(key);
            if (expected != null) {
                if (expected instanceof Class) {
                    if (!((Class)expected).isInstance(value)) {
                        return false;
                    }
                } else if (expected instanceof Class[]) {
                    Class[] types = (Class[])expected;
                    int i = 0;
                    do {
                        if (i < types.length) continue;
                        return false;
                    } while (!types[i++].isInstance(value));
                } else if (!expected.equals(value)) {
                    return false;
                }
            }
            if (!this.isAcceptable(value, category, hints)) {
                return false;
            }
            if (!(value instanceof Factory)) continue;
            Factory dependency = (Factory)value;
            if (alreadyDone == null) {
                alreadyDone = new HashSet<Factory>();
            }
            if (alreadyDone.contains(dependency)) continue;
            alreadyDone.add(factory);
            if (remaining == null) {
                remaining = new Hints((Map)hints);
                remaining.keySet().removeAll(implementationHints.keySet());
            }
            if (key instanceof Hints.Key) {
                type = ((Hints.Key)key).getValueClass();
            } else {
                Class clazz = type = class$org$geotools$factory$Factory == null ? FactoryRegistry.class$("org.geotools.factory.Factory") : class$org$geotools$factory$Factory;
            }
            if (this.isAcceptable(dependency, type, remaining, alreadyDone)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAcceptable(Object provider, Class category, Hints hints) {
        return true;
    }

    public final Set getClassLoaders() {
        HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
        for (int i = 0; i < 4; ++i) {
            ClassLoader loader;
            try {
                switch (i) {
                    case 0: {
                        loader = this.getClass().getClassLoader();
                        break;
                    }
                    case 1: {
                        loader = (class$org$geotools$factory$FactoryRegistry == null ? FactoryRegistry.class$("org.geotools.factory.FactoryRegistry") : class$org$geotools$factory$FactoryRegistry).getClassLoader();
                        break;
                    }
                    case 2: {
                        loader = Thread.currentThread().getContextClassLoader();
                        break;
                    }
                    case 3: {
                        loader = ClassLoader.getSystemClassLoader();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
            }
            catch (SecurityException exception) {
                continue;
            }
            loaders.add(loader);
        }
        loaders.remove(null);
        ClassLoader[] asArray = loaders.toArray(new ClassLoader[loaders.size()]);
        int length = asArray.length;
        for (int i = 0; i < length; ++i) {
            ClassLoader loader = asArray[i];
            try {
                while ((loader = loader.getParent()) != null) {
                    loaders.remove(loader);
                }
                continue;
            }
            catch (SecurityException exception) {
                // empty catch block
            }
        }
        if (loaders.isEmpty()) {
            LOGGER.warning("No class loaders available");
        }
        return loaders;
    }

    public void scanForPlugins() {
        Set loaders = this.getClassLoaders();
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            Iterator it = loaders.iterator();
            while (it.hasNext()) {
                ClassLoader loader = (ClassLoader)it.next();
                this.safeScanForPlugins(loader, category);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void safeScanForPlugins(ClassLoader loader, Class category) {
        if (!this.scanningCategories.add(category)) {
            throw new RecursiveSearchException(category);
        }
        try {
            this.scanForPlugins(loader, category);
            Object var4_3 = null;
            if (this.scanningCategories.remove(category)) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.scanningCategories.remove(category)) throw throwable;
            throw new AssertionError(category);
        }
        throw new AssertionError(category);
    }

    private void scanForPlugins(ClassLoader loader, Class category) {
        boolean newServices;
        StringBuffer message;
        block18: {
            Class<?> factoryClass;
            Iterator factories = ServiceRegistry.lookupProviders(category, loader);
            String lineSeparator = System.getProperty("line.separator", "\n");
            message = new StringBuffer();
            message.append(Logging.getResources(null).getString(32, Utilities.getShortName(category)));
            newServices = false;
            while (factories.hasNext()) {
                Object factory;
                try {
                    factory = factories.next();
                }
                catch (OutOfMemoryError error) {
                    throw error;
                }
                catch (NoClassDefFoundError error) {
                    FactoryRegistry.loadingFailure(category, error, false);
                    continue;
                }
                catch (Error error) {
                    if (!Utilities.getShortClassName(error).equals("ServiceConfigurationError")) {
                        throw error;
                    }
                    FactoryRegistry.loadingFailure(category, error, true);
                    continue;
                }
                factoryClass = factory.getClass();
                Object replacement = this.getServiceProviderByClass(factoryClass);
                if (replacement != null) {
                    factory = replacement;
                }
                if (!this.registerServiceProvider(factory, category)) continue;
                message.append(lineSeparator);
                message.append("  ");
                message.append(factoryClass.getName());
                newServices = true;
            }
            try {
                String classname = System.getProperty(category.getName());
                if (classname == null) break block18;
                try {
                    factoryClass = loader.loadClass(classname);
                    Object factory = this.getServiceProviderByClass(factoryClass);
                    if (factory == null) {
                        try {
                            factory = factoryClass.newInstance();
                            if (this.registerServiceProvider(factory, category)) {
                                message.append(lineSeparator);
                                message.append("  ");
                                message.append(factoryClass.getName());
                                newServices = true;
                            }
                        }
                        catch (IllegalAccessException exception) {
                            throw new FactoryRegistryException(Errors.format(184, classname), exception);
                        }
                        catch (InstantiationException exception) {
                            throw new FactoryRegistryException(Errors.format(184, classname), exception);
                        }
                    }
                    Iterator it = this.getServiceProviders(category, false);
                    while (it.hasNext()) {
                        Object other = it.next();
                        if (other == factory) continue;
                        this.setOrdering(category, factory, other);
                    }
                }
                catch (ClassNotFoundException exception) {
                }
            }
            catch (SecurityException exception) {
                // empty catch block
            }
        }
        if (newServices) {
            LogRecord record = new LogRecord(Level.CONFIG, message.toString());
            record.setSourceClassName(FactoryRegistry.class.getName());
            record.setSourceMethodName("scanForPlugins");
            LOGGER.log(record);
        }
    }

    private static void loadingFailure(Class category, Throwable error, boolean showStackTrace) {
        String name = Utilities.getShortName(category);
        StringBuffer cause = new StringBuffer(Utilities.getShortClassName(error));
        String message = error.getLocalizedMessage();
        if (message != null) {
            cause.append(": ");
            cause.append(message);
        }
        LogRecord record = Logging.format(Level.WARNING, 30, name, cause.toString());
        if (showStackTrace) {
            record.setThrown(error);
        }
        record.setSourceClassName("FactoryRegistry");
        record.setSourceMethodName("scanForPlugins");
        LOGGER.log(record);
    }

    public boolean setOrdering(Class category, Comparator comparator) {
        boolean set = false;
        ArrayList previous = new ArrayList();
        Iterator it = this.getServiceProviders(category, false);
        while (it.hasNext()) {
            Object f1 = it.next();
            int i = previous.size();
            while (--i >= 0) {
                int c;
                Object f2 = previous.get(i);
                try {
                    c = comparator.compare(f1, f2);
                }
                catch (ClassCastException exception) {
                    continue;
                }
                if (c > 0) {
                    set |= this.setOrdering(category, f1, f2);
                    continue;
                }
                if (c >= 0) continue;
                set |= this.setOrdering(category, f2, f1);
            }
            previous.add(f1);
        }
        return set;
    }

    public boolean setOrdering(Class base, boolean set, ServiceRegistry.Filter service1, ServiceRegistry.Filter service2) {
        boolean done = false;
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            if (!base.isAssignableFrom(category)) continue;
            Object impl1 = null;
            Object impl2 = null;
            Iterator<?> it = this.getServiceProviders(category, false);
            while (it.hasNext()) {
                Object factory = it.next();
                if (service1.filter(factory)) {
                    impl1 = factory;
                }
                if (service2.filter(factory)) {
                    impl2 = factory;
                }
                if (impl1 == null || impl2 == null || impl1 == impl2) continue;
                if (set) {
                    done |= this.setOrdering(category, impl1, impl2);
                    continue;
                }
                done |= this.unsetOrdering(category, impl1, impl2);
            }
        }
        return done;
    }

    private static class DefaultFilter
    implements ServiceRegistry.Filter {
        private DefaultFilter() {
        }

        public boolean filter(Object provider) {
            return !(provider instanceof OptionalFactory) || ((OptionalFactory)provider).isAvailable();
        }
    }
}

