/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.data;

import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import org.unijena.jams.JAMS;
import org.unijena.jams.data.JAMSData;

public class JAMSCalendar
extends GregorianCalendar
implements JAMSData {
    public JAMSCalendar() {
        this.setTimeInMillis(0L);
        SimpleTimeZone stz = new SimpleTimeZone(3600000, "MEZsimple");
        this.setTimeZone(stz);
    }

    public JAMSCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        super(year, month, dayOfMonth, hourOfDay, minute, second);
        SimpleTimeZone stz = new SimpleTimeZone(3600000, "MEZsimple");
        this.setTimeZone(stz);
    }

    @Override
    public JAMSCalendar clone() {
        return new JAMSCalendar(this.get(1), this.get(2), this.get(5), this.get(11), this.get(12), this.get(13));
    }

    @Override
    public String toString() {
        return String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM", this);
    }

    public String toString(String formatString) {
        return String.format(formatString, this);
    }

    public GregorianCalendar getValue() {
        return this.clone();
    }

    public int compareTo(JAMSCalendar cal, int accuracy) {
        JAMSCalendar clone = this.clone();
        clone.set(14, cal.get(14));
        if (accuracy < 13) {
            clone.set(13, cal.get(13));
        }
        if (accuracy < 12) {
            clone.set(12, cal.get(12));
        }
        if (accuracy < 11) {
            clone.set(11, cal.get(11));
        }
        if (accuracy < 6) {
            clone.set(6, cal.get(6));
        }
        if (accuracy < 2) {
            clone.set(2, cal.get(2));
        }
        return clone.compareTo(cal);
    }

    public void setValue(GregorianCalendar cal) {
        this.setTimeInMillis(cal.getTimeInMillis());
    }

    @Override
    public void setValue(String value) {
        String year = "1900";
        String month = "1";
        String day = "1";
        String hour = "0";
        String minute = "0";
        String second = "0";
        String millisecond = "0";
        StringTokenizer st = new StringTokenizer(value, " :-/");
        year = st.nextToken();
        if (st.hasMoreTokens()) {
            month = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            day = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            hour = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            minute = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            second = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            millisecond = st.nextToken().trim();
        }
        try {
            this.set(1, Integer.parseInt(year));
            this.set(2, Integer.parseInt(month) - 1);
            this.set(5, Integer.parseInt(day));
            this.set(11, Integer.parseInt(hour));
            this.set(12, Integer.parseInt(minute));
            this.set(13, Integer.parseInt(second));
            this.set(14, Integer.parseInt(millisecond));
        }
        catch (NumberFormatException nfe) {
            JAMS.handle(nfe);
        }
    }
}

