/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams;

import java.util.ArrayList;
import org.unijena.jams.ModelConfig;
import org.unijena.jams.runtime.JAMSRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelPreprocessor {
    Document modelDoc;
    ModelConfig config;
    JAMSRuntime rt;

    public ModelPreprocessor(Document modelDoc, ModelConfig config, JAMSRuntime rt) {
        this.modelDoc = modelDoc;
        this.config = config;
        this.rt = rt;
    }

    public void process() {
        this.processNode(this.modelDoc.getDocumentElement());
    }

    private void processNode(Element rootElement) {
        String compName;
        ArrayList<ModelConfig.Setting> list;
        String type = rootElement.getNodeName();
        if ((type == "contextcomponent" || type == "component" || type == "model") && (list = this.config.getSettings(compName = rootElement.getAttribute("name"))) != null) {
            int index;
            NodeList attributeChilds = rootElement.getElementsByTagName("attribute");
            NodeList varChilds = rootElement.getElementsByTagName("var");
            for (ModelConfig.Setting s : list) {
                if (!s.getAttribute().equals("%enable%") || !s.getValue().equals("0")) continue;
                rootElement.getParentNode().removeChild(rootElement);
                this.rt.println("Disabling component " + compName, 2);
                return;
            }
            for (index = 0; index < attributeChilds.getLength(); ++index) {
                Element attribute = (Element)attributeChilds.item(index);
                for (ModelConfig.Setting s : list) {
                    if (!s.getAttribute().equals(attribute.getAttribute("name"))) continue;
                    attribute.setAttribute("value", s.getValue());
                    this.rt.println("Setting " + attribute.getAttribute("name") + " to " + s.getValue(), 2);
                }
            }
            for (index = 0; index < varChilds.getLength(); ++index) {
                Element var = (Element)varChilds.item(index);
                for (ModelConfig.Setting s : list) {
                    if (!s.getAttribute().equals(var.getAttribute("name"))) continue;
                    var.setAttribute("value", s.getValue());
                    this.rt.println("Setting " + var.getAttribute("name") + " to " + s.getValue(), 2);
                }
            }
        }
        if (type == "contextcomponent" || type == "model") {
            NodeList childs = rootElement.getChildNodes();
            for (int index = 0; index < childs.getLength(); ++index) {
                Node node = childs.item(index);
                if (node.getNodeName() != "contextcomponent" && node.getNodeName() != "component") continue;
                this.processNode((Element)node);
            }
        }
    }
}

