/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateSystemFeatureResults
extends DataFeatureCollection {
    FeatureResults results;
    FeatureType schema;
    private FeatureType startingType;

    public ForceCoordinateSystemFeatureResults(FeatureResults results, CoordinateReferenceSystem forcedCS) throws IOException, SchemaException {
        this(results, forcedCS, false);
    }

    public ForceCoordinateSystemFeatureResults(FeatureResults results, CoordinateReferenceSystem forcedCS, boolean forceOnlyMissing) throws IOException, SchemaException {
        if (forcedCS == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        this.startingType = results.getSchema();
        CoordinateReferenceSystem originalCs = this.startingType.getDefaultGeometry().getCoordinateSystem();
        if (results instanceof ReprojectFeatureResults) {
            originalCs = ((ReprojectFeatureResults)results).getOrigin().getSchema().getDefaultGeometry().getCoordinateSystem();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            originalCs = ((ForceCoordinateSystemFeatureResults)results).getOrigin().getSchema().getDefaultGeometry().getCoordinateSystem();
        }
        if (!forcedCS.equals(originalCs)) {
            this.schema = FeatureTypes.transform(this.startingType, forcedCS, forceOnlyMissing);
        }
        this.results = results;
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            ForceCoordinateSystemFeatureResults forced = (ForceCoordinateSystemFeatureResults)results;
            this.results = forced.getOrigin();
        }
    }

    public FeatureType getSchema() {
        if (this.schema == null) {
            return this.startingType;
        }
        return this.schema;
    }

    public FeatureReader reader() throws IOException {
        return new ForceCoordinateSystemFeatureReader(this.results.reader(), this.schema);
    }

    public Envelope getBounds() {
        return this.results.getBounds();
    }

    public int getCount() throws IOException {
        return this.results.getCount();
    }

    public FeatureCollection collection() throws IOException {
        FeatureCollection collection = FeatureCollections.newCollection();
        try {
            FeatureReader reader = this.reader();
            while (reader.hasNext()) {
                collection.add((Object)reader.next());
            }
        }
        catch (NoSuchElementException e) {
            throw new DataSourceException("This should not happen", (Throwable)e);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("This should not happen", (Throwable)e);
        }
        return collection;
    }

    public FeatureResults getOrigin() {
        return this.results;
    }
}

