/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.coverage.grid;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.IHSColorSpace;
import javax.media.jai.PlanarImage;
import javax.units.Unit;
import javax.units.UnitFormat;
import org.geotools.coverage.Category;
import org.geotools.coverage.FactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.BufferedCoordinateOperationFactory;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.CRSUtilities;
import org.geotools.util.NumberRange;
import org.opengis.coverage.MetadataNameNotFoundException;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public abstract class AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.coverage.grid");
    protected static final GridCoverageFactory coverageFactory = FactoryFinder.getGridCoverageFactory(null);
    protected static final double EPS = 1.0E-6;
    protected static final CoordinateOperationFactory operationFactory = new BufferedCoordinateOperationFactory(new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
    protected static final Color[] demColors = new Color[]{new Color(5, 90, 5), new Color(150, 200, 150), new Color(190, 150, 20), new Color(100, 100, 50), new Color(200, 210, 220), Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE};
    protected volatile int numOverviews = 0;
    protected MathTransform raster2Model = null;
    protected CoordinateReferenceSystem crs = null;
    protected GeneralEnvelope originalEnvelope = null;
    protected String coverageName = "geotools_coverage";
    protected Object source = null;
    protected Hints hints = new Hints(new HashMap(5));
    protected double[] highestRes = null;
    protected boolean closeMe;
    protected boolean gzipped;
    protected GeneralGridRange originalGridRange = null;
    protected ImageInputStream inStream = null;
    protected double[][] overViewResolutions = null;

    protected Integer setReadParams(ImageReadParam readP, GeneralEnvelope requestedEnvelope, Rectangle requestedDim) throws IOException, TransformException {
        readP.setSourceSubsampling(1, 1, 0, 0);
        Integer imageChoice = new Integer(0);
        if (this.raster2Model != null && !this.isScaleTranslate(this.raster2Model)) {
            return imageChoice;
        }
        Object o = this.hints.get((Object)Hints.IGNORE_COVERAGE_OVERVIEW);
        if (o != null && ((Boolean)o).booleanValue()) {
            return imageChoice;
        }
        boolean decimate = this.numOverviews <= 0;
        double[] requestedRes = this.getResolution(requestedEnvelope, requestedDim, this.crs);
        if (requestedRes == null) {
            return imageChoice;
        }
        if (!decimate) {
            int i;
            if (this.highestRes[0] - requestedRes[0] > 1.0E-6 && this.highestRes[1] - requestedRes[1] > 1.0E-6) {
                return imageChoice;
            }
            int axis = 0;
            if (requestedRes[0] - requestedRes[1] > 1.0E-6) {
                axis = 1;
            }
            for (i = 0; i < this.numOverviews; ++i) {
                double actRes;
                double d = actRes = axis == 0 ? this.overViewResolutions[i][0] : this.overViewResolutions[i][1];
                if (!(actRes - requestedRes[axis] > 1.0E-6)) continue;
                --i;
                break;
            }
            imageChoice = i == this.numOverviews ? new Integer(this.numOverviews) : new Integer(i + 1);
        }
        this.decimationOnReadingControl(imageChoice, readP, requestedRes);
        return imageChoice;
    }

    protected final boolean isScaleTranslate(MathTransform transform) {
        if (!(transform instanceof AffineTransform)) {
            return false;
        }
        AffineTransform at = (AffineTransform)transform;
        return at.getShearX() < 1.0E-6 && at.getShearY() < 1.0E-6;
    }

    protected final void decimationOnReadingControl(Integer imageChoice, ImageReadParam readP, double[] requestedRes) {
        int h;
        int w;
        double[] selectedRes = new double[2];
        int choice = imageChoice;
        if (choice == 0) {
            w = this.originalGridRange.getLength(0);
            h = this.originalGridRange.getLength(1);
            selectedRes[0] = this.highestRes[0];
            selectedRes[1] = this.highestRes[1];
        } else {
            selectedRes[0] = this.overViewResolutions[choice - 1][0];
            selectedRes[1] = this.overViewResolutions[choice - 1][1];
            w = (int)Math.round(this.originalEnvelope.getLength(0) / selectedRes[0]);
            h = (int)Math.round(this.originalEnvelope.getLength(1) / selectedRes[1]);
        }
        if (requestedRes == null) {
            readP.setSourceSubsampling(1, 1, 0, 0);
        } else {
            int subSamplingFactorX = (int)Math.floor(requestedRes[0] / selectedRes[0]);
            int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            while (w / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
                --subSamplingFactorX;
            }
            subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            int subSamplingFactorY = (int)Math.floor(requestedRes[1] / selectedRes[1]);
            int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            while (h / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
                --subSamplingFactorY;
            }
            subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            readP.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
        }
    }

    protected final GridCoverage createImageCoverage(PlanarImage image) throws IOException {
        return this.createImageCoverage(image, null);
    }

    protected final GridCoverage createImageCoverage(PlanarImage image, MathTransform raster2Model) throws IOException {
        NumberRange geophysicRange = null;
        switch (image.getSampleModel().getTransferType()) {
            case 0: {
                geophysicRange = new NumberRange(0, 255);
                break;
            }
            case 1: {
                geophysicRange = new NumberRange(0, 65535);
                break;
            }
            case 3: {
                geophysicRange = new NumberRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
                break;
            }
            case 2: {
                geophysicRange = new NumberRange(Short.MIN_VALUE, Short.MAX_VALUE);
                break;
            }
            case 5: {
                geophysicRange = new NumberRange(Double.MIN_VALUE, Double.MAX_VALUE);
                break;
            }
            case 4: {
                geophysicRange = new NumberRange(Float.MIN_VALUE, Float.MAX_VALUE);
                return this.createDEMCoverage(image);
            }
            default: {
                throw new DataSourceException("createImageCoverage:Data buffer type not supported by this world image reader! Use byte, ushort or int");
            }
        }
        Category values = new Category((CharSequence)"values", new Color[]{Color.BLACK}, geophysicRange, (MathTransform1D)LinearTransform1D.IDENTITY);
        int numBands = image.getSampleModel().getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        ColorModel cm = image.getColorModel();
        String[] names = new String[numBands];
        if (cm instanceof IndexColorModel) {
            names[0] = "index band";
        } else {
            ColorSpace cs = cm.getColorSpace();
            if (cs instanceof IHSColorSpace) {
                names[0] = "Intensity band";
                names[1] = "Hue band";
                names[2] = "Saturation band";
            } else {
                int type = cs.getType();
                switch (type) {
                    case 6: 
                    case 1003: {
                        names[0] = "grayscale band";
                        break;
                    }
                    case 5: 
                    case 1000: 
                    case 1004: {
                        names[0] = "Red band";
                        names[1] = "Green band";
                        names[2] = "Blue band";
                        break;
                    }
                    case 11: {
                        names[0] = "Cyan band";
                        names[1] = "Magenta band";
                        names[2] = "Yellow band";
                        break;
                    }
                    case 9: {
                        names[0] = "Cyan band";
                        names[1] = "Magenta band";
                        names[2] = "Yellow band";
                        names[3] = "K band";
                    }
                }
            }
        }
        for (int i = 0; i < numBands; ++i) {
            bands[i] = new GridSampleDimension((CharSequence)names[i], new Category[]{values}, null).geophysics(true);
        }
        if (raster2Model != null) {
            return coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, this.crs, raster2Model, bands, null, null);
        }
        return coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, (Envelope)new GeneralEnvelope((Envelope)this.originalEnvelope), bands, null, null);
    }

    private GridCoverage createDEMCoverage(PlanarImage coverage) {
        UnitFormat unitFormat = UnitFormat.getStandardInstance();
        Unit uom = null;
        try {
            uom = unitFormat.parseUnit((CharSequence)"m");
        }
        catch (ParseException e) {
            uom = null;
        }
        Category values = new Category((CharSequence)"elevation", demColors, new NumberRange(2, 10), new NumberRange(-1, 8849));
        GridSampleDimension band = new GridSampleDimension((CharSequence)"digital elevation", new Category[]{values}, uom).geophysics(true);
        return coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)coverage, (Envelope)this.originalEnvelope, new GridSampleDimension[]{band}, null, null);
    }

    protected final double[] getResolution(GeneralEnvelope envelope, Rectangle2D dim, CoordinateReferenceSystem crs) throws DataSourceException {
        double[] requestedRes = null;
        try {
            if (dim != null && envelope != null) {
                MathTransform tr;
                CoordinateReferenceSystem crs2D = CRSUtilities.getCRS2D((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem());
                if (crs != null && !CRSUtilities.equalsIgnoreMetadata((Object)crs, (Object)crs2D) && !(tr = operationFactory.createOperation(crs2D, crs).getMathTransform()).isIdentity()) {
                    envelope = CRSUtilities.transform((MathTransform)tr, (Envelope)envelope);
                }
                requestedRes = new double[]{envelope.getLength(0) / dim.getWidth(), envelope.getLength(1) / dim.getHeight()};
            }
            return requestedRes;
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to get the resolution", (Throwable)e);
        }
        catch (FactoryException e) {
            throw new DataSourceException("Unable to get the resolution", (Throwable)e);
        }
    }

    public final CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public final GeneralGridRange getOriginalGridRange() {
        return this.originalGridRange;
    }

    public final GeneralEnvelope getOriginalEnvelope() {
        return this.originalEnvelope;
    }

    public final Object getSource() {
        return this.source;
    }

    public void dispose() {
        block3: {
            if (this.inStream != null) {
                try {
                    this.inStream.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public void skip() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public boolean hasMoreGridCoverages() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public String[] listSubNames() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public String getCurrentSubname() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public String[] getMetadataNames() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public String getMetadataValue(String name) throws MetadataNameNotFoundException {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public int getGridCoverageCount() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }
}

