/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.event.AbstractGTComponent;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.resources.Utilities;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Halo;
import org.geotools.styling.StyleVisitor;
import org.opengis.util.Cloneable;

public class HaloImpl
extends AbstractGTComponent
implements Halo,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private FilterFactory filterFactory;
    private Fill fill = new FillImpl();
    private Expression radius = null;

    public HaloImpl() {
        this(FilterFactoryFinder.createFilterFactory());
    }

    public HaloImpl(FilterFactory factory) {
        this.filterFactory = factory;
        this.init();
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
        this.init();
    }

    private void init() {
        try {
            this.radius = this.filterFactory.createLiteralExpression((Object)new Integer(1));
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultHalo: " + (Object)((Object)ife));
        }
        this.fill.setColor((Expression)this.filterFactory.createLiteralExpression("#FFFFFF"));
    }

    public Fill getFill() {
        return this.fill;
    }

    public void setFill(Fill fill) {
        Fill old = this.fill;
        this.fill = fill;
        this.fireChildChanged("fill", fill, old);
    }

    public Expression getRadius() {
        return this.radius;
    }

    public void setRadius(Expression radius) {
        Expression old = this.radius;
        this.radius = radius;
        this.fireChildChanged("radius", radius, old);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Halo)this);
    }

    public Object clone() {
        try {
            HaloImpl clone = (HaloImpl)super.clone();
            clone.fill = (Fill)((Cloneable)this.fill).clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This will never happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HaloImpl) {
            HaloImpl other = (HaloImpl)obj;
            return Utilities.equals((Object)this.radius, (Object)other.radius) && Utilities.equals((Object)this.fill, (Object)other.fill);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.radius != null) {
            result = result * 37 + this.radius.hashCode();
        }
        if (this.fill != null) {
            result = result * 37 + this.fill.hashCode();
        }
        return result;
    }
}

