/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.event.EventListenerList;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.gui.swing.JMapPane;
import org.geotools.gui.swing.event.HighlightChangeListener;
import org.geotools.gui.swing.event.HighlightChangedEvent;
import org.geotools.map.MapLayer;

public class HighlightManager
extends MouseMotionAdapter {
    EventListenerList listeners = new EventListenerList();
    MapLayer highlightLayer;
    FilterFactory ff = FilterFactoryFinder.createFilterFactory();
    GeometryFactory gf = new GeometryFactory();
    String geomName;
    Filter lastFilter = null;

    public HighlightManager(MapLayer layer) {
        this.setHighlightLayer(layer);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.highlightLayer == null) {
            return;
        }
        Rectangle bounds = e.getComponent().getBounds();
        Envelope mapArea = ((JMapPane)e.getSource()).mapArea;
        double x = e.getX();
        double y = e.getY();
        double width = mapArea.getWidth();
        double height = mapArea.getHeight();
        double mapX = x * width / (double)bounds.width + mapArea.getMinX();
        double mapY = (bounds.getHeight() - y) * height / (double)bounds.height + mapArea.getMinY();
        GeometryFilter f = null;
        Point geometry = this.gf.createPoint(new Coordinate(mapX, mapY));
        try {
            f = this.ff.createGeometryFilter((short)11);
            f.addRightGeometry((Expression)this.ff.createLiteralExpression((Object)geometry));
            f.addLeftGeometry((Expression)this.ff.createAttributeExpression(this.geomName));
            if (f == this.lastFilter) {
                return;
            }
            this.lastFilter = f;
            this.highlightChanged(e.getSource(), (Filter)f);
        }
        catch (IllegalFilterException ex) {
            ex.printStackTrace();
        }
    }

    public void addHighlightChangeListener(HighlightChangeListener l) {
        this.listeners.add(HighlightChangeListener.class, l);
    }

    public void removeHightlightChangeListener(HighlightChangeListener l) {
        this.listeners.remove(HighlightChangeListener.class, l);
    }

    public void highlightChanged(Object source, Filter filter) {
        HighlightChangeListener[] l = (HighlightChangeListener[])this.listeners.getListeners(HighlightChangeListener.class);
        HighlightChangedEvent ev = new HighlightChangedEvent(source, filter);
        for (int i = 0; i < l.length; ++i) {
            l[i].highlightChanged(ev);
        }
    }

    public MapLayer getHighlightLayer() {
        return this.highlightLayer;
    }

    public void setHighlightLayer(MapLayer highlightLayer) {
        this.highlightLayer = highlightLayer;
        if (this.highlightLayer != null) {
            this.geomName = this.highlightLayer.getFeatureSource().getSchema().getDefaultGeometry().getName();
            if (this.geomName == null || this.geomName == "") {
                this.geomName = "the_geom";
            }
        }
    }
}

