/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.geometry.coordinatesequence.CSBuilder;
import org.geotools.geometry.coordinatesequence.CSBuilderFactory;

public class MultiLineHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory = new GeometryFactory();
    CSBuilder builder = CSBuilderFactory.getDefaultBuilder();
    double[] x;
    double[] y;
    double[] z;

    public MultiLineHandler() {
        this.shapeType = ShapeType.ARC;
    }

    public MultiLineHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.ARC && type != ShapeType.ARCM && type != ShapeType.ARCZ) {
            throw new ShapefileException("MultiLineHandler constructor - expected type to be 3,13 or 23");
        }
        this.shapeType = type;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    /*
     * WARNING - void declaration
     */
    public int getLength(Object geometry) {
        void var5_5;
        int length;
        MultiLineString multi = (MultiLineString)geometry;
        int numlines = multi.getNumGeometries();
        int numpoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.ARC) {
            length = 44 + 4 * numlines + numpoints * 16;
        } else if (this.shapeType == ShapeType.ARCM) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints;
        } else if (this.shapeType == ShapeType.ARCZ) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints + 8 + 8 + 8 * numpoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.shapeType);
        }
        return (int)var5_5;
    }

    private Object createNull() {
        return this.geometryFactory.createMultiLineString((LineString[])null);
    }

    public Object readOld(ByteBuffer buffer, ShapeType type) {
        int t;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        int dimensions = this.shapeType == ShapeType.ARCZ ? 3 : 2;
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        LineString[] lines = new LineString[numParts];
        this.prepareCoordinateArrays(numPoints);
        for (t = 0; t < numPoints; ++t) {
            this.x[t] = buffer.getDouble();
            this.y[t] = buffer.getDouble();
        }
        if (dimensions == 3) {
            buffer.position(buffer.position() + 16);
            for (t = 0; t < numPoints; ++t) {
                this.z[t] = buffer.getDouble();
            }
        }
        int offset = 0;
        int start = 0;
        for (int part = 0; part < numParts; ++part) {
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            start = finish;
            if (length == 1) {
                this.builder.start(2, dimensions);
            } else {
                this.builder.start(length, dimensions);
            }
            for (int i = 0; i < length; ++i) {
                this.builder.setOrdinate(this.x[offset], 0, i);
                this.builder.setOrdinate(this.y[offset], 1, i);
                if (dimensions == 3) {
                    this.builder.setOrdinate(this.z[offset], 2, i);
                }
                ++offset;
            }
            if (length == 1) {
                this.builder.setOrdinate(this.x[offset - 1], 0, 1);
                this.builder.setOrdinate(this.y[offset - 1], 1, 1);
                if (dimensions == 3) {
                    this.builder.setOrdinate(this.z[offset - 1], 2, 1);
                }
            }
            lines[part] = this.geometryFactory.createLineString(this.builder.end());
        }
        return this.geometryFactory.createMultiLineString(lines);
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        int i;
        int finish;
        int part;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        int dimensions = this.shapeType == ShapeType.ARCZ ? 3 : 2;
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i2 = 0; i2 < numParts; ++i2) {
            partOffsets[i2] = buffer.getInt();
        }
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        int start = 0;
        int length = 0;
        boolean clonePoint = false;
        for (part = 0; part < numParts; ++part) {
            finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            length = finish - (start = partOffsets[part]);
            if (length == 1) {
                length = 2;
                clonePoint = true;
            } else {
                clonePoint = false;
            }
            this.builder.start(length, dimensions);
            for (i = 0; i < length; ++i) {
                this.builder.setOrdinate(buffer.getDouble(), 0, i);
                this.builder.setOrdinate(buffer.getDouble(), 1, i);
            }
            if (clonePoint) {
                this.builder.setOrdinate(this.builder.getOrdinate(0, 0), 0, 1);
                this.builder.setOrdinate(this.builder.getOrdinate(1, 0), 1, 1);
            }
            lines[part] = this.builder.end();
        }
        if (dimensions == 3) {
            buffer.position(buffer.position() + 16);
            for (part = 0; part < numParts; ++part) {
                finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - (start = partOffsets[part]);
                if (length == 1) {
                    length = 2;
                    clonePoint = true;
                } else {
                    clonePoint = false;
                }
                for (i = 0; i < length; ++i) {
                    this.builder.setOrdinate(lines[part], buffer.getDouble(), 2, i);
                }
            }
        }
        LineString[] lineStrings = new LineString[numParts];
        for (int part2 = 0; part2 < numParts; ++part2) {
            lineStrings[part2] = this.geometryFactory.createLineString(lines[part2]);
        }
        return this.geometryFactory.createMultiLineString(lineStrings);
    }

    private void prepareCoordinateArrays(int numPoints) {
        if (this.x == null || this.x.length < numPoints) {
            this.x = new double[numPoints];
            this.y = new double[numPoints];
            this.z = new double[numPoints];
        }
    }

    public void write(ByteBuffer buffer, Object geometry) {
        int t;
        MultiLineString multi = (MultiLineString)geometry;
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        int numParts = multi.getNumGeometries();
        buffer.putInt(numParts);
        int npoints = multi.getNumPoints();
        buffer.putInt(npoints);
        LineString[] lines = new LineString[numParts];
        int idx = 0;
        for (int i = 0; i < numParts; ++i) {
            lines[i] = (LineString)multi.getGeometryN(i);
            buffer.putInt(idx);
            idx += lines[i].getNumPoints();
        }
        Coordinate[] coords = multi.getCoordinates();
        for (t = 0; t < npoints; ++t) {
            buffer.putDouble(coords[t].x);
            buffer.putDouble(coords[t].y);
        }
        if (this.shapeType == ShapeType.ARCZ) {
            double[] zExtreame = JTSUtilities.zMinMax(coords);
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t2 = 0; t2 < npoints; ++t2) {
                double z = coords[t2].z;
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.shapeType == ShapeType.ARCZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (t = 0; t < npoints; ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }
}

