/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.units.Unit;
import org.geotools.metadata.iso.IdentifierImpl;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.AbstractParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.ClassChanger;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.CodeList;

public class DefaultParameterDescriptor
extends AbstractParameterDescriptor
implements ParameterDescriptor {
    private static final long serialVersionUID = -295668622297737705L;
    private final Class valueClass;
    private final Class primitiveClass;
    private final Set validValues;
    private final Object defaultValue;
    private final Comparable minimum;
    private final Comparable maximum;
    private final Unit unit;

    public DefaultParameterDescriptor(ParameterDescriptor descriptor) {
        super(descriptor);
        this.valueClass = descriptor.getValueClass();
        this.validValues = descriptor.getValidValues();
        this.defaultValue = descriptor.getDefaultValue();
        this.minimum = descriptor.getMinimumValue();
        this.maximum = descriptor.getMaximumValue();
        this.unit = descriptor.getUnit();
        this.primitiveClass = descriptor instanceof DefaultParameterDescriptor ? ((DefaultParameterDescriptor)descriptor).primitiveClass : this.valueClass;
    }

    public DefaultParameterDescriptor(String name, int defaultValue, int minimum, int maximum) {
        this(Collections.singletonMap("name", name), defaultValue, minimum, maximum, true);
    }

    public DefaultParameterDescriptor(Map properties, int defaultValue, int minimum, int maximum, boolean required) {
        this(properties, required, Integer.class, null, (Object)Parameter.wrap(defaultValue), (Comparable)(minimum == Integer.MIN_VALUE ? null : Parameter.wrap(minimum)), maximum == Integer.MAX_VALUE ? null : Parameter.wrap(maximum), null);
    }

    public DefaultParameterDescriptor(String name, double defaultValue, double minimum, double maximum, Unit unit) {
        this(Collections.singletonMap("name", name), defaultValue, minimum, maximum, unit, true);
    }

    public DefaultParameterDescriptor(Map properties, double defaultValue, double minimum, double maximum, Unit unit, boolean required) {
        this(properties, required, Double.class, null, (Object)(Double.isNaN(defaultValue) ? null : Parameter.wrap(defaultValue)), (Comparable)(minimum == Double.NEGATIVE_INFINITY ? null : Parameter.wrap(minimum)), maximum == Double.POSITIVE_INFINITY ? null : Parameter.wrap(maximum), unit);
    }

    public DefaultParameterDescriptor(String name, CharSequence remarks, Object defaultValue, boolean required) {
        this(DefaultParameterDescriptor.toMap(name, remarks), defaultValue.getClass(), defaultValue instanceof CodeList ? DefaultParameterDescriptor.getCodeLists(defaultValue.getClass()) : null, defaultValue, null, null, null, required);
    }

    private static final Map toMap(String name, CharSequence remarks) {
        if (remarks == null) {
            return Collections.singletonMap("name", name);
        }
        HashMap<String, CharSequence> properties = new HashMap<String, CharSequence>(4);
        properties.put("name", name);
        properties.put("remarks", remarks);
        return properties;
    }

    public DefaultParameterDescriptor(String name, CodeList defaultValue) {
        this(name, defaultValue.getClass(), defaultValue);
    }

    DefaultParameterDescriptor(String name, Class valueClass, CodeList defaultValue) {
        this(name, valueClass, DefaultParameterDescriptor.getCodeLists(valueClass), defaultValue);
    }

    private static CodeList[] getCodeLists(Class type) {
        try {
            return (CodeList[])type.getMethod("values", null).invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DefaultParameterDescriptor(String name, Class valueClass, Object[] validValues, Object defaultValue) {
        this(Collections.singletonMap("name", name), valueClass, validValues, defaultValue, null, null, null, true);
    }

    public DefaultParameterDescriptor(Citation authority, String name, Class valueClass, Object[] validValues, Object defaultValue, Comparable minimum, Comparable maximum, Unit unit, boolean required) {
        this(Collections.singletonMap("name", new IdentifierImpl(authority, name)), valueClass, validValues, defaultValue, minimum, maximum, unit, required);
    }

    public DefaultParameterDescriptor(Map properties, Class valueClass, Object[] validValues, Object defaultValue, Comparable minimum, Comparable maximum, Unit unit, boolean required) {
        this(properties, required, valueClass, validValues, defaultValue, Parameter.replace(minimum), Parameter.replace(maximum), unit);
    }

    private DefaultParameterDescriptor(Map properties, boolean required, Class valueClass, Object[] validValues, Object defaultValue, Comparable minimum, Comparable maximum, Unit unit) {
        super(properties, required ? 1 : 0, 1);
        this.primitiveClass = valueClass;
        this.defaultValue = defaultValue;
        this.minimum = minimum;
        this.maximum = maximum;
        this.unit = unit;
        DefaultParameterDescriptor.ensureNonNull("valueClass", valueClass);
        if (valueClass.isPrimitive()) {
            valueClass = ClassChanger.toWrapper(valueClass);
        }
        this.valueClass = valueClass;
        AbstractParameter.ensureValidClass(valueClass, defaultValue);
        AbstractParameter.ensureValidClass(valueClass, minimum);
        AbstractParameter.ensureValidClass(valueClass, maximum);
        if (minimum != null && maximum != null && minimum.compareTo(maximum) > 0) {
            throw new IllegalArgumentException(Errors.format(13, minimum, maximum));
        }
        if (validValues != null) {
            HashSet<Object> valids = new HashSet<Object>(Math.max(validValues.length * 4 / 3 + 1, 8), 0.75f);
            for (int i = 0; i < validValues.length; ++i) {
                Object value = validValues[i];
                AbstractParameter.ensureValidClass(valueClass, value);
                valids.add(value);
            }
            this.validValues = Collections.unmodifiableSet(valids);
        } else {
            this.validValues = null;
        }
        if (defaultValue != null) {
            Parameter.ensureValidValue(this, defaultValue);
        }
    }

    public int getMaximumOccurs() {
        return 1;
    }

    public GeneralParameterValue createValue() {
        if (Double.TYPE.equals(this.primitiveClass)) {
            return new FloatParameter(this);
        }
        return new Parameter(this);
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public Set getValidValues() {
        return this.validValues;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Comparable getMinimumValue() {
        return this.minimum;
    }

    public Comparable getMaximumValue() {
        return this.maximum;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            if (!(compareMetadata || this.nameMatches(object.getName().getCode()) || DefaultParameterDescriptor.nameMatches(object, this.getName().getCode()))) {
                return false;
            }
            DefaultParameterDescriptor that = (DefaultParameterDescriptor)object;
            return Utilities.equals(this.primitiveClass, that.primitiveClass) && Utilities.equals(this.validValues, that.validValues) && Utilities.equals(this.defaultValue, that.defaultValue) && Utilities.equals(this.minimum, that.minimum) && Utilities.equals(this.maximum, that.maximum) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    public int hashCode() {
        int code = super.hashCode() * 37 + this.valueClass.hashCode();
        if (this.defaultValue != null) {
            code += 37 * this.defaultValue.hashCode();
        }
        if (this.minimum != null) {
            code += 1369 * this.minimum.hashCode();
        }
        if (this.maximum != null) {
            code += 50653 * this.maximum.hashCode();
        }
        if (this.unit != null) {
            code += this.unit.hashCode();
        }
        return code;
    }
}

