/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import javax.units.Unit;
import org.geotools.resources.Utilities;

public final class Measure
extends Number {
    private static final long serialVersionUID = 6917234039472328164L;
    private final double value;
    private final Unit unit;

    public Measure(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.value);
        return (int)code ^ (int)(code >>> 32) ^ this.unit.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Measure) {
            Measure that = (Measure)object;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.value);
        buffer.append(' ');
        buffer.append(this.unit);
        return buffer.toString();
    }
}

