/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.Feature;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class GeomReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="shape file name")
    public JAMSString shapeFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of identifier column in shape file")
    public JAMSString idName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Original Shape file name")
    public JAMSString baseShape;

    public void run() throws Exception {
        URL shapeUrl = new File(this.dirName.getValue() + "/" + this.shapeFileName.getValue()).toURI().toURL();
        ShapefileDataStore store = new ShapefileDataStore(shapeUrl);
        this.baseShape.setValue(this.dirName.getValue() + "/" + this.shapeFileName.getValue() + ";" + this.idName);
        Iterator reader = store.getFeatureSource(store.getTypeNames()[0]).getFeatures().iterator();
        HashMap<Long, Geometry> geomMap = new HashMap<Long, Geometry>();
        while (reader.hasNext()) {
            Feature f = (Feature)reader.next();
            Long id = new Long(f.getAttribute(this.idName.getValue()).toString());
            geomMap.put(id, f.getDefaultGeometry());
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            long id = new Double(e.getDouble("ID")).longValue();
            e.setGeometry("geom", (Geometry)geomMap.get(id));
        }
    }
}

