/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import java.util.Collection;
import java.util.Iterator;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.resources.Utilities;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.util.InternationalString;

public class ExtentImpl
extends MetadataEntity
implements Extent {
    private static final long serialVersionUID = 7812213837337326257L;
    public static final Extent WORLD;
    private InternationalString description;
    private Collection geographicElements;
    private Collection temporalElements;
    private Collection verticalElements;

    public InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    public synchronized Collection getGeographicElements() {
        this.geographicElements = this.nonNullCollection(this.geographicElements, GeographicExtent.class);
        return this.geographicElements;
    }

    public synchronized void setGeographicElements(Collection newValues) {
        this.geographicElements = this.copyCollection(newValues, this.geographicElements, GeographicExtent.class);
    }

    public synchronized Collection getTemporalElements() {
        this.temporalElements = this.nonNullCollection(this.temporalElements, TemporalExtent.class);
        return this.temporalElements;
    }

    public synchronized void setTemporalElements(Collection newValues) {
        this.temporalElements = this.copyCollection(newValues, this.temporalElements, TemporalExtent.class);
    }

    public synchronized Collection getVerticalElements() {
        this.verticalElements = this.nonNullCollection(this.verticalElements, VerticalExtent.class);
        return this.verticalElements;
    }

    public synchronized void setVerticalElements(Collection newValues) {
        this.verticalElements = this.copyCollection(newValues, this.verticalElements, VerticalExtent.class);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        GeographicBoundingBox candidate = null;
        if (extent != null) {
            GeographicBoundingBoxImpl modifiable = null;
            Iterator it = extent.getGeographicElements().iterator();
            while (it.hasNext()) {
                GeographicExtent element = (GeographicExtent)it.next();
                if (!(element instanceof GeographicBoundingBox)) {
                    if (!(element instanceof BoundingPolygon)) continue;
                    continue;
                }
                GeographicBoundingBox bounds = (GeographicBoundingBox)element;
                if (candidate == null) {
                    if (!bounds.getInclusion()) continue;
                    candidate = bounds;
                    continue;
                }
                if (modifiable == null) {
                    modifiable = new GeographicBoundingBoxImpl(candidate);
                    candidate = modifiable;
                }
                modifiable.add(bounds);
            }
            if (modifiable != null) {
                modifiable.freeze();
            }
        }
        return candidate;
    }

    protected void freeze() {
        super.freeze();
        this.description = (InternationalString)ExtentImpl.unmodifiable(this.description);
        this.geographicElements = (Collection)ExtentImpl.unmodifiable(this.geographicElements);
        this.temporalElements = (Collection)ExtentImpl.unmodifiable(this.temporalElements);
        this.verticalElements = (Collection)ExtentImpl.unmodifiable(this.verticalElements);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            ExtentImpl that = (ExtentImpl)object;
            return Utilities.equals(this.description, that.description) && Utilities.equals(this.geographicElements, that.geographicElements) && Utilities.equals(this.temporalElements, that.temporalElements) && Utilities.equals(this.verticalElements, that.verticalElements);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 467792561;
        if (this.description != null) {
            code ^= this.description.hashCode();
        }
        if (this.geographicElements != null) {
            code ^= ((Object)this.geographicElements).hashCode();
        }
        if (this.temporalElements != null) {
            code ^= ((Object)this.temporalElements).hashCode();
        }
        if (this.verticalElements != null) {
            code ^= ((Object)this.verticalElements).hashCode();
        }
        return code;
    }

    public String toString() {
        GeographicBoundingBox box;
        StringBuffer buffer = new StringBuffer();
        if (this.description != null) {
            buffer.append((Object)this.description);
        }
        if ((box = ExtentImpl.getGeographicBoundingBox(this)) != null) {
            if (buffer.length() != 0) {
                buffer.append(System.getProperty("line.separator"));
            }
            buffer.append(GeographicBoundingBoxImpl.toString(box, "DD\u00b0MM'SS.s\"", null));
        }
        return buffer.toString();
    }

    static {
        ExtentImpl world = new ExtentImpl();
        world.getGeographicElements().add(GeographicBoundingBoxImpl.WORLD);
        world.freeze();
        WORLD = world;
    }
}

