/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.unijena.jams.data.JAMSCalendar;

public class CTSPlot {
    String plotTitle;
    String[] titleLeft;
    String[] varTitleLeft;
    String[] titleRight;
    String[] colorLeft;
    String[] colorRight;
    int typeLeft;
    int typeRight;
    String xAxisTitle;
    String leftAxisTitle;
    String rightAxisTitle;
    boolean rightAxisInverted;
    boolean leftAxisInverted;
    String dateFormat;
    public JAMSCalendar time;
    double[] valueLeft;
    double[] valueRight;
    String title;
    ChartPanel chartPanel;
    TimeSeries[] tsLeft;
    TimeSeries[] tsRight;
    TimeSeriesCollection dataset1;
    TimeSeriesCollection dataset2;
    XYItemRenderer rightRenderer;
    XYItemRenderer leftRenderer;
    XYPlot plot;
    JFreeChart chart;
    JPanel panel;
    JButton saveButton;
    int i;
    int graphCountLeft = 0;
    int graphCountRight = 0;
    HashMap<String, Color> colorTable = new HashMap();

    public CTSPlot() {
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        String plotTitle = "Title";
        String[] titleLeft = new String[]{"Title left"};
        String[] varTitleLeft = new String[]{"Var Title left"};
        String[] titleRight = new String[]{"Title right"};
        String[] colorLeft = new String[]{"red", "pink", "magenta", "orange", "yellow"};
        String[] colorRight = new String[]{"cyan", "blue", "green", "gray", "black"};
        boolean typeLeft = false;
        boolean typeRight = true;
        String xAxisTitle = "x axis title";
        String leftAxisTitle = "left axis title";
        String rightAxisTitle = "right axis title";
        boolean rightAxisInverted = false;
        String dateFormat = "dd/MM/yyyy";
        String title = "CTSPlot ver. 0.10";
    }

    public void setPlotTitle(String plotTitle) {
        this.plotTitle = plotTitle;
    }

    public void setTitleLeft(String[] titleLeft) {
        this.titleLeft = titleLeft;
    }

    public void setVarTitleLeft(String[] varTitleLeft) {
        this.varTitleLeft = varTitleLeft;
    }

    public void setTitleRight(String[] titleRight) {
        this.titleRight = titleRight;
    }

    public void setColorLeft(String[] colorLeft) {
        this.colorLeft = colorLeft;
    }

    public void setColorRight(String[] colorRight) {
        this.colorRight = colorRight;
    }

    public void setTypeLeft(int typeLeft) {
        this.typeLeft = typeLeft;
    }

    public void setTypeRight(int typeRight) {
        this.typeRight = typeRight;
    }

    public void setXAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
    }

    public void setLeftAxisTitle(String leftAxisTitle) {
        this.leftAxisTitle = leftAxisTitle;
    }

    public void setRightAxisTitle(String rightAxisTitle) {
        this.rightAxisTitle = rightAxisTitle;
    }

    public void setRightAxisInverted(boolean rightAxisInverted) {
        this.rightAxisInverted = rightAxisInverted;
    }

    public void setLeftAxisInverted(boolean rightAxisInverted) {
        this.leftAxisInverted = this.leftAxisInverted;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setGraphCountLeft(int graphCountLeft) {
        this.graphCountLeft = graphCountLeft;
    }

    public void setGraphCountRight(int graphCountRight) {
        this.graphCountRight = graphCountRight;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    private XYItemRenderer getRenderer(int type) {
        XYBarRenderer r;
        switch (type) {
            case 0: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
                break;
            }
            case 1: {
                r = new XYBarRenderer();
                break;
            }
            case 2: {
                r = new XYAreaRenderer();
                break;
            }
            case 3: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(true);
                r = lsr;
                break;
            }
            case 4: {
                XYDotRenderer dotR = new XYDotRenderer();
                dotR.setDefaultEntityRadius(2);
                r = dotR;
                break;
            }
            case 5: {
                r = new XYDifferenceRenderer();
                break;
            }
            case 6: {
                r = new XYStepRenderer();
                break;
            }
            case 7: {
                r = new XYStepAreaRenderer();
                break;
            }
            default: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
            }
        }
        return r;
    }

    public void createPlot() {
        this.dataset1 = new TimeSeriesCollection();
        this.dataset2 = new TimeSeriesCollection();
        this.chart = ChartFactory.createTimeSeriesChart((String)this.title, (String)this.xAxisTitle, (String)this.leftAxisTitle, (XYDataset)this.dataset1, (boolean)true, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.chartPanel.setBackground(Color.WHITE);
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(1, 1));
        this.panel.add((Component)this.chartPanel);
        if (this.chart != null) {
            this.plot = this.chart.getXYPlot();
            DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
            dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd-MM-yyyy"));
            this.leftRenderer = this.getRenderer(this.typeLeft);
            this.plot.setRenderer(0, this.leftRenderer);
            this.tsLeft = new TimeSeries[this.graphCountLeft];
            this.i = 0;
            while (this.i < this.graphCountLeft) {
                String legendEntry = this.titleLeft[this.i];
                this.leftRenderer.setSeriesPaint(this.i, (Paint)this.colorTable.get(this.colorLeft[this.i]));
                this.tsLeft[this.i] = new TimeSeries(legendEntry, Second.class);
                this.dataset1.addSeries(this.tsLeft[this.i]);
                ++this.i;
            }
            if (this.graphCountRight != 0) {
                NumberAxis axis2 = new NumberAxis(this.rightAxisTitle);
                axis2.setInverted(true);
                this.plot.setRangeAxis(1, (ValueAxis)axis2);
                this.plot.setDataset(1, (XYDataset)this.dataset2);
                this.plot.mapDatasetToRangeAxis(1, 1);
                this.rightRenderer = this.getRenderer(this.typeRight);
                this.plot.setRenderer(1, this.rightRenderer);
                this.plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
                this.tsRight = new TimeSeries[this.graphCountRight];
                this.i = 0;
                while (this.i < this.graphCountRight) {
                    this.rightRenderer.setSeriesPaint(this.i, (Paint)this.colorTable.get(this.colorRight[this.i]));
                    this.tsRight[this.i] = new TimeSeries(this.titleRight[this.i], Second.class);
                    this.dataset2.addSeries(this.tsRight[this.i]);
                    ++this.i;
                }
            }
        }
    }

    public void plot(JAMSCalendar time, double[] valueLeft, double[] valueRight) {
        try {
            double value;
            this.i = 0;
            while (this.i < this.graphCountRight) {
                value = valueRight[this.i];
                if (value == -9999.0) {
                    value = 0.0;
                }
                this.tsRight[this.i].add((RegularTimePeriod)new Second(new Date(time.getTimeInMillis())), value);
                ++this.i;
            }
            this.i = 0;
            while (this.i < this.graphCountLeft) {
                value = valueLeft[this.i];
                if (value == -9999.0) {
                    value = 0.0;
                }
                this.tsLeft[this.i].add((RegularTimePeriod)new Second(new Date(time.getTimeInMillis())), value);
                ++this.i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void cleanup() {
    }
}

