/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.coverage.grid.stream;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOExchange {
    private IOExchange() {
    }

    public static IOExchange getIOExchange() {
        return new IOExchange();
    }

    public Reader getReader(Object source) throws IOException {
        if (source instanceof Reader) {
            return (Reader)source;
        }
        if (source instanceof InputStream) {
            return new InputStreamReader((InputStream)source);
        }
        if (source instanceof String) {
            String urlString = (String)source;
            URL url = new URL(urlString);
            return new InputStreamReader(url.openStream());
        }
        if (source instanceof URL) {
            URL url = (URL)source;
            return new InputStreamReader(url.openStream());
        }
        if (source instanceof File) {
            return new FileReader((File)source);
        }
        if (source instanceof ReadableByteChannel) {
            return Channels.newReader((ReadableByteChannel)source, "UTF-8");
        }
        throw new IOException("Source Object is not recognized as one of the accepted source objects");
    }

    public Reader getGZIPReader(Object source) throws IOException {
        InputStream in = null;
        if (source instanceof Reader) {
            return (Reader)source;
        }
        if (source instanceof GZIPInputStream) {
            in = (InputStream)source;
        }
        if (source instanceof InputStream) {
            in = new GZIPInputStream((InputStream)source);
        }
        if (source instanceof String) {
            String urlString = (String)source;
            URL url = new URL(urlString);
            in = new GZIPInputStream(url.openStream());
        }
        if (source instanceof URL) {
            URL url = (URL)source;
            in = new GZIPInputStream(url.openStream());
        }
        if (source instanceof File) {
            in = new GZIPInputStream(new FileInputStream((File)source));
        }
        if (source instanceof ReadableByteChannel) {
            in = new GZIPInputStream(Channels.newInputStream((ReadableByteChannel)source));
        }
        if (in != null) {
            return new InputStreamReader(new BufferedInputStream(in));
        }
        throw new IOException("Source Object is not recognized as one of the accepted source objects");
    }

    public Writer getWriter(Object destination) throws IOException {
        if (destination instanceof Writer) {
            return (Writer)destination;
        }
        if (destination instanceof OutputStream) {
            return new OutputStreamWriter((OutputStream)destination);
        }
        if (destination instanceof String) {
            String urlString = (String)destination;
            URL url = new URL(urlString);
            return new OutputStreamWriter(url.openConnection().getOutputStream());
        }
        if (destination instanceof URL) {
            URL url = (URL)destination;
            return new OutputStreamWriter(url.openConnection().getOutputStream());
        }
        if (destination instanceof File) {
            return new FileWriter((File)destination);
        }
        if (destination instanceof WritableByteChannel) {
            return Channels.newWriter((WritableByteChannel)destination, "UTF-8");
        }
        throw new IOException("destination Object is not recognized as one of the accepted destination objects");
    }

    public PrintWriter getPrintWriter(Object destination) throws IOException {
        if (destination instanceof Writer) {
            return new PrintWriter((Writer)destination);
        }
        if (destination instanceof OutputStream) {
            return new PrintWriter((OutputStream)destination);
        }
        if (destination instanceof String) {
            String urlString = (String)destination;
            URL url = new URL(urlString);
            return new PrintWriter(url.openConnection().getOutputStream());
        }
        if (destination instanceof URL) {
            URL url = (URL)destination;
            return new PrintWriter(url.openConnection().getOutputStream());
        }
        if (destination instanceof File) {
            FileWriter fw = new FileWriter((File)destination);
            return new PrintWriter(fw);
        }
        if (destination instanceof WritableByteChannel) {
            return new PrintWriter(Channels.newWriter((WritableByteChannel)destination, "UTF-8"));
        }
        throw new IOException("destination Object is not recognized as one of the accepted destination objects");
    }

    public PrintWriter getGZIPPrintWriter(Object destination) throws IOException {
        if (destination instanceof PrintWriter) {
            return (PrintWriter)destination;
        }
        if (destination instanceof Writer) {
            return new PrintWriter((Writer)destination);
        }
        if (destination instanceof GZIPOutputStream) {
            return new PrintWriter((OutputStream)destination);
        }
        if (destination instanceof OutputStream) {
            return new PrintWriter(new GZIPOutputStream((OutputStream)destination));
        }
        if (destination instanceof String) {
            String urlString = (String)destination;
            URL url = new URL(urlString);
            GZIPOutputStream out = new GZIPOutputStream(url.openConnection().getOutputStream());
            return new PrintWriter(out);
        }
        if (destination instanceof URL) {
            URL url = (URL)destination;
            GZIPOutputStream out = new GZIPOutputStream(url.openConnection().getOutputStream());
            return new PrintWriter(out);
        }
        if (destination instanceof File) {
            GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream((File)destination));
            return new PrintWriter(out);
        }
        if (destination instanceof WritableByteChannel) {
            GZIPOutputStream out = new GZIPOutputStream(Channels.newOutputStream((WritableByteChannel)destination));
            return new PrintWriter(out);
        }
        throw new IOException("destination Object is not recognized as one of the accepted destination objects");
    }

    public static int determineSourceFormat(Object arg0) {
        return 0;
    }
}

