/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;

public class IndexedShapefileDataStoreFactory
implements FileDataStoreFactorySpi {
    public static final DataStoreFactorySpi.Param NAMESPACEP = new DataStoreFactorySpi.Param("namespace", URI.class, "uri to a the namespace", false);
    public static final DataStoreFactorySpi.Param URLP = new DataStoreFactorySpi.Param("shapefile url", URL.class, "url to a .shp file");
    public static final DataStoreFactorySpi.Param CREATE_SPATIAL_INDEX = new DataStoreFactorySpi.Param("create spatial index", Boolean.class, "enable/disable the automatic creation of spatial index", false);
    private static final Map HINTS = new HashMap();
    private Map liveStores = new HashMap();

    public boolean canProcess(Map params) {
        boolean accept = false;
        if (params.containsKey(IndexedShapefileDataStoreFactory.URLP.key)) {
            try {
                URL url = (URL)URLP.lookUp(params);
                accept = this.canProcess(url);
            }
            catch (IOException ioe) {
                accept = false;
            }
        }
        return accept;
    }

    public DataStore createDataStore(Map params) throws IOException {
        DataStore ds = null;
        ds = !this.liveStores.containsKey(params) ? this.createNewDataStore(params) : (DataStore)this.liveStores.get(params);
        return ds;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        URL url = null;
        IndexedShapefileDataStore ds = null;
        try {
            url = (URL)URLP.lookUp(params);
            Boolean idx = (Boolean)CREATE_SPATIAL_INDEX.lookUp(params);
            if (idx == null) {
                idx = Boolean.TRUE;
            }
            URI namespace = (URI)NAMESPACEP.lookUp(params);
            ds = new IndexedShapefileDataStore(url, namespace, false, idx, 2);
            this.liveStores.put(params, ds);
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException("Unable to attatch datastore to " + url, (Throwable)mue);
        }
        return ds;
    }

    public String getDisplayName() {
        return "Shapefile (Indexed)";
    }

    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    public boolean isAvailable() {
        try {
            ShapefileDataStore.class.getName();
            Geometry.class.getName();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{URLP, NAMESPACEP, CREATE_SPATIAL_INDEX};
    }

    public String[] getFileExtensions() {
        return new String[]{".shp"};
    }

    public boolean canProcess(URL f) {
        return f.getFile().toUpperCase().endsWith("SHP");
    }

    public DataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(IndexedShapefileDataStoreFactory.URLP.key, url);
        return this.createDataStore(params);
    }

    public DataStore createDataStore(URL url, boolean memorymapped) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(IndexedShapefileDataStoreFactory.URLP.key, url);
        return this.createDataStore(params);
    }

    public String getTypeName(URL url) throws IOException {
        DataStore ds = this.createDataStore(url);
        String[] names = ds.getTypeNames();
        return names == null || names.length == 0 ? null : names[0];
    }

    public Map getImplementationHints() {
        return HINTS;
    }

    static {
        HINTS.put(CREATE_SPATIAL_INDEX, true);
    }
}

