/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.util.Range;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.geotools.feature.Feature;
import org.geotools.filter.Expression;
import org.geotools.renderer.lite.CustomGlyphRenderer;
import org.geotools.renderer.lite.GlyphRenderer;
import org.geotools.renderer.lite.SVGGlyphRenderer;
import org.geotools.renderer.style.DynamicLineStyle2D;
import org.geotools.renderer.style.DynamicPolygonStyle2D;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.ImageLoader;
import org.geotools.renderer.style.InternalTranscoder;
import org.geotools.renderer.style.Java2DMark;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.Style;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleAttributeExtractorTruncated;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextMark;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.w3c.dom.Document;

public class SLDStyleFactory {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.rendering");
    private static final Map joinLookup = new HashMap();
    private static final Map capLookup = new HashMap();
    private static final Map fontStyleLookup = new HashMap();
    private static Set fontFamilies = null;
    private static Map loadedFonts = new HashMap();
    static Set wellKnownMarks = new HashSet();
    static Set supportedGraphicFormats = null;
    static ImageLoader imageLoader = new ImageLoader();
    private static final Canvas obs = new Canvas();
    private static List glyphRenderers = new ArrayList();
    WeakHashMap svgGlyphs = new WeakHashMap();
    WeakHashMap dynamicSymbolizers = new WeakHashMap();
    WeakHashMap staticSymbolizers = new WeakHashMap();
    private long hits;
    private long requests;
    private double mapScaleDenominator = Double.NaN;

    private static Set getSupportedGraphicFormats() {
        if (supportedGraphicFormats == null) {
            supportedGraphicFormats = new HashSet();
            String[] types = ImageIO.getReaderMIMETypes();
            for (int i = 0; i < types.length; ++i) {
                supportedGraphicFormats.add(types[i]);
            }
        }
        return supportedGraphicFormats;
    }

    public double getHitRatio() {
        return (double)this.hits / (double)this.requests;
    }

    public long getHits() {
        return this.hits;
    }

    public long getRequests() {
        return this.requests;
    }

    public Style2D createStyle(Feature f, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        SymbolizerKey key = new SymbolizerKey(symbolizer, scaleRange);
        style = (Style2D)this.staticSymbolizers.get(key);
        ++this.requests;
        if (style != null) {
            ++this.hits;
        } else {
            style = this.createStyleInternal(f, symbolizer, scaleRange);
            if (this.dynamicSymbolizers.containsKey(key)) {
                return style;
            }
            StyleAttributeExtractorTruncated sae = new StyleAttributeExtractorTruncated();
            sae.visit(symbolizer);
            Set nameSet = sae.getAttributeNameSet();
            if (nameSet == null || nameSet.size() == 0) {
                this.staticSymbolizers.put(key, style);
            } else {
                this.dynamicSymbolizers.put(key, null);
            }
        }
        if (this.staticSymbolizers.size() > 10000) {
            this.staticSymbolizers = new WeakHashMap();
        }
        if (this.dynamicSymbolizers.size() > 10000) {
            this.dynamicSymbolizers = new WeakHashMap();
        }
        return style;
    }

    private Style2D createStyleInternal(Feature f, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        if (symbolizer instanceof PolygonSymbolizer) {
            style = this.createPolygonStyle(f, (PolygonSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof LineSymbolizer) {
            style = this.createLineStyle(f, (LineSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof PointSymbolizer) {
            style = this.createPointStyle(f, (PointSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof TextSymbolizer) {
            style = this.createTextStyle(f, (TextSymbolizer)symbolizer, scaleRange);
        }
        return style;
    }

    public Style2D createDynamicStyle(Feature f, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        if (symbolizer instanceof PolygonSymbolizer) {
            style = this.createDynamicPolygonStyle(f, (PolygonSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof LineSymbolizer) {
            style = this.createDynamicLineStyle(f, (LineSymbolizer)symbolizer, scaleRange);
        } else {
            throw new UnsupportedOperationException("This kind of symbolizer is not yet supported");
        }
        return style;
    }

    Style2D createPolygonStyle(Feature feature, PolygonSymbolizer symbolizer, Range scaleRange) {
        PolygonStyle2D style = new PolygonStyle2D();
        this.setScaleRange(style, scaleRange);
        style.setStroke(this.getStroke(symbolizer.getStroke(), feature));
        style.setGraphicStroke(this.getGraphicStroke(symbolizer.getStroke(), feature));
        style.setContour(this.getStrokePaint(symbolizer.getStroke(), feature));
        style.setContourComposite(this.getStrokeComposite(symbolizer.getStroke(), feature));
        style.setFill(this.getPaint(symbolizer.getFill(), feature));
        style.setFillComposite(this.getComposite(symbolizer.getFill(), feature));
        return style;
    }

    Style2D createDynamicPolygonStyle(Feature feature, PolygonSymbolizer symbolizer, Range scaleRange) {
        DynamicPolygonStyle2D style = new DynamicPolygonStyle2D(feature, symbolizer);
        this.setScaleRange(style, scaleRange);
        return style;
    }

    Style2D createLineStyle(Feature feature, LineSymbolizer symbolizer, Range scaleRange) {
        LineStyle2D style = new LineStyle2D();
        this.setScaleRange(style, scaleRange);
        style.setStroke(this.getStroke(symbolizer.getStroke(), feature));
        style.setGraphicStroke(this.getGraphicStroke(symbolizer.getStroke(), feature));
        style.setContour(this.getStrokePaint(symbolizer.getStroke(), feature));
        style.setContourComposite(this.getStrokeComposite(symbolizer.getStroke(), feature));
        return style;
    }

    Style2D createDynamicLineStyle(Feature feature, LineSymbolizer symbolizer, Range scaleRange) {
        DynamicLineStyle2D style = new DynamicLineStyle2D(feature, symbolizer);
        this.setScaleRange(style, scaleRange);
        return style;
    }

    Style2D createPointStyle(Feature feature, PointSymbolizer symbolizer, Range scaleRange) {
        int size;
        Style2D retval = null;
        Graphic sldGraphic = symbolizer.getGraphic();
        float opacity = this.evalOpacity(sldGraphic.getOpacity(), feature);
        try {
            size = (int)this.evalToDouble(sldGraphic.getSize(), feature, 10.0);
        }
        catch (NumberFormatException nfe) {
            size = 10;
        }
        float rotation = (float)((double)this.evalToFloat(sldGraphic.getRotation(), feature, 0.0f) * Math.PI / 180.0);
        Symbol[] symbols = sldGraphic.getSymbols();
        int length = symbols.length;
        BufferedImage img = null;
        for (int i = 0; i < length; ++i) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("trying to render symbol " + i);
            }
            if (symbols[i] instanceof ExternalGraphic) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("rendering External graphic");
                }
                ExternalGraphic eg = (ExternalGraphic)symbols[i];
                img = null;
                Iterator it = glyphRenderers.iterator();
                while (it.hasNext() && img == null) {
                    GlyphRenderer r = (GlyphRenderer)it.next();
                    if (!r.canRender(eg.getFormat())) continue;
                    img = r.render(sldGraphic, eg, feature, size);
                    break;
                }
                if (img == null) {
                    img = this.getImage(eg, size);
                }
                if (img == null) continue;
                if (img.getHeight() != size) {
                    double scaleY;
                    double dsize = size;
                    double scaleX = scaleY = dsize / (double)img.getHeight();
                    AffineTransform scaleTx = AffineTransform.getScaleInstance(scaleX, scaleY);
                    AffineTransformOp ato = new AffineTransformOp(scaleTx, 2);
                    BufferedImage scaledImage = ato.createCompatibleDestImage(img, img.getColorModel());
                    img = ato.filter(img, scaledImage);
                }
                if (img != null) {
                    retval = new GraphicStyle2D(img, rotation, opacity);
                    break;
                }
            }
            if (symbols[i] instanceof Mark) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("rendering mark @ PointRenderer " + symbols[i].toString());
                }
                Mark mark = (Mark)symbols[i];
                Shape shape = Java2DMark.getWellKnownMark(mark.getWellKnownName().getValue(feature).toString());
                MarkStyle2D ms2d = new MarkStyle2D();
                ms2d.setShape(shape);
                ms2d.setFill(this.getPaint(mark.getFill(), feature));
                ms2d.setFillComposite(this.getComposite(mark.getFill(), feature));
                ms2d.setStroke(this.getStroke(mark.getStroke(), feature));
                ms2d.setContour(this.getStrokePaint(mark.getStroke(), feature));
                ms2d.setContourComposite(this.getStrokeComposite(mark.getStroke(), feature));
                ms2d.setSize(size);
                ms2d.setRotation(rotation);
                retval = ms2d;
                break;
            }
            if (!(symbols[i] instanceof TextMark)) continue;
        }
        if (retval != null) {
            this.setScaleRange(retval, scaleRange);
        }
        return retval;
    }

    Style2D createTextStyle(Feature feature, TextSymbolizer symbolizer, Range scaleRange) {
        PointPlacement p;
        Geometry geom;
        TextStyle2D ts2d = new TextStyle2D();
        this.setScaleRange(ts2d, scaleRange);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("creating text style");
        }
        String geomName = symbolizer.getGeometryPropertyName();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("geomName = " + geomName);
        }
        if ((geom = this.findGeometry(feature, geomName)) == null || geom.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("empty geometry");
            }
            return null;
        }
        Object obj = symbolizer.getLabel().getValue(feature);
        if (obj == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Null label in render text");
            }
            return null;
        }
        String label = obj.toString();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("label is " + label);
        }
        if (label == null) {
            return null;
        }
        ts2d.setLabel(label);
        org.geotools.styling.Font[] fonts = symbolizer.getFonts();
        Font javaFont = this.getFont(feature, fonts);
        ts2d.setFont(javaFont);
        LabelPlacement placement = symbolizer.getLabelPlacement();
        double anchorX = 0.0;
        double anchorY = 0.0;
        double rotation = 0.0;
        double dispX = 0.0;
        double dispY = 0.0;
        if (placement instanceof PointPlacement) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting pointPlacement");
            }
            p = (PointPlacement)placement;
            anchorX = ((Number)p.getAnchorPoint().getAnchorPointX().getValue(feature)).doubleValue();
            anchorY = ((Number)p.getAnchorPoint().getAnchorPointY().getValue(feature)).doubleValue();
            dispX = ((Number)p.getDisplacement().getDisplacementX().getValue(feature)).doubleValue();
            dispY = ((Number)p.getDisplacement().getDisplacementY().getValue(feature)).doubleValue();
            if (symbolizer instanceof TextSymbolizer2 && ((TextSymbolizer2)symbolizer).getGraphic() != null) {
                rotation = 0.0;
            } else {
                rotation = ((Number)p.getRotation().getValue(feature)).doubleValue();
                rotation *= Math.PI / 180;
            }
            ts2d.setPointPlacement(true);
        } else if (placement instanceof LinePlacement) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting pointPlacement");
            }
            ts2d.setPointPlacement(false);
            p = (LinePlacement)placement;
            int displace = ((Number)p.getPerpendicularOffset().getValue(feature)).intValue();
            ts2d.setPerpendicularOffset(displace);
        }
        ts2d.setAnchorX(anchorX);
        ts2d.setAnchorY(anchorY);
        ts2d.setRotation((float)rotation);
        ts2d.setDisplacementX(dispX);
        ts2d.setDisplacementY(dispY);
        ts2d.setFill(this.getPaint(symbolizer.getFill(), feature));
        ts2d.setComposite(this.getComposite(symbolizer.getFill(), feature));
        Halo halo = symbolizer.getHalo();
        if (halo != null) {
            ts2d.setHaloFill(this.getPaint(halo.getFill(), feature));
            ts2d.setHaloComposite(this.getComposite(halo.getFill(), feature));
            ts2d.setHaloRadius(((Number)halo.getRadius().getValue(feature)).floatValue());
        }
        Graphic graphicShield = null;
        if (symbolizer instanceof TextSymbolizer2 && (graphicShield = ((TextSymbolizer2)symbolizer).getGraphic()) != null) {
            PointSymbolizer p2 = StyleFactoryFinder.createStyleFactory().createPointSymbolizer();
            p2.setGraphic(graphicShield);
            Style2D shieldStyle = this.createPointStyle(feature, p2, scaleRange);
            ts2d.setGraphic(shieldStyle);
        }
        return ts2d;
    }

    private Geometry findGeometry(Feature feature, String geomName) {
        Geometry geom = null;
        geom = geomName == null ? feature.getDefaultGeometry() : (Geometry)feature.getAttribute(geomName);
        return geom;
    }

    private Font getFont(Feature feature, org.geotools.styling.Font[] fonts) {
        if (fontFamilies == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fontFamilies = new HashSet();
            List<String> f = Arrays.asList(ge.getAvailableFontFamilyNames());
            fontFamilies.addAll(f);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("there are " + fontFamilies.size() + " fonts available");
            }
        }
        Font javaFont = null;
        int styleCode = 0;
        int size = 6;
        String requestedFont = "";
        for (int k = 0; k < fonts.length; ++k) {
            InputStream is;
            block25: {
                String reqWeight;
                String reqStyle;
                requestedFont = fonts[k].getFontFamily().getValue(feature).toString();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("trying to load " + requestedFont);
                }
                if (loadedFonts.containsKey(requestedFont)) {
                    javaFont = (Font)loadedFonts.get(requestedFont);
                    reqStyle = (String)fonts[k].getFontStyle().getValue(feature);
                    styleCode = fontStyleLookup.containsKey(reqStyle) ? (Integer)fontStyleLookup.get(reqStyle) : 0;
                    reqWeight = (String)fonts[k].getFontWeight().getValue(feature);
                    if (reqWeight.equalsIgnoreCase("Bold")) {
                        styleCode |= 1;
                    }
                    size = ((Number)fonts[k].getFontSize().getValue(feature)).intValue();
                    return javaFont.deriveFont(styleCode, size);
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("not already loaded");
                }
                if (fontFamilies.contains(requestedFont)) {
                    reqStyle = (String)fonts[k].getFontStyle().getValue(feature);
                    styleCode = fontStyleLookup.containsKey(reqStyle) ? (Integer)fontStyleLookup.get(reqStyle) : 0;
                    reqWeight = (String)fonts[k].getFontWeight().getValue(feature);
                    if (reqWeight.equalsIgnoreCase("Bold")) {
                        styleCode |= 1;
                    }
                    size = ((Number)fonts[k].getFontSize().getValue(feature)).intValue();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("requesting " + requestedFont + " " + styleCode + " " + size);
                    }
                    javaFont = new Font(requestedFont, styleCode, size);
                    loadedFonts.put(requestedFont, javaFont);
                    return javaFont;
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("not a system font");
                }
                is = null;
                if (requestedFont.startsWith("http") || requestedFont.startsWith("file:")) {
                    try {
                        URL url = new URL(requestedFont);
                        is = url.openStream();
                    }
                    catch (MalformedURLException mue) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("Bad url in SLDStyleFactory " + requestedFont + "\n" + mue);
                        }
                        break block25;
                    }
                    catch (IOException ioe) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("IO error in SLDStyleFactory " + requestedFont + "\n" + ioe);
                        }
                        break block25;
                    }
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("not a URL");
                }
                File file = new File(requestedFont);
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException fne) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block25;
                    LOGGER.info("Bad file name in SLDStyleFactory" + requestedFont + "\n" + fne);
                }
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("about to load");
            }
            if (is == null) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("null input stream");
                continue;
            }
            try {
                javaFont = Font.createFont(0, is);
            }
            catch (FontFormatException ffe) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Font format error in SLDStyleFactory " + requestedFont + "\n" + ffe);
                continue;
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("IO error in SLDStyleFactory " + requestedFont + "\n" + ioe);
                continue;
            }
            loadedFonts.put(requestedFont, javaFont);
            return javaFont;
        }
        return new Font("Serif", 0, 12);
    }

    void setScaleRange(Style style, Range scaleRange) {
        double min = ((Number)((Object)scaleRange.getMinValue())).doubleValue();
        double max = ((Number)((Object)scaleRange.getMaxValue())).doubleValue();
        style.setMinMaxScale(min, max);
    }

    private BufferedImage getGraphicStroke(Stroke stroke, Feature feature) {
        if (stroke == null || stroke.getGraphicStroke() == null) {
            return null;
        }
        Graphic graphicStroke = stroke.getGraphicStroke();
        BufferedImage image = this.getExternalGraphic(graphicStroke);
        double size = ((Number)graphicStroke.getSize().getValue(feature)).doubleValue();
        if (image != null) {
            int trueImageWidth = image.getWidth();
            int trueImageHeight = image.getHeight();
            double scalex = size / (double)trueImageWidth;
            double scaley = size / (double)trueImageWidth;
            AffineTransform at = AffineTransform.getScaleInstance(scalex, scaley);
            AffineTransformOp ato = new AffineTransformOp(at, 2);
            BufferedImage scaledImage = ato.createCompatibleDestImage(image, image.getColorModel());
            ato.filter(image, scaledImage);
            image = scaledImage;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("got an image in graphic fill");
            }
        } else {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("going for the mark from graphic fill");
            }
            Mark mark = this.getMark(graphicStroke, feature);
            image = new BufferedImage((int)size, (int)size, 2);
            Graphics2D ig2d = image.createGraphics();
            double rotation = 0.0;
            rotation = ((Number)graphicStroke.getRotation().getValue(feature)).doubleValue();
            this.fillDrawMark(ig2d, size / 2.0, size / 2.0, mark, (int)size, rotation *= Math.PI / 180, feature);
            MediaTracker track = new MediaTracker(obs);
            track.addImage(image, 1);
            try {
                track.waitForID(1);
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.toString());
            }
        }
        return image;
    }

    private java.awt.Stroke getStroke(Stroke stroke, Feature feature) {
        if (stroke == null) {
            return null;
        }
        String joinType = this.evaluateExpression(stroke.getLineJoin(), feature, "miter");
        int joinCode = joinLookup.containsKey(joinType) ? (Integer)joinLookup.get(joinType) : 0;
        String capType = this.evaluateExpression(stroke.getLineCap(), feature, "square");
        int capCode = capLookup.containsKey(capType) ? (Integer)capLookup.get(capType) : 2;
        float[] dashes = stroke.getDashArray();
        float width = this.evalToFloat(stroke.getWidth(), feature, 1.0f);
        float dashOffset = this.evalToFloat(stroke.getDashOffset(), feature, 0.0f);
        if ((double)width < 1.5) {
            width = 0.0f;
        }
        BasicStroke stroke2d = dashes != null && dashes.length > 0 ? new BasicStroke(width, capCode, joinCode, 1.0f, dashes, dashOffset) : new BasicStroke(width, capCode, joinCode, 1.0f);
        return stroke2d;
    }

    private Paint getStrokePaint(Stroke stroke, Feature feature) {
        if (stroke == null) {
            return null;
        }
        Paint contourPaint = this.evalToColor(stroke.getColor(), feature, Color.BLACK);
        Graphic gr = stroke.getGraphicFill();
        if (gr != null) {
            contourPaint = this.getTexturePaint(gr, feature);
        }
        return contourPaint;
    }

    private Composite getStrokeComposite(Stroke stroke, Feature feature) {
        if (stroke == null) {
            return null;
        }
        float opacity = this.evalOpacity(stroke.getOpacity(), feature);
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        return composite;
    }

    protected Paint getPaint(Fill fill, Feature feature) {
        Graphic gr;
        if (fill == null) {
            return null;
        }
        Paint fillPaint = null;
        if (fill.getColor() != null) {
            fillPaint = Color.decode((String)fill.getColor().getValue(feature));
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Setting fill: " + fillPaint.toString());
            }
        }
        if ((gr = fill.getGraphicFill()) != null) {
            fillPaint = this.getTexturePaint(gr, feature);
        }
        return fillPaint;
    }

    protected Composite getComposite(Fill fill, Feature feature) {
        if (fill == null) {
            return null;
        }
        float opacity = this.evalOpacity(fill.getOpacity(), feature);
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        return composite;
    }

    public TexturePaint getTexturePaint(Graphic gr, Feature feature) {
        BufferedImage image = this.getExternalGraphic(gr);
        if (image != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("got an image in graphic fill");
            }
        } else {
            Mark mark;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("going for the mark from graphic fill");
            }
            if ((mark = this.getMark(gr, feature)) == null) {
                return null;
            }
            int size = 200;
            image = new BufferedImage(size, size, 2);
            Graphics2D g2d = image.createGraphics();
            double rotation = 0.0;
            rotation = ((Number)gr.getRotation().getValue(feature)).doubleValue();
            this.fillDrawMark(g2d, 100.0, 100.0, mark, (int)((double)size * 0.9), rotation *= Math.PI / 180, feature);
            MediaTracker track = new MediaTracker(obs);
            track.addImage(image, 1);
            try {
                track.waitForID(1);
            }
            catch (InterruptedException e) {
                LOGGER.warning("An unterupptedException occurred while drawing a local image..." + e);
            }
        }
        int size = ((Number)gr.getSize().getValue(feature)).intValue();
        double width = image.getWidth();
        double height = image.getHeight();
        double unitSize = Math.max(width, height);
        double drawSize = (double)size / unitSize;
        width *= drawSize;
        height *= -drawSize;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("size = " + size + " unitsize " + unitSize + " drawSize " + drawSize);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
        TexturePaint imagePaint = new TexturePaint(image, rect);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("applied TexturePaint " + imagePaint);
        }
        return imagePaint;
    }

    private BufferedImage getExternalGraphic(Graphic graphic) {
        ExternalGraphic[] extgraphics = graphic.getExternalGraphics();
        if (extgraphics != null) {
            for (int i = 0; i < extgraphics.length; ++i) {
                ExternalGraphic eg = extgraphics[i];
                BufferedImage img = this.getImage(eg, -1);
                if (img == null) continue;
                return img;
            }
        }
        return null;
    }

    private BufferedImage getImage(ExternalGraphic eg, int sizeHint) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("got a " + eg.getFormat());
        }
        if (eg.getFormat().toLowerCase().equals("image/svg")) {
            try {
                URL svgfile = eg.getLocation();
                InternalTranscoder svgTranscoder = new InternalTranscoder();
                TranscoderInput in = this.svgGlyphs.containsKey(svgfile) ? new TranscoderInput((Document)this.svgGlyphs.get(svgfile)) : new TranscoderInput(svgfile.openStream());
                if (sizeHint > 0) {
                    svgTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, new Float(sizeHint));
                }
                TranscoderOutput out = new TranscoderOutput();
                svgTranscoder.transcode(in, out);
                this.svgGlyphs.put(svgfile, svgTranscoder.getDocument());
                BufferedImage img = svgTranscoder.getImage();
                return img;
            }
            catch (IOException mue) {
                LOGGER.warning("Unable to load external svg file, " + mue.getMessage());
                return null;
            }
            catch (Exception e) {
                LOGGER.warning("Unable to process or render external svg file, " + e.getMessage());
                return null;
            }
        }
        if (SLDStyleFactory.getSupportedGraphicFormats().contains(eg.getFormat().toLowerCase())) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("a java supported format");
            }
            try {
                BufferedImage img = imageLoader.get(eg.getLocation(), false);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Image return = " + img);
                }
                return img;
            }
            catch (MalformedURLException e) {
                LOGGER.warning("ExternalGraphic has a malformed url: " + e);
            }
        }
        return null;
    }

    private Mark getMark(Graphic graphic, Feature feature) {
        Mark[] marks = graphic.getMarks();
        for (int i = 0; i < marks.length; ++i) {
            String name = marks[i].getWellKnownName().getValue(feature).toString();
            if (!wellKnownMarks.contains(name)) continue;
            Mark mark = marks[i];
            return mark;
        }
        Mark mark = null;
        return mark;
    }

    private void fillDrawMark(Graphics2D graphic, double tx, double ty, Mark mark, int size, double rotation, Feature feature) {
        AffineTransform temp = graphic.getTransform();
        AffineTransform markAT = new AffineTransform();
        Shape shape = Java2DMark.getWellKnownMark(mark.getWellKnownName().getValue(feature).toString());
        Point2D.Double mapCentre = new Point2D.Double(tx, ty);
        Point2D.Double graphicCentre = new Point2D.Double();
        temp.transform(mapCentre, graphicCentre);
        markAT.translate(((Point2D)graphicCentre).getX(), ((Point2D)graphicCentre).getY());
        double shearY = temp.getShearY();
        double scaleY = temp.getScaleY();
        double originalRotation = Math.atan(shearY / scaleY);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("originalRotation " + originalRotation);
        }
        markAT.rotate(rotation - originalRotation);
        double unitSize = 1.0;
        double drawSize = (double)size / unitSize;
        markAT.scale(drawSize, -drawSize);
        graphic.setTransform(markAT);
        if (mark.getFill() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying fill to mark");
            }
            graphic.setPaint(this.getPaint(mark.getFill(), null));
            graphic.setComposite(this.getComposite(mark.getFill(), null));
            graphic.fill(shape);
        }
        if (mark.getStroke() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying stroke to mark");
            }
            graphic.setPaint(this.getStrokePaint(mark.getStroke(), null));
            graphic.setComposite(this.getStrokeComposite(mark.getStroke(), null));
            graphic.setStroke(this.getStroke(mark.getStroke(), null));
            graphic.draw(shape);
        }
        graphic.setTransform(temp);
        if (mark.getFill() != null) {
            graphic.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    private String evaluateExpression(Expression e, Feature feature, String defaultValue) {
        String result = defaultValue;
        if (e != null && (result = (String)e.getValue(feature)) == null) {
            result = defaultValue;
        }
        return result;
    }

    public static int lookUpJoin(String joinType) {
        if (joinLookup.containsKey(joinType)) {
            return (Integer)joinLookup.get(joinType);
        }
        return 0;
    }

    public static int lookUpCap(String capType) {
        if (capLookup.containsKey(capType)) {
            return (Integer)capLookup.get(capType);
        }
        return 2;
    }

    public double getMapScaleDenominator() {
        return this.mapScaleDenominator;
    }

    public void setMapScaleDenominator(double mapScaleDenominator) {
        this.mapScaleDenominator = mapScaleDenominator;
    }

    private float evalToFloat(Expression exp, Feature f, float fallback) {
        if (exp == null) {
            return fallback;
        }
        try {
            if (f instanceof Number) {
                return ((Number)f).floatValue();
            }
            return Float.parseFloat(exp.getValue(f).toString());
        }
        catch (NumberFormatException nfe) {
            return fallback;
        }
    }

    private double evalToDouble(Expression exp, Feature f, double fallback) {
        if (exp == null) {
            return fallback;
        }
        try {
            if (f instanceof Number) {
                return ((Number)f).doubleValue();
            }
            return Double.parseDouble(exp.getValue(f).toString());
        }
        catch (NumberFormatException nfe) {
            return fallback;
        }
    }

    private Color evalToColor(Expression exp, Feature f, Color fallback) {
        if (exp == null) {
            return fallback;
        }
        try {
            return Color.decode((String)exp.getValue(f));
        }
        catch (NumberFormatException nfe) {
            return fallback;
        }
    }

    private float evalOpacity(Expression e, Feature f) {
        return this.evalToFloat(e, f, 1.0f);
    }

    static {
        joinLookup.put("miter", new Integer(0));
        joinLookup.put("bevel", new Integer(2));
        joinLookup.put("round", new Integer(1));
        capLookup.put("butt", new Integer(0));
        capLookup.put("round", new Integer(1));
        capLookup.put("square", new Integer(2));
        fontStyleLookup.put("normal", new Integer(0));
        fontStyleLookup.put("italic", new Integer(2));
        fontStyleLookup.put("oblique", new Integer(2));
        fontStyleLookup.put("bold", new Integer(1));
        wellKnownMarks.add("Square");
        wellKnownMarks.add("Triangle");
        wellKnownMarks.add("Cross");
        wellKnownMarks.add("Circle");
        wellKnownMarks.add("Star");
        wellKnownMarks.add("X");
        wellKnownMarks.add("Arrow");
        wellKnownMarks.add("Hatch");
        wellKnownMarks.add("square");
        wellKnownMarks.add("triangle");
        wellKnownMarks.add("cross");
        wellKnownMarks.add("circle");
        wellKnownMarks.add("star");
        wellKnownMarks.add("x");
        wellKnownMarks.add("arrow");
        wellKnownMarks.add("hatch");
        glyphRenderers.add(new CustomGlyphRenderer());
        try {
            glyphRenderers.add(new SVGGlyphRenderer());
        }
        catch (Exception e) {
            LOGGER.warning("Will not support SVG External Graphics " + e);
        }
    }

    private static class SymbolizerKey {
        private Symbolizer symbolizer;
        private double minScale;
        private double maxScale;

        public SymbolizerKey(Symbolizer symbolizer, Range scaleRange) {
            this.symbolizer = symbolizer;
            this.minScale = ((Number)((Object)scaleRange.getMinValue())).doubleValue();
            this.maxScale = ((Number)((Object)scaleRange.getMaxValue())).doubleValue();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SymbolizerKey)) {
                return false;
            }
            SymbolizerKey other = (SymbolizerKey)obj;
            return other.symbolizer == this.symbolizer && other.minScale == this.minScale && other.maxScale == this.maxScale;
        }

        public int hashCode() {
            return ((17 + System.identityHashCode(this.symbolizer)) * 37 + this.doubleHash(this.minScale)) * 37 + this.doubleHash(this.maxScale);
        }

        private int doubleHash(double value) {
            long bits = Double.doubleToLongBits(value);
            return (int)(bits ^ bits >>> 32);
        }
    }
}

