/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class JAMSSplash
extends JDialog {
    private Image img;

    public JAMSSplash() {
        this(0, 0);
    }

    public JAMSSplash(int x, int y) {
        this.setDefaultCloseOperation(2);
        this.setTitle("JAMS");
        this.setUndecorated(true);
        this.setFocusable(false);
        this.setAlwaysOnTop(true);
        URL imgURL = ClassLoader.getSystemResource("resources/images/JAMSsplash.png");
        if (this.img == null && imgURL != null) {
            this.img = new ImageIcon(imgURL).getImage();
        }
        if (x == 0) {
            x = this.img.getWidth(null);
            y = this.img.getHeight(null);
        } else {
            this.img = this.img.getScaledInstance(x, y, 4);
        }
        this.setSize(x, y);
        Dimension d2 = new Dimension(x, y);
        this.setPreferredSize(d2);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - x / 2, d.height / 2 - y / 2);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.drawImage(this.img, 0, 0, this);
    }

    public void show(JFrame frame, int timeInMillis) {
        this.setVisible(true);
        new Timer().schedule((TimerTask)new FrameStarter(this, frame), timeInMillis);
    }

    class FrameStarter
    extends TimerTask {
        private JDialog splash;
        private JFrame frame;

        public FrameStarter(JDialog splash, JFrame frame) {
            this.splash = splash;
            this.frame = frame;
        }

        @Override
        public void run() {
            this.splash.setVisible(false);
            this.splash.dispose();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FrameStarter.this.frame.setVisible(true);
                }
            });
        }
    }
}

