/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.io;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSData;
import org.unijena.jams.data.JAMSNumeric;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSGUIComponent;
import org.unijena.jams.model.JAMSModel;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.JAMSRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAMSModelLoader {
    private HashMap<String, JAMSComponent> componentRepository = new HashMap();
    private HashMap<String, String> constants = new HashMap();
    private ClassLoader loader;
    private JAMSModel jamsModel;

    public JAMSModelLoader(Document modelDoc, String[] globvars, JAMSRuntime rt) {
        this.loader = rt.getClassLoader();
        if (globvars != null) {
            for (int i = 0; i < globvars.length; ++i) {
                StringTokenizer tok = new StringTokenizer(globvars[i], "=");
                if (tok.countTokens() != 2) continue;
                this.constants.put(tok.nextToken(), tok.nextToken());
            }
        }
        this.jamsModel = new JAMSModel(rt);
        this.jamsModel.setModel(this.jamsModel);
        this.loadModel(modelDoc);
    }

    private void loadModel(Document modelDoc) {
        Element element;
        Node node;
        Element root = modelDoc.getDocumentElement();
        this.jamsModel.getRuntime().println("*************************************", 1);
        this.jamsModel.getRuntime().println("model  : " + root.getAttribute("name"), 1);
        this.jamsModel.getRuntime().println("author : " + root.getAttribute("author"), 1);
        this.jamsModel.getRuntime().println("date   : " + root.getAttribute("date"), 1);
        this.jamsModel.getRuntime().println("*************************************", 1);
        this.jamsModel.setName(root.getAttribute("name"));
        this.jamsModel.setInstanceName(root.getAttribute("name"));
        this.jamsModel.setAuthor(root.getAttribute("author"));
        this.jamsModel.setDate(root.getAttribute("date"));
        NodeList childs = root.getChildNodes();
        for (int index = 0; index < childs.getLength(); ++index) {
            node = childs.item(index);
            if (node.getNodeName() == "globvar" && !this.constants.containsKey((element = (Element)node).getAttribute("name"))) {
                this.constants.put(element.getAttribute("name"), element.getAttribute("value"));
            }
            if (node.getNodeName() != "attribute") continue;
            element = (Element)node;
            this.jamsModel.addAttribute(element.getAttribute("name"), element.getAttribute("class"), element.getAttribute("value"));
        }
        ArrayList<JAMSComponent> childComponentList = new ArrayList<JAMSComponent>();
        for (int index = 0; index < childs.getLength(); ++index) {
            node = childs.item(index);
            if (node.getNodeName() != "contextcomponent" && node.getNodeName() != "component") continue;
            element = (Element)node;
            try {
                JAMSComponent topComponent = this.loadComponent(element, this.jamsModel);
                this.jamsModel.addComponent(topComponent);
                childComponentList.add(topComponent);
                continue;
            }
            catch (ModelSpecificationException iae) {
                this.jamsModel.getRuntime().handle((Exception)iae, false);
            }
        }
        this.jamsModel.setComponents(childComponentList);
    }

    private JAMSComponent loadComponent(Element root, JAMSComponent rootComponent) throws ModelSpecificationException {
        String varClassName = "";
        Class<?> componentClazz = null;
        Class<?> varClazz = null;
        ArrayList<JAMSComponent> childComponentList = new ArrayList<JAMSComponent>();
        String componentName = root.getAttribute("name");
        String componentClassName = root.getAttribute("class");
        this.jamsModel.getRuntime().println("Adding: " + componentName + " (" + componentClassName + ")", 1);
        JAMSComponent component = null;
        try {
            this.jamsModel.getRuntime().println(componentClassName, 2);
            componentClazz = this.loader.loadClass(componentClassName);
            component = (JAMSComponent)componentClazz.newInstance();
            component.setModel(this.jamsModel);
            component.setInstanceName(componentName);
            if (component instanceof JAMSGUIComponent) {
                JAMSGUIComponent guiComponent = (JAMSGUIComponent)component;
                this.jamsModel.getRuntime().addGUIComponent(guiComponent);
            }
            this.createNumericMembers(component);
        }
        catch (ClassNotFoundException cnfe) {
            this.jamsModel.getRuntime().handle((Exception)cnfe, false);
            return null;
        }
        catch (InstantiationException ie) {
            this.jamsModel.getRuntime().handle((Exception)ie, false);
        }
        catch (IllegalAccessException iae) {
            this.jamsModel.getRuntime().handle((Exception)iae, false);
        }
        this.componentRepository.put(componentName, component);
        NodeList childs = root.getChildNodes();
        for (int index = 0; index < childs.getLength(); ++index) {
            Element element;
            Node node = childs.item(index);
            if (node.getNodeName() == "contextcomponent" || node.getNodeName() == "component") {
                JAMSComponent childComponent = this.loadComponent((Element)node, component);
                if (childComponent == null) continue;
                childComponentList.add(childComponent);
                continue;
            }
            if (node.getNodeName() == "attribute") {
                if (!JAMSContext.class.isAssignableFrom(component.getClass())) {
                    throw new ModelSpecificationException("Attribute tag can only be used inside context components! (component " + componentName + ")");
                }
                element = (Element)node;
                ((JAMSContext)component).addAttribute(element.getAttribute("name"), element.getAttribute("class"), element.getAttribute("value"));
                continue;
            }
            if (node.getNodeName() != "var") continue;
            element = (Element)node;
            String varName = element.getAttribute("name");
            try {
                Field field = componentClazz.getField(varName);
                varClassName = field.getType().getName();
                if (field.isAnnotationPresent(JAMSVarDescription.class)) {
                    JAMSVarDescription jvd = field.getAnnotation(JAMSVarDescription.class);
                    this.jamsModel.getRuntime().println("     " + componentName + " var declaration: " + varName + " (" + varClassName + ", " + (Object)((Object)jvd.access()) + ")", 2);
                    if (element.hasAttribute("value")) {
                        varClazz = this.loader.loadClass(varClassName);
                        JAMSData variable = (JAMSData)varClazz.newInstance();
                        String varValue = element.getAttribute("value");
                        variable.setValue(varValue);
                        field.set(component, variable);
                        JAMSData data = (JAMSData)field.get(component);
                        String id = componentName + "." + varName;
                        this.jamsModel.getRuntime().getDataHandles().put(id, data);
                    }
                    if (!element.hasAttribute("attribute")) continue;
                    JAMSComponent context = this.componentRepository.get(element.getAttribute("context"));
                    if (context == null) {
                        context = this.jamsModel;
                    }
                    if (!(context instanceof JAMSContext)) {
                        throw new ModelSpecificationException("Component " + componentName + ": Component \"" + element.getAttribute("context") + "\" must be of type JAMSSpatialContext!");
                    }
                    JAMSContext sc = (JAMSContext)context;
                    String attributeName = element.getAttribute("attribute");
                    if (jvd.access() == JAMSVarDescription.AccessType.READ) {
                        sc.addAccess(component, varName, attributeName, 0);
                        continue;
                    }
                    if (jvd.access() == JAMSVarDescription.AccessType.WRITE) {
                        sc.addAccess(component, varName, attributeName, 1);
                        continue;
                    }
                    if (jvd.access() != JAMSVarDescription.AccessType.READWRITE) continue;
                    sc.addAccess(component, varName, attributeName, 2);
                    continue;
                }
                throw new ModelSpecificationException("Component " + componentName + ": variable " + varName + " can not be accessed (missing annotation)!");
            }
            catch (NoSuchFieldException nsfe) {
                throw new ModelSpecificationException("Component " + componentName + ": variable " + varName + " not found!");
            }
            catch (ClassNotFoundException cnfe) {
                throw new ModelSpecificationException("Component " + componentName + ": variable class " + varClassName + " not found!");
            }
            catch (IllegalArgumentException iae) {
                throw new ModelSpecificationException("Component " + componentName + ": variable " + varName + ": wrong type!");
            }
            catch (InstantiationException ie) {
                throw new ModelSpecificationException("Component " + componentName + ": variable " + varName + ": Instantiation exception!");
            }
            catch (IllegalAccessException iae) {
                throw new ModelSpecificationException("Component " + componentName + ": variable " + varName + ": Access exception!");
            }
            catch (Exception ex) {
                this.jamsModel.getRuntime().handle(ex);
            }
        }
        if (component instanceof JAMSContext) {
            ((JAMSContext)component).setComponents(childComponentList);
        }
        return component;
    }

    private void createMembers(JAMSComponent component) throws IllegalAccessException, InstantiationException {
        Field[] fields = component.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            JAMSData dataObject;
            Object o = fields[i].get(component);
            Class<?> dataType = fields[i].getType();
            if (dataType.isInterface() || !JAMSData.class.isAssignableFrom(dataType) || !fields[i].isAnnotationPresent(JAMSVarDescription.class) || (dataObject = (JAMSData)o) != null) continue;
            System.out.println(fields[i].getName());
            dataObject = (JAMSData)dataType.newInstance();
            fields[i].set(component, dataObject);
        }
    }

    private void createNumericMembers(JAMSComponent component) throws IllegalAccessException, InstantiationException {
        Class<?> cClass = component.getClass();
        Field[] fields = cClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            JAMSVarDescription jvd;
            Object var = fields[i].get(component);
            if (!JAMSNumeric.class.isAssignableFrom(fields[i].getType())) continue;
            JAMSNumeric numericObject = (JAMSNumeric)var;
            if (numericObject == null) {
                numericObject = (JAMSNumeric)fields[i].getType().newInstance();
                fields[i].set(component, numericObject);
            }
            if ((jvd = fields[i].getAnnotation(JAMSVarDescription.class)).lowerBound() < jvd.upperBound()) {
                numericObject.setRange(jvd.lowerBound(), jvd.upperBound());
            }
            if (!jvd.unit().equals("")) {
                numericObject.setUnit(jvd.unit());
            }
            if (jvd.defaultValue().equals("")) continue;
            numericObject.setValue(jvd.defaultValue());
        }
    }

    public JAMSModel getModel() {
        return this.jamsModel;
    }

    public JAMSData getInstance(Class clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        JAMSData data = null;
        String className = clazz.getSimpleName();
        data = className.equals("JAMSString") ? (JAMSData)clazz.newInstance() : (className.equals("JAMSInteger") ? (JAMSData)clazz.newInstance() : (className.equals("JAMSBoolean") ? (JAMSData)clazz.newInstance() : (className.equals("JAMSDouble") ? (JAMSData)Class.forName("org.unijena.jams.data.JAMSSimpleDouble").newInstance() : (JAMSData)clazz.newInstance())));
        return data;
    }

    class ModelSpecificationException
    extends Exception {
        private static final long serialVersionUID = -4647280426459909507L;

        public ModelSpecificationException(String errorMsg) {
            super(errorMsg);
        }
    }
}

