/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui.input;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.gui.LHelper;
import org.unijena.jams.gui.input.InputComponent;

public class TimeintervalInput
extends JPanel
implements InputComponent {
    JTextField tuCount;
    JTextField syear;
    JTextField smonth;
    JTextField sday;
    JTextField shour;
    JTextField sminute;
    JTextField eyear;
    JTextField emonth;
    JTextField eday;
    JTextField ehour;
    JTextField eminute;
    JComboBox timeUnit;
    Map<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
    Map<Integer, Integer> fieldMap = new HashMap<Integer, Integer>();
    JPanel panel;

    public TimeintervalInput() {
        GridBagLayout gbl = new GridBagLayout();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(gbl);
        LHelper.addGBComponent(this, gbl, new JLabel("Date (YYYY/MM/DD)"), 1, 0, 1, 1, 0.0, 0.0);
        LHelper.addGBComponent(this, gbl, new JLabel("Time (HH:MM)"), 11, 0, 1, 1, 0.0, 0.0);
        LHelper.addGBComponent(this, gbl, new JLabel("Start: "), 0, 1, 1, 1, 0.0, 0.0);
        LHelper.addGBComponent(this, gbl, new JLabel("End: "), 0, 2, 1, 1, 0.0, 0.0);
        LHelper.addGBComponent(this, gbl, new JLabel("Unit: "), 0, 3, 1, 1, 0.0, 0.0);
        LHelper.addGBComponent(this, gbl, new JLabel("Unit Count: "), 0, 4, 1, 1, 0.0, 0.0);
        this.syear = new JTextField();
        this.syear.setInputVerifier(new NumericIntervalVerifier(1900.0, 2100.0));
        this.syear.setPreferredSize(new Dimension(40, 20));
        this.smonth = new JTextField();
        this.smonth.setInputVerifier(new NumericIntervalVerifier(1.0, 12.0));
        this.smonth.setPreferredSize(new Dimension(25, 20));
        this.sday = new JTextField();
        this.sday.setInputVerifier(new NumericIntervalVerifier(1.0, 31.0));
        this.sday.setPreferredSize(new Dimension(25, 20));
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.panel.add(this.syear);
        this.panel.add(new JLabel("/"));
        this.panel.add(this.smonth);
        this.panel.add(new JLabel("/"));
        this.panel.add(this.sday);
        LHelper.addGBComponent(this, gbl, this.panel, 1, 1, 10, 1, 0.0, 0.0);
        this.shour = new JTextField();
        this.shour.setInputVerifier(new NumericIntervalVerifier(0.0, 23.0));
        this.shour.setPreferredSize(new Dimension(25, 20));
        this.sminute = new JTextField();
        this.sminute.setInputVerifier(new NumericIntervalVerifier(0.0, 59.0));
        this.sminute.setPreferredSize(new Dimension(25, 20));
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.panel.add(this.shour);
        this.panel.add(new JLabel(":"));
        this.panel.add(this.sminute);
        LHelper.addGBComponent(this, gbl, this.panel, 11, 1, 1, 1, 0.0, 0.0);
        this.eyear = new JTextField();
        this.eyear.setInputVerifier(new NumericIntervalVerifier(1900.0, 2100.0));
        this.eyear.setPreferredSize(new Dimension(40, 20));
        this.emonth = new JTextField();
        this.emonth.setInputVerifier(new NumericIntervalVerifier(1.0, 12.0));
        this.emonth.setPreferredSize(new Dimension(25, 20));
        this.eday = new JTextField();
        this.eday.setInputVerifier(new NumericIntervalVerifier(1.0, 31.0));
        this.eday.setPreferredSize(new Dimension(25, 20));
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.panel.add(this.eyear);
        this.panel.add(new JLabel("/"));
        this.panel.add(this.emonth);
        this.panel.add(new JLabel("/"));
        this.panel.add(this.eday);
        LHelper.addGBComponent(this, gbl, this.panel, 1, 2, 10, 1, 0.0, 0.0);
        this.ehour = new JTextField();
        this.ehour.setInputVerifier(new NumericIntervalVerifier(0.0, 23.0));
        this.ehour.setPreferredSize(new Dimension(25, 20));
        this.eminute = new JTextField();
        this.eminute.setInputVerifier(new NumericIntervalVerifier(0.0, 59.0));
        this.eminute.setPreferredSize(new Dimension(25, 20));
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.panel.add(this.ehour);
        this.panel.add(new JLabel(":"));
        this.panel.add(this.eminute);
        LHelper.addGBComponent(this, gbl, this.panel, 11, 2, 1, 1, 0.0, 0.0);
        this.indexMap.put(1, 0);
        this.indexMap.put(2, 1);
        this.indexMap.put(6, 2);
        this.indexMap.put(11, 3);
        this.indexMap.put(12, 4);
        this.indexMap.put(13, 5);
        this.fieldMap.put(0, 1);
        this.fieldMap.put(1, 2);
        this.fieldMap.put(2, 6);
        this.fieldMap.put(3, 11);
        this.fieldMap.put(4, 12);
        this.fieldMap.put(5, 13);
        this.timeUnit = new JComboBox();
        this.timeUnit.addItem("YEAR");
        this.timeUnit.addItem("MONTH");
        this.timeUnit.addItem("DAY");
        this.timeUnit.addItem("HOUR");
        this.timeUnit.addItem("MINUTE");
        this.timeUnit.addItem("SECOND");
        this.timeUnit.setPreferredSize(new Dimension(40, 20));
        LHelper.addGBComponent(this, gbl, this.timeUnit, 1, 3, 1, 1, 0.0, 0.0);
        this.tuCount = new JTextField();
        this.tuCount.setInputVerifier(new NumericIntervalVerifier(0.0, 1000.0));
        this.tuCount.setPreferredSize(new Dimension(40, 20));
        LHelper.addGBComponent(this, gbl, this.tuCount, 1, 4, 1, 1, 0.0, 0.0);
        this.sday.setBorder(BorderFactory.createEtchedBorder());
        this.smonth.setBorder(BorderFactory.createEtchedBorder());
        this.syear.setBorder(BorderFactory.createEtchedBorder());
        this.shour.setBorder(BorderFactory.createEtchedBorder());
        this.sminute.setBorder(BorderFactory.createEtchedBorder());
        this.eday.setBorder(BorderFactory.createEtchedBorder());
        this.emonth.setBorder(BorderFactory.createEtchedBorder());
        this.eyear.setBorder(BorderFactory.createEtchedBorder());
        this.ehour.setBorder(BorderFactory.createEtchedBorder());
        this.eminute.setBorder(BorderFactory.createEtchedBorder());
        this.tuCount.setBorder(BorderFactory.createEtchedBorder());
        this.timeUnit.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public String getValue() {
        JAMSTimeInterval ti = new JAMSTimeInterval();
        ti.setStart(new JAMSCalendar(Integer.parseInt(this.syear.getText()), Integer.parseInt(this.smonth.getText()) - 1, Integer.parseInt(this.sday.getText()), Integer.parseInt(this.shour.getText()), Integer.parseInt(this.sminute.getText()), 0));
        ti.setEnd(new JAMSCalendar(Integer.parseInt(this.eyear.getText()), Integer.parseInt(this.emonth.getText()) - 1, Integer.parseInt(this.eday.getText()), Integer.parseInt(this.ehour.getText()), Integer.parseInt(this.eminute.getText()), 0));
        ti.setTimeUnit(this.fieldMap.get(this.timeUnit.getSelectedIndex()));
        ti.setTimeUnitCount(Integer.parseInt(this.tuCount.getText()));
        return ti.toString();
    }

    @Override
    public void setValue(String value) {
        JAMSTimeInterval ti = new JAMSTimeInterval();
        if (value != "") {
            ti.setValue(value);
        }
        JAMSCalendar start = ti.getStart();
        this.syear.setText(Integer.toString(start.get(1)));
        this.smonth.setText(Integer.toString(start.get(2) + 1));
        this.sday.setText(Integer.toString(start.get(5)));
        this.shour.setText(Integer.toString(start.get(11)));
        this.sminute.setText(Integer.toString(start.get(12)));
        JAMSCalendar end = ti.getEnd();
        this.eyear.setText(Integer.toString(end.get(1)));
        this.emonth.setText(Integer.toString(end.get(2) + 1));
        this.eday.setText(Integer.toString(end.get(5)));
        this.ehour.setText(Integer.toString(end.get(11)));
        this.eminute.setText(Integer.toString(end.get(12)));
        this.timeUnit.setSelectedIndex(this.indexMap.get(ti.getTimeUnit()));
        this.tuCount.setText(Integer.toString(ti.getTimeUnitCount()));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setRange(double lower, double upper) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.syear.setEnabled(enabled);
        this.smonth.setEnabled(enabled);
        this.sday.setEnabled(enabled);
        this.shour.setEnabled(enabled);
        this.sminute.setEnabled(enabled);
        this.eyear.setEnabled(enabled);
        this.emonth.setEnabled(enabled);
        this.eday.setEnabled(enabled);
        this.ehour.setEnabled(enabled);
        this.eminute.setEnabled(enabled);
        this.timeUnit.setEnabled(enabled);
        this.tuCount.setEnabled(enabled);
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    class NumericIntervalVerifier
    extends InputVerifier {
        double lower;
        double upper;

        public NumericIntervalVerifier(double lower, double upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean verify(JComponent input) {
            boolean result = false;
            try {
                double value = Double.parseDouble(((JTextField)input).getText());
                if (value >= this.lower && value <= this.upper) {
                    result = true;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            return result;
        }
    }
}

