/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geotools.feature.Feature;
import org.geotools.filter.CompareFilterImpl;
import org.geotools.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class IsEqualsToImpl
extends CompareFilterImpl
implements PropertyIsEqualTo {
    private static Set SUPPORTED_NUMERIC = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class));

    protected IsEqualsToImpl(FilterFactory factory) {
        this(factory, null, null);
    }

    protected IsEqualsToImpl(FilterFactory factory, Expression expression1, Expression expression2) {
        super(factory, expression1, expression2);
        this.filterType = (short)14;
    }

    public boolean evaluate(Feature feature) {
        Object value2;
        Object value1 = this.eval(this.expression1, (Object)feature);
        if (value1 == (value2 = this.eval(this.expression2, (Object)feature))) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1.equals(value2)) {
            return true;
        }
        boolean isNumeric1 = value1 instanceof Number;
        boolean isNumeric2 = value2 instanceof Number;
        if (isNumeric1 && isNumeric2 || isNumeric1 && value2 instanceof CharSequence || isNumeric2 && value1 instanceof CharSequence) {
            long lg2;
            Number n2;
            Number n1;
            try {
                n1 = isNumeric1 ? (Number)((Number)value1) : (Number)IsEqualsToImpl.parseToNumber(value1.toString());
                n2 = isNumeric2 ? (Number)((Number)value2) : (Number)IsEqualsToImpl.parseToNumber(value2.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
            double fp1 = n1.doubleValue();
            double fp2 = n2.doubleValue();
            long lg1 = n1.longValue();
            if (fp1 == (double)lg1 && fp2 == (double)(lg2 = n2.longValue())) {
                return lg1 == lg2;
            }
            return fp1 == fp2 || Double.isNaN(fp1) && Double.isNaN(fp2);
        }
        return false;
    }

    private static Number parseToNumber(String value) throws NumberFormatException {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return Double.valueOf(value);
        }
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsEqualTo)this, extraData);
    }
}

