/*
 * Decompiled with CFR 0.152.
 */
package jams.components.efficiencies;

public class NashSutcliffe {
    public static double efficiency(double[] prediction, double[] validation, double pow) {
        int pre_size = prediction.length;
        int val_size = validation.length;
        int steps = 0;
        double sum_td = 0.0;
        double sum_vd = 0.0;
        if (pre_size != val_size) {
            System.err.println("Prediction data and validation data are not consistent!");
            return -9999.0;
        }
        steps = pre_size;
        for (int i = 0; i < steps; ++i) {
            sum_td += prediction[i];
            sum_vd += validation[i];
        }
        double mean_td = sum_td / (double)steps;
        double mean_vd = sum_vd / (double)steps;
        double td_vd = 0.0;
        double vd_mean = 0.0;
        for (int i = 0; i < steps; ++i) {
            td_vd += Math.pow(Math.abs(validation[i] - prediction[i]), pow);
            vd_mean += Math.pow(Math.abs(validation[i] - mean_vd), pow);
        }
        double efficiency = 1.0 - td_vd / vd_mean;
        return efficiency;
    }

    public static double logEfficiency(double[] prediction, double[] validation, double pow) {
        int i;
        int pre_size = prediction.length;
        int val_size = validation.length;
        int steps = 0;
        double sum_log_pd = 0.0;
        double sum_log_vd = 0.0;
        if (pre_size != val_size) {
            System.err.println("Prediction data and validation data are not consistent!");
            return -9999.0;
        }
        steps = pre_size;
        double[] log_preData = new double[pre_size];
        double[] log_valData = new double[val_size];
        int validPairs = 0;
        for (i = 0; i < steps; ++i) {
            if (prediction[i] <= 0.0 || validation[i] <= 0.0) {
                log_preData[i] = -1.0;
                log_valData[i] = -1.0;
            }
            if (prediction[i] == 0.0 && validation[i] == 0.0) {
                log_preData[i] = 0.0;
                log_valData[i] = 0.0;
                ++validPairs;
            }
            if (!(prediction[i] > 0.0) || !(validation[i] > 0.0)) continue;
            log_preData[i] = Math.log(prediction[i]);
            log_valData[i] = Math.log(validation[i]);
            ++validPairs;
        }
        for (i = 0; i < steps; ++i) {
            if (!(log_preData[i] >= 0.0)) continue;
            sum_log_pd += log_preData[i];
            sum_log_vd += log_valData[i];
        }
        double mean_log_pd = sum_log_pd / (double)validPairs;
        double mean_log_vd = sum_log_vd / (double)validPairs;
        double pd_log_vd = 0.0;
        double vd_log_mean = 0.0;
        for (int i2 = 0; i2 < steps; ++i2) {
            if (!(log_preData[i2] >= 0.0)) continue;
            pd_log_vd += Math.pow(Math.abs(log_valData[i2] - log_preData[i2]), pow);
            vd_log_mean += Math.pow(Math.abs(log_valData[i2] - mean_log_vd), pow);
        }
        double log_efficiency = 1.0 - pd_log_vd / vd_log_mean;
        return log_efficiency;
    }
}

