/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class TemporalSumAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time <math>\\frac{\\pi}{\\gamma^{\\pi}}<\\math>")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="value attribute")
    public JAMSDouble[] value;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="weight attribute")
    public JAMSDouble weight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="sum attribute")
    public JAMSDouble[] sum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Aggregation time interval")
    public JAMSTimeInterval aggregationTimeInterval;
    private long count;

    public void init() {
        this.count = this.aggregationTimeInterval.getNumberOfTimesteps();
    }

    public void run() {
        if (!this.time.after((Object)this.aggregationTimeInterval.getEnd()) && !this.time.before((Object)this.aggregationTimeInterval.getStart())) {
            for (int i = 0; i < this.value.length; ++i) {
                this.sum[i].setValue(this.sum[i].getValue() + this.value[i].getValue() / (this.weight.getValue() * (double)this.count));
            }
        }
    }

    public void cleanup() {
        for (int i = 0; i < this.value.length; ++i) {
            this.sum[i].setValue(0.0);
        }
    }
}

