/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSIntegerArray;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class Regionalisation_1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of data values for current time step")
    public JAMSDoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Regression coefficients")
    public JAMSDoubleArray regCoeff = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station elevations")
    public JAMSDoubleArray statElevation = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="data set descriptor")
    public JAMSString dataSetName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's x coordinates")
    public JAMSDoubleArray statX = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's y coordinates")
    public JAMSDoubleArray statY = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's weights")
    public JAMSDoubleArray statWeights = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array position of weights")
    public JAMSIntegerArray wArray = new JAMSIntegerArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Attribute name x coordinate (hru)")
    public JAMSDouble unitX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Attribute name y coordinate (hru)")
    public JAMSDouble unitY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="regionalised data value")
    public JAMSDouble dataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Attribute name elevation")
    public JAMSDouble entityElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of IDW stations")
    public JAMSInteger nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Power of IDW function")
    public JAMSDouble pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Apply elevation correction to measured data")
    public JAMSBoolean elevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Minimum r\u00b2 value for elevation correction application")
    public JAMSDouble rsqThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;
    private File cacheFile;
    private boolean useCache = false;
    private ObjectOutputStream writer;
    private ObjectInputStream reader;
    double NODATA = -9999.0;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
        this.cacheFile = new File(this.dirName.getValue() + "/$" + this.getInstanceName() + ".cache");
        if (!this.cacheFile.exists() && this.dataCaching.getValue()) {
            this.getModel().getRuntime().sendHalt(this.getInstanceName() + ": data caching is switched on but no cache file available!");
        }
        if (this.dataCaching.getValue()) {
            this.useCache = true;
            this.reader = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
        } else {
            this.useCache = false;
            this.writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException, IOException {
        if (!this.useCache) {
            int i;
            int counter;
            double[] regCoeff = this.regCoeff.getValue();
            double gradient = regCoeff[1];
            double rsq = regCoeff[2];
            double[] sourceElevations = this.statElevation.getValue();
            double[] sourceData = this.dataArray.getValue();
            double[] sourceWeights = this.statWeights.getValue();
            double targetElevation = this.entityElevation.getValue();
            double value = 0.0;
            double deltaElev = 0.0;
            int nIDW = this.nidw.getValue();
            double[] data = new double[nIDW];
            double[] weights = new double[nIDW];
            double[] elev = new double[nIDW];
            for (int i2 = 0; i2 < nIDW; ++i2) {
                data[i2] = 0.0;
                weights[i2] = 0.0;
                elev[i2] = 0.0;
            }
            int[] wA = this.wArray.getValue();
            int element = counter = 0;
            boolean cont = true;
            boolean valid = false;
            while (counter < nIDW && cont) {
                int t = wA[element];
                if (sourceData[t] == this.NODATA) {
                    if (++element >= wA.length) {
                        System.out.println("BREAK1: too less data NIDW had been reduced!");
                        cont = false;
                        continue;
                    }
                    t = wA[element];
                    continue;
                }
                valid = true;
                data[counter] = sourceData[t];
                weights[counter] = sourceWeights[t];
                elev[counter] = sourceElevations[t];
                ++counter;
                ++element;
            }
            double weightsum = 0.0;
            for (i = 0; i < counter; ++i) {
                weightsum += weights[i];
            }
            for (i = 0; i < counter; ++i) {
                weights[i] = weights[i] / weightsum;
            }
            if (valid) {
                for (i = 0; i < counter; ++i) {
                    if (rsq >= this.rsqThreshold.getValue() && this.elevationCorrection.getValue()) {
                        deltaElev = targetElevation - elev[i];
                        double tVal = (deltaElev * gradient + data[i]) * weights[i];
                        value += tVal;
                        continue;
                    }
                    value += data[i] * weights[i];
                }
            } else {
                System.out.println("All data are no-data values!");
                value = this.NODATA;
            }
            this.dataValue.setValue(value);
            this.writer.writeDouble(value);
        } else {
            this.dataValue.setValue(this.reader.readDouble());
        }
    }

    public void cleanup() throws IOException {
        if (!this.useCache) {
            this.writer.flush();
            this.writer.close();
        } else {
            this.reader.close();
        }
    }
}

