/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FilterTransformer
extends TransformerBase {
    private static String defaultNamespace = "http://www.opengis.net/ogc";
    private static Map comparisions = new HashMap();
    private static Map spatial = new HashMap();
    private static Map logical = new HashMap();
    private static Map expressions = new HashMap();
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public String transform(Filter f) throws TransformerException {
        return super.transform(f);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new FilterTranslator(handler);
    }

    static {
        comparisions.put(new Integer(14), "PropertyIsEqualTo");
        comparisions.put(new Integer(16), "PropertyIsGreaterThan");
        comparisions.put(new Integer(18), "PropertyIsGreaterThanOrEqualTo");
        comparisions.put(new Integer(15), "PropertyIsLessThan");
        comparisions.put(new Integer(17), "PropertyIsLessThanOrEqualTo");
        comparisions.put(new Integer(20), "PropertyIsLike");
        comparisions.put(new Integer(21), "PropertyIsNull");
        comparisions.put(new Integer(19), "PropertyIsBetween");
        expressions.put(new Integer(105), "Add");
        expressions.put(new Integer(108), "Div");
        expressions.put(new Integer(107), "Mul");
        expressions.put(new Integer(106), "Sub");
        expressions.put(new Integer(114), "Function");
        spatial.put(new Integer(5), "Equals");
        spatial.put(new Integer(6), "Disjoint");
        spatial.put(new Integer(7), "Intersects");
        spatial.put(new Integer(8), "Touches");
        spatial.put(new Integer(9), "Crosses");
        spatial.put(new Integer(10), "Within");
        spatial.put(new Integer(11), "Contains");
        spatial.put(new Integer(12), "Overlaps");
        spatial.put(new Integer(13), "Beyond");
        spatial.put(new Integer(4), "BBOX");
        logical.put(new Integer(2), "And");
        logical.put(new Integer(1), "Or");
        logical.put(new Integer(3), "Not");
    }

    public static class FilterTranslator
    extends TransformerBase.TranslatorSupport
    implements FilterVisitor {
        GeometryTransformer.GeometryTranslator geometryEncoder;

        public FilterTranslator(ContentHandler handler) {
            super(handler, "ogc", defaultNamespace);
            this.geometryEncoder = new GeometryTransformer.GeometryTranslator(handler);
            this.addNamespaceDeclarations(this.geometryEncoder);
        }

        public void visit(LogicFilter filter) {
            filter.getFilterType();
            String type = (String)logical.get(new Integer(filter.getFilterType()));
            this.start(type);
            Iterator list = filter.getFilterIterator();
            while (list.hasNext()) {
                ((AbstractFilter)list.next()).accept(this);
            }
            this.end(type);
        }

        public void visit(NullFilter filter) {
            Expression expr = filter.getNullCheckValue();
            String type = (String)comparisions.get(new Integer(filter.getFilterType()));
            this.start(type);
            expr.accept((FilterVisitor)this);
            this.end(type);
        }

        public void visit(FidFilter filter) {
            String[] fids = filter.getFids();
            for (int i = 0; i < fids.length; ++i) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "fid", "fid", "", fids[i]);
                this.element("FeatureId", null, atts);
            }
        }

        public void visit(Filter filter) {
            try {
                this.contentHandler.startElement("", "!--", "!--", this.NULL_ATTS);
                this.chars("Unidentified Filter " + filter.getClass());
                this.contentHandler.endElement("", "--", "--");
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void visit(LikeFilter filter) {
            String wcm = filter.getWildcardMulti();
            String wcs = filter.getWildcardSingle();
            String esc = filter.getEscape();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "wildCard", "wildCard", "", wcm);
            atts.addAttribute("", "singleChar", "singleChar", "", wcs);
            atts.addAttribute("", "escape", "escape", "", esc);
            this.start("PropertyIsLike", atts);
            this.encode(filter.getValue());
            this.element("Literal", filter.getPattern());
            this.end("PropertyIsLike");
        }

        public void visit(BetweenFilter filter) {
            Expression left = filter.getLeftValue();
            Expression right = filter.getRightValue();
            Expression mid = filter.getMiddleValue();
            String type = (String)comparisions.get(new Integer(filter.getFilterType()));
            this.start(type);
            mid.accept((FilterVisitor)this);
            this.start("LowerBoundary");
            left.accept((FilterVisitor)this);
            this.end("LowerBoundary");
            this.start("UpperBoundary");
            right.accept((FilterVisitor)this);
            this.end("UpperBoundary");
            this.end(type);
        }

        public void visit(AttributeExpression expression) {
            this.element("PropertyName", expression.getAttributePath());
        }

        public void visit(MathExpression expression) {
            String type = (String)expressions.get(new Integer(expression.getType()));
            this.start(type);
            this.encode(expression.getLeftValue());
            this.encode(expression.getRightValue());
            this.end(type);
        }

        public void visit(FunctionExpression expression) {
            String type = (String)expressions.get(new Integer(expression.getType()));
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", expression.getName());
            this.start(type, atts);
            Expression[] args = expression.getArgs();
            for (int i = 0; i < args.length; ++i) {
                args[i].accept((FilterVisitor)this);
            }
            this.end(type);
        }

        public void visit(CompareFilter filter) {
            Expression left = filter.getLeftValue();
            Expression right = filter.getRightValue();
            String type = (String)comparisions.get(new Integer(filter.getFilterType()));
            this.start(type);
            left.accept((FilterVisitor)this);
            right.accept((FilterVisitor)this);
            this.end(type);
        }

        public void visit(GeometryFilter filter) {
            Expression left = filter.getLeftGeometry();
            Expression right = filter.getRightGeometry();
            String type = (String)spatial.get(new Integer(filter.getFilterType()));
            this.start(type);
            left.accept((FilterVisitor)this);
            right.accept((FilterVisitor)this);
            this.end(type);
        }

        public void visit(Expression expression) {
        }

        public void visit(LiteralExpression expression) {
            Object value;
            if ((class$com$vividsolutions$jts$geom$Geometry == null ? (class$com$vividsolutions$jts$geom$Geometry = FilterTransformer.class$("com.vividsolutions.jts.geom.Geometry")) : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom((value = expression.getLiteral()).getClass())) {
                this.geometryEncoder.encode((Geometry)value);
            } else {
                this.element("Literal", value.toString());
            }
        }

        public void encode(Expression e) {
            e.accept((FilterVisitor)this);
        }

        public void encode(Filter f) {
            this.start("Filter");
            f.accept((FilterVisitor)this);
            this.end("Filter");
        }

        public void encode(Object o) {
            if (o instanceof Filter) {
                this.encode((Filter)o);
            } else if (o instanceof Expression) {
                this.encode((Expression)o);
            } else {
                throw new IllegalArgumentException("Cannot encode " + (o == null ? "null" : o.getClass().getName()));
            }
        }
    }
}

