/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.PrimativeAttributeType;
import org.geotools.filter.Filter;

public class NumericAttributeType
extends DefaultAttributeType
implements PrimativeAttributeType {
    private Filter filter;

    public NumericAttributeType(String name, Class type, boolean nillable, int min, int max, Object defaultValue, Filter filter) throws IllegalArgumentException {
        super(name, type, nillable, min, max, defaultValue);
        this.filter = filter;
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Numeric requires Number class, not " + type);
        }
    }

    public NumericAttributeType(String name, Class type, boolean nillable, Object defaultValue, Filter filter) throws IllegalArgumentException {
        super(name, type, nillable, defaultValue);
        this.filter = filter;
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Numeric requires Number class, not " + type);
        }
    }

    public Object parse(Object value) throws IllegalArgumentException {
        Object parsed;
        if (value == null) {
            return value;
        }
        if (value.getClass() == this.type || this.type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof Number) {
            return this.convertNumber((Number)value);
        }
        String str = value.toString();
        try {
            parsed = this.parseFromString(str);
            if (parsed != null) {
                return parsed;
            }
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        if ((str.length() == 0 || str.trim().length() == 0) && (parsed = this.parseFromString("0")) != null) {
            return parsed;
        }
        throw new IllegalArgumentException("Cannot parse " + value.getClass());
    }

    public Object duplicate(Object o) {
        return o;
    }

    protected Object parseFromString(String value) throws IllegalArgumentException {
        if (this.type == Byte.class) {
            return Byte.decode(value);
        }
        if (this.type == Short.class) {
            return Short.decode(value);
        }
        if (this.type == Integer.class) {
            return Integer.decode(value);
        }
        if (this.type == Float.class) {
            return Float.valueOf(value);
        }
        if (this.type == Double.class) {
            return Double.valueOf(value);
        }
        if (this.type == Long.class) {
            return Long.decode(value);
        }
        if (this.type == BigInteger.class) {
            return new BigInteger(value);
        }
        if (this.type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (Number.class.isAssignableFrom(this.type)) {
            return new Double(value);
        }
        return null;
    }

    protected Object convertNumber(Number number) {
        if (this.type == Byte.class) {
            return new Byte(number.byteValue());
        }
        if (this.type == Short.class) {
            return new Short(number.shortValue());
        }
        if (this.type == Integer.class) {
            return new Integer(number.intValue());
        }
        if (this.type == Float.class) {
            return new Float(number.floatValue());
        }
        if (this.type == Double.class) {
            return new Double(number.doubleValue());
        }
        if (this.type == Long.class) {
            return new Long(number.longValue());
        }
        if (this.type == BigInteger.class) {
            return BigInteger.valueOf(number.longValue());
        }
        if (this.type == BigDecimal.class) {
            return BigDecimal.valueOf(number.longValue());
        }
        throw new RuntimeException("AttributeGT.Numeric cannot parse " + number);
    }

    public Filter getRestriction() {
        return this.filter;
    }
}

