/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

public class ScreenMap {
    int[] pixels;
    int width;
    int height;
    private int minx;
    private int miny;

    public ScreenMap() {
    }

    public ScreenMap(int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        this.minx = x;
        this.miny = y;
        int arraySize = width * height / 32 + 1;
        this.pixels = new int[arraySize];
    }

    public void set(int x, int y, boolean value) {
        if (x - this.minx < 0 || x - this.minx > this.width - 1 || y - this.miny < 0 || y - this.miny > this.height - 1) {
            return;
        }
        int bit = this.bit(x - this.minx, y - this.miny);
        int index = bit / 32;
        int offset = bit % 32;
        int mask = 1;
        mask <<= offset;
        if (value) {
            this.pixels[index] = this.pixels[index] | mask;
        } else {
            int tmp = this.pixels[index];
            tmp ^= 0xFFFFFFFF;
            tmp |= mask;
            this.pixels[index] = tmp ^= 0xFFFFFFFF;
        }
    }

    public boolean get(int x, int y) {
        if (x - this.minx < 0 || x - this.minx > this.width - 1 || y - this.miny < 0 || y - this.miny > this.height - 1) {
            return true;
        }
        int bit = this.bit(x - this.minx, y - this.miny);
        int index = bit / 32;
        int offset = bit % 32;
        int mask = 1 << offset;
        try {
            return (this.pixels[index] & mask) != 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    private int bit(int x, int y) {
        return this.width * y + x;
    }
}

